package com.vaadin.spring.roo.addon.annotations;

/**
 * Indicates a bean property (accessor method or field) whose value represents
 * is shown to the user.
 * 
 * <p>
 * Only one property of an (entity) bean should be annotated with
 * {@link RooVaadinDisplayProperty}. If the annotation is on an accessor
 * (getter) method, it does not need to correspond to a field.
 * </p>
 *
 * <p>
 * Entity views ({@link RooVaadinEntityView}) use this property to determine
 * which entity property is shown to the user e.g. for referenced entities
 * unless some other property is explicitly specified in the entity view. The
 * default behavior, if no property is annotated with
 * {@link RooVaadinDisplayProperty}, is to use the "name" field, or if none is
 * present, to use toString().
 * </p>
 *
 * <p>
 * This annotation is dual licensed under both GNU General Public License,
 * Version 3 and also Apache License, Version 2.0. You may apply your choice of
 * GPLv3 or ASLv2 to your use of the this annotation.
 * </p>
 */
public @interface RooVaadinDisplayProperty {

}
