package com.vaadin.spring.roo.addon.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates a type that lists the CRUD editors for ROO entities in the project.
 * 
 * <p>
 * This annotation will cause ROO to produce code that lists all the
 * {@link RooVaadinEntityView} classes in the project. Importantly, such code
 * does NOT depend on any singletons and is intended to safely serialize. In the
 * current release this code will be emitted to an ITD.
 * 
 * If the user has defined a method with the same name as one that would be
 * generated, the user defined method will not be overridden in the ITD.
 * 
 * <p>
 * This annotation is dual licensed under both GNU General Public License,
 * Version 3 and also Apache License, Version 2.0. You may apply your choice of
 * GPLv3 or ASLv2 to your use of the this annotation.
 */
@Retention(RetentionPolicy.SOURCE)
@Target(ElementType.TYPE)
public @interface RooVaadinEntityManagerView {

}
