package com.vaadin.spring.roo.addon.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates a type that acts as a simple CRUD editor for a ROO entity.
 * 
 * <p>
 * This annotation will cause ROO to produce code that supports the editing of
 * an entity (if necessary). Importantly, such code does NOT depend on any
 * singletons and is intended to safely serialize. In the current release this
 * code will be emitted to an ITD.
 * 
 * <p>
 * Setting this annotation generates any required helper methods for editing the
 * entity in the ITD.
 * 
 * <p>
 * The {@link RooVaadinEntityView#formBackingObject()} property defines the
 * RooEntity type which is managed through this view.
 * 
 * <p>
 * This annotation is dual licensed under both GNU General Public License,
 * Version 3 and also Apache License, Version 2.0. You may apply your choice of
 * GPLv3 or ASLv2 to your use of the this annotation.
 */
@Retention(RetentionPolicy.SOURCE)
@Target(ElementType.TYPE)
public @interface RooVaadinEntityView {

	/**
	 * Every entity view is responsible for a single form backing object (
	 * RooEntity). The form backing object defined here class will be exposed
	 * for editing.
	 */
	Class<?> formBackingObject();

	/**
	 * Supports deleting an entity.
	 * 
	 * @return indicates if the delete functionality should be provided in the
	 *         editor view (defaults to "true"; optional)
	 */
	boolean delete() default true;

	/**
	 * Supports creation of a new entity.
	 * 
	 * @return indicates if the create functionality should be provided in the
	 *         editor view (defaults to "true"; optional)
	 */
	boolean create() default true;

	/**
	 * Supports alteration of an existing entity.
	 * 
	 * @return indicates if the update functionality should be provided in the
	 *         editor view (defaults to "true"; optional)
	 */
	boolean update() default true;

}
