package com.vaadin.spring.roo.addon.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates a type that acts as a simple CRUD editor form for a ROO entity.
 * 
 * <p>
 * This annotation is for cases where the Vaadin Form class is not used, but the
 * form is composed by hand or using the Vaadin Visual Editor.
 *
 * <p>
 * This annotation will cause ROO to produce code that supports the editing of
 * an entity (if necessary). Importantly, such code does NOT depend on any
 * singletons and is intended to safely serialize. In the current release this
 * code will be emitted to an ITD.
 *
 * <p>
 * Setting this annotation generates any required helper methods for editing the
 * entity in the ITD.
 *
 * <p>
 * The {@link RooVaadinVisuallyComposableEntityForm#formBackingObject()}
 * property defines the RooEntity type which is managed through this view.
 *
 * <p>
 * This annotation is dual licensed under both GNU General Public License,
 * Version 3 and also Apache License, Version 2.0. You may apply your choice of
 * GPLv3 or ASLv2 to your use of the this annotation.
 */
@Retention(RetentionPolicy.SOURCE)
@Target(ElementType.TYPE)
public @interface RooVaadinVisuallyComposableEntityForm {

	/**
	 * Every entity editor form is responsible for a single form backing object
	 * (RooEntity). The form backing object defined here class will be exposed
	 * for editing.
	 */
	Class<?> formBackingObject();

}
