package com.vaadin.spring.roo.addon.entityform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.roo.addon.entity.EntityMetadata;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.details.MethodMetadata;
import org.springframework.roo.classpath.itd.AbstractItdTypeDetailsProvidingMetadataItem;
import org.springframework.roo.classpath.scanner.MemberDetailsScanner;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.support.style.ToStringCreator;
import org.springframework.roo.support.util.Assert;

import com.vaadin.spring.roo.addon.entityview.DomainTypeCaptionMethodBuilder;
import com.vaadin.spring.roo.addon.entityview.PersistenceMethodBuilder;
import com.vaadin.spring.roo.addon.entityview.VaadinEntityMetadataDetails;

/**
 * Base class for EntityEditor metadata, both when using and when not using the
 * Vaadin Form component.
 */
public abstract class AbstractVaadinEntityFormMetadataItem extends
		AbstractItdTypeDetailsProvidingMetadataItem {

	private MetadataService metadataService;
	protected final MemberDetailsScanner memberDetailsScanner;

	private final VaadinEntityMetadataDetails vaadinEntityDetails;
	private boolean useJpaContainer;

	public AbstractVaadinEntityFormMetadataItem(String identifier,
			JavaType aspectName,
			PhysicalTypeMetadata governorPhysicalTypeMetadata,
			MetadataService metadataService,
			MemberDetailsScanner memberDetailsScanner,
			VaadinEntityMetadataDetails vaadinEntityDetails,
			boolean useJpaContainer) {
		super(identifier, aspectName, governorPhysicalTypeMetadata);

		Assert.notNull(metadataService, "Metadata service required");
		Assert.notNull(memberDetailsScanner, "Member details scanner required");
		Assert.notNull(vaadinEntityDetails, "Entity details required");

		this.vaadinEntityDetails = vaadinEntityDetails;
		this.useJpaContainer = useJpaContainer;

		this.metadataService = metadataService;
		this.memberDetailsScanner = memberDetailsScanner;
	}

	@Override
	public String toString() {
		ToStringCreator tsc = new ToStringCreator(this);
		tsc.append("identifier", getId());
		tsc.append("valid", valid);
		tsc.append("aspectName", aspectName);
		tsc.append("destinationType", destination);
		tsc.append("governor", governorPhysicalTypeMetadata.getId());
		tsc.append("itdTypeDetails", itdTypeDetails);
		return tsc.toString();
	}

	protected MetadataService getMetadataService() {
		return metadataService;
	}
	
	protected VaadinEntityMetadataDetails getVaadinEntityDetails() {
		return vaadinEntityDetails;
	}

	protected EntityMetadata getEntityMetadata() {
		return vaadinEntityDetails.getEntityMetadata();
	}

	protected JavaType getEntityType() {
		return vaadinEntityDetails.getJavaType();
	}

	protected boolean isUseJpaContainer() {
		return useJpaContainer;
	}

	protected List<MethodMetadata> getDomainTypeCaptionMethods(
			Map<JavaSymbolName, JavaType> specialDomainTypes) {
		List<MethodMetadata> methods = new ArrayList<MethodMetadata>();

		DomainTypeCaptionMethodBuilder captionBuilder = new DomainTypeCaptionMethodBuilder(
				governorTypeDetails, getId(), vaadinEntityDetails,
				builder.getImportRegistrationResolver(), specialDomainTypes,
				metadataService, memberDetailsScanner);

		for (MethodMetadata md : captionBuilder.getDomainTypeCaptionMethods()) {
			methods.add(md);
		}

		return methods;
	}

	protected List<MethodMetadata> getEntityMethods() {
		PersistenceMethodBuilder persistenceBuilder = new PersistenceMethodBuilder(
				governorTypeDetails, getId(), vaadinEntityDetails,
				builder.getImportRegistrationResolver(), metadataService,
				memberDetailsScanner);

		return persistenceBuilder.getEntityMetadataMethods();
	}

	protected String getClassName(JavaType type) {
		return type.getNameIncludingTypeParameters(false,
				builder.getImportRegistrationResolver());
	}

}
