package com.vaadin.spring.roo.addon.entityform;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;

import org.springframework.roo.addon.entity.EntityMetadata;
import org.springframework.roo.addon.javabean.JavaBeanMetadata;
import org.springframework.roo.classpath.PhysicalTypeIdentifier;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.itd.AbstractItdMetadataProvider;
import org.springframework.roo.classpath.itd.ItdTypeDetailsProvidingMetadataItem;
import org.springframework.roo.classpath.scanner.MemberDetails;
import org.springframework.roo.model.JavaPackage;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.Path;

import com.vaadin.spring.roo.addon.VaadinRooUtils;
import com.vaadin.spring.roo.addon.abstractentityview.VaadinAbstractEntityViewMetadata;

/**
 * Abstract base class for Vaadin entity form metadata providers. 
 */
public abstract class AbstractVaadinEntityFormMetadataProvider extends
		AbstractItdMetadataProvider {

	private static Logger logger = Logger
	.getLogger(AbstractVaadinEntityFormMetadataProvider.class.getName());

	protected ItdTypeDetailsProvidingMetadataItem constructMetadata(
			String metadataIdentificationString, JavaType aspectName,
			PhysicalTypeMetadata governorPhysicalTypeMetadata,
			String itdFilename, JavaType formBackingObject) {

		// We know governor type details are non-null and can be safely cast

		// Lookup the form backing object's metadata
		Path path = Path.SRC_MAIN_JAVA;

		String physicalTypeMetadataKey = PhysicalTypeIdentifier.createIdentifier(
				formBackingObject, path);
		String entityMetadataKey = EntityMetadata.createIdentifier(formBackingObject,
				path);

		// We need to lookup the metadata we depend on
		EntityMetadata entityMetadata = (EntityMetadata) metadataService
				.get(entityMetadataKey);

		// We need to abort if we couldn't find dependent metadata
		if (entityMetadata == null || !entityMetadata.isValid()) {
			return null;
		}

		// We need to be informed if our dependent metadata changes
		metadataDependencyRegistry.registerDependency(physicalTypeMetadataKey,
				metadataIdentificationString);
		metadataDependencyRegistry.registerDependency(entityMetadataKey,
				metadataIdentificationString);
		metadataDependencyRegistry.registerDependency(
				JavaBeanMetadata.createIdentifier(formBackingObject, path),
				metadataIdentificationString);

		// We also need to be informed if a referenced type is changed
		MemberDetails memberDetails = VaadinRooUtils.getMemberDetails(formBackingObject,
				metadataService, memberDetailsScanner, this.getClass()
						.getName());
		Collection<JavaType> specialDomainTypes = VaadinRooUtils
				.getSpecialDomainTypes(metadataService, formBackingObject,
						memberDetails, true).values();
		// unique types only
		for (JavaType type : new LinkedHashSet<JavaType>(specialDomainTypes)) {
			// TODO what metadata to depend on?
			metadataDependencyRegistry.registerDependency(
					PhysicalTypeIdentifier.createIdentifier(type, path),
					metadataIdentificationString);
		}

		// find any class with the annotation @RooVaadinAbstractEntityView
		// same package will contain helper classes

		// TODO this is not the best way - could pick the wrong one if multiple
		// exist etc. - and depends on such a class existing

		VaadinAbstractEntityViewMetadata abstractViewMetadata = null;

		String providesType = VaadinAbstractEntityViewMetadata
				.getMetadataIdentiferString();
		List<String> allMids = VaadinRooUtils.scanPotentialTypeMids(
				metadataService, fileManager, providesType);
		for (String mid : allMids) {
			if (VaadinAbstractEntityViewMetadata.isValid(mid)) {
				abstractViewMetadata = (VaadinAbstractEntityViewMetadata) metadataService
						.get(mid);
				if (abstractViewMetadata != null) {
					break;
				}
			}
		}

		// must have the package and JPAContainer use information
		if (abstractViewMetadata == null) {
			return null;
		}

		boolean useJpaContainer = abstractViewMetadata.isUseJpaContainer();

		JavaType abstractViewClass = VaadinAbstractEntityViewMetadata
				.getJavaType(abstractViewMetadata.getId());
		JavaPackage utilPackage = abstractViewClass.getPackage();

		return createMetadataItem(metadataIdentificationString, aspectName,
				governorPhysicalTypeMetadata, formBackingObject,
				entityMetadata, utilPackage, useJpaContainer);
	}

	protected abstract ItdTypeDetailsProvidingMetadataItem createMetadataItem(
			String metadataIdentificationString, JavaType aspectName,
			PhysicalTypeMetadata governorPhysicalTypeMetadata,
			JavaType formBackingObject, EntityMetadata entityMetadata,
			JavaPackage utilPackage, boolean useJpaContainer);


}
