package com.vaadin.spring.roo.addon.entityform;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.springframework.roo.addon.entity.EntityMetadata;
import org.springframework.roo.classpath.details.BeanInfoUtils;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetails;
import org.springframework.roo.classpath.details.FieldMetadata;
import org.springframework.roo.classpath.details.ItdTypeDetailsBuilder;
import org.springframework.roo.classpath.details.MethodMetadata;
import org.springframework.roo.classpath.details.MethodMetadataBuilder;
import org.springframework.roo.classpath.itd.InvocableMemberBodyBuilder;
import org.springframework.roo.classpath.scanner.MemberDetails;
import org.springframework.roo.classpath.scanner.MemberDetailsScanner;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.DataType;
import org.springframework.roo.model.ImportRegistrationResolver;
import org.springframework.roo.model.JavaPackage;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.Path;

import com.vaadin.spring.roo.addon.VaadinRooUtils;
import com.vaadin.spring.roo.addon.entityview.PersistenceMethodBuilder;
import com.vaadin.spring.roo.addon.entityview.VaadinEntityMetadataDetails;

public class AutomaticFormMethodBuilder extends FormMethodBuilder {

	public static final String BEAN_FIELD_WRAPPER_PACKAGE = "org.vaadin.addon.customfield.beanfield";
	public static final String BEAN_FIELD_WRAPPER_CLASS_SUFFIX = "BeanFieldWrapper";
	public static final String BEAN_SET_FIELD_WRAPPER_CLASS_SUFFIX = "BeanSetFieldWrapper";

	private static final String LOCALE_CONTEXT_HOLDER_CLASS = "org.springframework.context.i18n.LocaleContextHolder";

	public static final String GET_FORM_FIELD_FACTORY_METHOD = "getFormFieldFactory";

	public AutomaticFormMethodBuilder(
			ClassOrInterfaceTypeDetails governorTypeDetails, String metadataId,
			VaadinEntityMetadataDetails vaadinEntityDetails,
			JavaPackage utilPackage, ImportRegistrationResolver importResolver,
			Map<JavaSymbolName, JavaType> specialDomainTypes,
			MetadataService metadataService,
			MemberDetailsScanner memberDetailsScanner,
			ItdTypeDetailsBuilder builder, boolean useJpaContainer) {
		super(governorTypeDetails, metadataId, vaadinEntityDetails,
				utilPackage, importResolver, specialDomainTypes,
				metadataService, memberDetailsScanner, builder, useJpaContainer);
	}

	public List<MethodMetadata> getFormFieldFactoryMethods() {
		List<MethodMetadata> methods = new ArrayList<MethodMetadata>();

		JavaSymbolName methodName = new JavaSymbolName(
				GET_FORM_FIELD_FACTORY_METHOD);

		MethodMetadata method = VaadinRooUtils.methodExists(methodName,
				governorTypeDetails);
		// create sub-methods even if the field factory method exists

		JavaType returnType = new JavaType(
				VaadinClassNames.FORM_FIELD_FACTORY_CLASS);

		String fieldFactoryClassName = getClassName(VaadinClassNames.DEFAULT_FIELD_FACTORY_CLASS);

		String fieldClassName = getClassName(VaadinClassNames.FIELD_CLASS);
		String itemClassName = getClassName(VaadinClassNames.ITEM_CLASS);
		String componentClassName = getClassName(VaadinClassNames.COMPONENT_CLASS);

		InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
		bodyBuilder.appendFormalLine("return new " + fieldFactoryClassName
				+ "() {");
		bodyBuilder.indent();
		bodyBuilder.appendFormalLine("@Override");
		bodyBuilder.appendFormalLine("public " + fieldClassName
				+ " createField(" + itemClassName
				+ " item, Object propertyId, " + componentClassName
				+ " uiContext) {");
		bodyBuilder.indent();

		methods.addAll(buildCreateFormFieldBody(fieldClassName, bodyBuilder));

		bodyBuilder.indentRemove();
		bodyBuilder.appendFormalLine("}");
		bodyBuilder.indentRemove();
		bodyBuilder.appendFormalLine("};");

		if (method != null) {
			methods.add(method);
		} else {
			MethodMetadataBuilder methodBuilder = new MethodMetadataBuilder(
					getId(), Modifier.PUBLIC, methodName, returnType,
					bodyBuilder);
			methods.add(methodBuilder.build());
		}

		return methods;
	}

	private List<MethodMetadata> buildCreateFormFieldBody(
			String fieldClassName, InvocableMemberBodyBuilder bodyBuilder) {
		List<MethodMetadata> methods = new ArrayList<MethodMetadata>();

		bodyBuilder.appendFormalLine(fieldClassName + " field = null;");

		// enums, collections, domain type references, ... - anything that
		// requires customized field generation
		Map<String, JavaType> fieldSpecialTypes = getFieldSpecialTypes();

		bodyBuilder.appendFormalLine("if ("
				+ PersistenceMethodBuilder.GET_ID_PROPERTY_METHOD
				+ "().equals(propertyId) || "
				+ PersistenceMethodBuilder.GET_VERSION_PROPERTY_METHOD
				+ "().equals(propertyId)) {");
		bodyBuilder.indent();
		bodyBuilder.appendFormalLine("return null;");
		bodyBuilder.indentRemove();
		boolean haveSpecialTypes = !fieldSpecialTypes.isEmpty();
		if (haveSpecialTypes) {
			MemberDetails memberDetails = getMemberDetails();
			for (Map.Entry<String, JavaType> entry : fieldSpecialTypes
					.entrySet()) {
				String property = entry.getKey();
				JavaType type = entry.getValue();
				bodyBuilder.appendFormalLine("} else if (\"" + property
						+ "\".equals(propertyId)) {");
				FieldMetadata fieldMetadata = BeanInfoUtils
						.getFieldForPropertyName(memberDetails, new JavaSymbolName(property));
				if (null == fieldMetadata) {
					// should not happen with getFieldSpecialTypes()
					continue;
				} else if (VaadinRooUtils.isEnumType(getMetadataService(), type)) {
					// for enums, no wrapping
					bodyBuilder.indent();
					JavaSymbolName methodName = new JavaSymbolName("build"
							+ fieldMetadata.getFieldName()
									.getSymbolNameCapitalisedFirstLetter()
							+ "Combo");
					methods.add(buildDomainTypeComboBoxMethod(type, methodName));
					bodyBuilder.appendFormalLine("field = "
							+ methodName.getSymbolName() + "();");
					bodyBuilder
							.appendFormalLine("field.setCaption(createCaptionByPropertyId(propertyId));");
					bodyBuilder.indentRemove();
				} else if (isSimpleDomainType(type, fieldMetadata)) {
					EntityMetadata em = (EntityMetadata) getMetadataService()
							.get(EntityMetadata.createIdentifier(type,
									Path.SRC_MAIN_JAVA));

					bodyBuilder.indent();
					JavaSymbolName methodName = new JavaSymbolName("build"
							+ fieldMetadata.getFieldName()
									.getSymbolNameCapitalisedFirstLetter()
							+ "Combo");
					methods.add(buildDomainTypeComboBoxMethod(type, methodName));
					String selectClassName = getClassName(VaadinClassNames.COMBO_BOX_CLASS);
					bodyBuilder.appendFormalLine(selectClassName + " combo = "
							+ methodName.getSymbolName() + "();");

					// import BeanFieldWrapper
					JavaType wrapperType = new JavaType(
							BEAN_FIELD_WRAPPER_PACKAGE + "."
									+ BEAN_FIELD_WRAPPER_CLASS_SUFFIX, 0,
							DataType.TYPE, null,
							Collections.singletonList(type));
					String wrapperClassName = getClassName(wrapperType);
					String containerMethod = getContainerCreationMethodName(
							type).getSymbolName();
					String entityClassName = getClassName(type);
					bodyBuilder.appendFormalLine("field = new "
							+ wrapperClassName + "(combo, " + entityClassName
							+ ".class, " + containerMethod + "(), \""
							+ em.getIdentifierField().getFieldName() + "\");");

					bodyBuilder
							.appendFormalLine("field.setCaption(createCaptionByPropertyId(propertyId));");
					bodyBuilder.indentRemove();
				} else if (isSimpleUnorderedDomainTypeCollection(type,
						fieldMetadata)) {
					bodyBuilder.indent();
					// first type parameter is the class based on the above if
					JavaType entityType = type.getParameters().get(0);
					EntityMetadata em = (EntityMetadata) getMetadataService()
							.get(EntityMetadata.createIdentifier(entityType,
									Path.SRC_MAIN_JAVA));

					JavaSymbolName methodName = new JavaSymbolName("build"
							+ fieldMetadata.getFieldName()
									.getSymbolNameCapitalisedFirstLetter()
							+ "MultiSelect");
					methods.add(buildDomainTypeMultiSelectMethod(type,
							methodName));
					String selectClassName = getClassName(MULTI_SELECT_FIELD_CLASS);
					bodyBuilder.appendFormalLine(selectClassName + " select = "
							+ methodName.getSymbolName() + "();");

					// import BeanSetFieldWrapper
					JavaType wrapperType = new JavaType(
							BEAN_FIELD_WRAPPER_PACKAGE + "."
									+ BEAN_SET_FIELD_WRAPPER_CLASS_SUFFIX, 0,
							DataType.TYPE, null,
							Collections.singletonList(entityType));
					String wrapperClassName = getClassName(wrapperType);
					String containerMethod = getContainerCreationMethodName(
							entityType).getSymbolName();
					String entityClassName = getClassName(entityType);
					bodyBuilder.appendFormalLine("field = new "
							+ wrapperClassName + "(select, " + entityClassName
							+ ".class, " + containerMethod + "(), \""
							+ em.getIdentifierField().getFieldName() + "\");");

					bodyBuilder
							.appendFormalLine("field.setCaption(createCaptionByPropertyId(propertyId));");
					bodyBuilder.indentRemove();
				}
			}
		}

		bodyBuilder.appendFormalLine("} else {");
		bodyBuilder.indent();

		// beginning of default branch: use super.createField(...)
		bodyBuilder
				.appendFormalLine("field = super.createField(item, propertyId, uiContext);");

		// default null representation for text fields
		String textFieldClassName = getClassName(VaadinClassNames.TEXT_FIELD_CLASS);
		bodyBuilder.appendFormalLine("if (field instanceof "
				+ textFieldClassName + ") {");
		bodyBuilder.indent();
		bodyBuilder.appendFormalLine("((" + textFieldClassName
				+ ") field).setNullRepresentation(\"\");");
		bodyBuilder.indentRemove();
		bodyBuilder.appendFormalLine("}");

		// locale for date fields
		String dateFieldClassName = getClassName(VaadinClassNames.DATE_FIELD_CLASS);
		String localeContextHolderClassName = getClassName(LOCALE_CONTEXT_HOLDER_CLASS);
		bodyBuilder.appendFormalLine("if (field instanceof "
				+ dateFieldClassName + ") {");
		bodyBuilder.indent();
		bodyBuilder.appendFormalLine("((" + dateFieldClassName
				+ ") field).setLocale(" + localeContextHolderClassName
				+ ".getLocale());");

		// workaround to resolve #6406: see #6407
		bodyBuilder.appendFormalLine("field.setInvalidAllowed(true);");

		bodyBuilder.indentRemove();
		bodyBuilder.appendFormalLine("}");

		// end of default branch: use super.createField(...)

		bodyBuilder.indentRemove();
		bodyBuilder.appendFormalLine("}");

		bodyBuilder.appendFormalLine("return field;");

		return methods;
	}

}
