package com.vaadin.spring.roo.addon.entityform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import org.springframework.roo.classpath.PhysicalTypeIdentifierNamingUtils;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.details.MethodMetadata;
import org.springframework.roo.classpath.itd.ItdSourceFileComposer;
import org.springframework.roo.classpath.scanner.MemberDetails;
import org.springframework.roo.classpath.scanner.MemberDetailsScanner;
import org.springframework.roo.metadata.MetadataIdentificationUtils;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.JavaPackage;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.Path;
import org.springframework.roo.support.util.Assert;

import com.vaadin.spring.roo.addon.VaadinRooUtils;
import com.vaadin.spring.roo.addon.annotations.RooVaadinAutomaticEntityForm;
import com.vaadin.spring.roo.addon.entityview.VaadinEntityMetadataDetails;

/**
 * Metadata item for the {@link RooVaadinAutomaticEntityForm} annotation, used
 * to generate form helper methods.
 *
 * The current version requires the beans to have also entity metadata, but this
 * could be relaxed in the future to allow non-entity bean forms.
 */
public class VaadinAutomaticEntityFormMetadata extends
		AbstractVaadinEntityFormMetadataItem {

	private static final String PROVIDES_TYPE_STRING = VaadinAutomaticEntityFormMetadata.class
			.getName();
	private static final String PROVIDES_TYPE = MetadataIdentificationUtils
			.create(PROVIDES_TYPE_STRING);
	private static final JavaType AUTOMATIC_ENTITY_FORM_ANNOTATION_TYPE = new JavaType(
			RooVaadinAutomaticEntityForm.class.getName());

	private static Logger logger = Logger
			.getLogger(VaadinAutomaticEntityFormMetadata.class.getName());

	private final VaadinAutomaticEntityFormAnnotationValues annotationValues;
	private final JavaPackage utilPackage;

	public VaadinAutomaticEntityFormMetadata(String identifier,
			JavaType aspectName,
			PhysicalTypeMetadata governorPhysicalTypeMetadata,
			MetadataService metadataService,
			MemberDetailsScanner memberDetailsScanner,
			VaadinAutomaticEntityFormAnnotationValues annotationValues,
			VaadinEntityMetadataDetails vaadinEntityDetails,
			JavaPackage utilPackage, boolean useJpaContainer) {
		super(identifier, aspectName, governorPhysicalTypeMetadata,
				metadataService, memberDetailsScanner, vaadinEntityDetails,
				useJpaContainer);
		this.utilPackage = utilPackage;

		Assert.isTrue(isValid(identifier), "Metadata identification string '"
				+ identifier + "' does not appear to be a valid");
		Assert.notNull(annotationValues, "Annotation values required");

		this.annotationValues = annotationValues;

		if (!isValid()) {
			return;
		}

		addMethods();

		// Create a representation of the desired output ITD
		itdTypeDetails = builder.build();

		new ItdSourceFileComposer(itdTypeDetails);
	}

	public static final String getMetadataIdentiferString() {
		return PROVIDES_TYPE_STRING;
	}

	public static final String getMetadataIdentiferType() {
		return PROVIDES_TYPE;
	}

	public static final String createIdentifier(JavaType javaType, Path path) {
		return PhysicalTypeIdentifierNamingUtils.createIdentifier(
				PROVIDES_TYPE_STRING, javaType, path);
	}

	public static final JavaType getJavaType(String metadataIdentificationString) {
		return PhysicalTypeIdentifierNamingUtils.getJavaType(
				PROVIDES_TYPE_STRING, metadataIdentificationString);
	}

	public static final Path getPath(String metadataIdentificationString) {
		return PhysicalTypeIdentifierNamingUtils.getPath(PROVIDES_TYPE_STRING,
				metadataIdentificationString);
	}

	public static boolean isValid(String metadataIdentificationString) {
		return PhysicalTypeIdentifierNamingUtils.isValid(PROVIDES_TYPE_STRING,
				metadataIdentificationString);
	}

	public static JavaType getAnnotationType() {
		return AUTOMATIC_ENTITY_FORM_ANNOTATION_TYPE;
	}

	private void addMethods() {
		MemberDetails memberDetails = VaadinRooUtils.getMemberDetails(
				getEntityType(), getMetadataService(), memberDetailsScanner,
				this.getClass().getName());
		
		Map<JavaSymbolName, JavaType> specialDomainTypes = VaadinRooUtils
				.getSpecialDomainTypes(getMetadataService(), getEntityType(), memberDetails, false);

		for (MethodMetadata method : getFormMethods(specialDomainTypes)) {
			builder.addMethod(method);
		}

		for (MethodMetadata method : getDomainTypeCaptionMethods(specialDomainTypes)) {
			builder.addMethod(method);
		}

		for (MethodMetadata method : getEntityMethods()) {
			builder.addMethod(method);
		}
	}

	private List<MethodMetadata> getFormMethods(
			Map<JavaSymbolName, JavaType> specialDomainTypes) {
		List<MethodMetadata> methods = new ArrayList<MethodMetadata>();

		AutomaticFormMethodBuilder formBuilder = new AutomaticFormMethodBuilder(
				governorTypeDetails, getId(), getVaadinEntityDetails(),
				utilPackage, builder.getImportRegistrationResolver(),
				specialDomainTypes, getMetadataService(), memberDetailsScanner,
				builder, isUseJpaContainer());

		for (MethodMetadata md : formBuilder.getFormFieldFactoryMethods()) {
			methods.add(md);
		}

		// this can also add fields as a side effect
		for (MethodMetadata md : formBuilder.getDomainTypeContainerMethods()) {
			methods.add(md);
		}

		methods.add(formBuilder.getGetEntityClassMethod());

		return methods;
	}

}
