package com.vaadin.spring.roo.addon.entityform;

import java.util.Map;
import java.util.logging.Logger;

import org.springframework.roo.classpath.PhysicalTypeIdentifierNamingUtils;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.details.MethodMetadata;
import org.springframework.roo.classpath.itd.ItdSourceFileComposer;
import org.springframework.roo.classpath.scanner.MemberDetails;
import org.springframework.roo.classpath.scanner.MemberDetailsScanner;
import org.springframework.roo.metadata.MetadataIdentificationUtils;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.JavaPackage;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.Path;
import org.springframework.roo.support.util.Assert;

import com.vaadin.spring.roo.addon.VaadinRooUtils;
import com.vaadin.spring.roo.addon.annotations.RooVaadinVisuallyComposableEntityForm;
import com.vaadin.spring.roo.addon.entityview.VaadinEntityMetadataDetails;

/**
 * Metadata item for the {@link RooVaadinVisuallyComposableEntityForm}
 * annotation, used to generate form helper methods.
 *
 * The current version requires the beans to have also entity metadata, but this
 * could be relaxed in the future to allow non-entity bean forms.
 */
public class VaadinVisuallyComposableEntityFormMetadata extends
		AbstractVaadinEntityFormMetadataItem {

	private static final String PROVIDES_TYPE_STRING = VaadinVisuallyComposableEntityFormMetadata.class
			.getName();
	private static final String PROVIDES_TYPE = MetadataIdentificationUtils
			.create(PROVIDES_TYPE_STRING);
	private static final JavaType VISUALLY_COMPOSABLE_ENTITY_FORM_ANNOTATION_TYPE = new JavaType(
			RooVaadinVisuallyComposableEntityForm.class.getName());

	private static Logger logger = Logger
			.getLogger(VaadinVisuallyComposableEntityFormMetadata.class
					.getName());

	private final VaadinVisuallyComposableEntityFormAnnotationValues annotationValues;

	public VaadinVisuallyComposableEntityFormMetadata(
			String identifier,
			JavaType aspectName,
			PhysicalTypeMetadata governorPhysicalTypeMetadata,
			MetadataService metadataService,
			MemberDetailsScanner memberDetailsScanner,
			VaadinVisuallyComposableEntityFormAnnotationValues annotationValues,
			VaadinEntityMetadataDetails vaadinEntityDetails,
			JavaPackage utilPackage, boolean useJpaContainer) {
		super(identifier, aspectName, governorPhysicalTypeMetadata,
				metadataService, memberDetailsScanner, vaadinEntityDetails,
				useJpaContainer);

		Assert.isTrue(isValid(identifier), "Metadata identification string '"
				+ identifier + "' does not appear to be a valid");
		Assert.notNull(annotationValues, "Annotation values required");

		this.annotationValues = annotationValues;

		if (!isValid()) {
			return;
		}

		MemberDetails memberDetails = VaadinRooUtils.getMemberDetails(
				getEntityType(), getMetadataService(), memberDetailsScanner,
				this.getClass().getName());
		Map<JavaSymbolName, JavaType> specialDomainTypes = VaadinRooUtils
				.getSpecialDomainTypes(
				getMetadataService(), vaadinEntityDetails.getJavaType(),
				memberDetails, false);

		VisuallyComposableFormMethodBuilder formBuilder = new VisuallyComposableFormMethodBuilder(
				governorTypeDetails, getId(), vaadinEntityDetails, utilPackage,
				builder.getImportRegistrationResolver(), specialDomainTypes,
				getMetadataService(), memberDetailsScanner, builder,
				isUseJpaContainer());

		addMethods(formBuilder, specialDomainTypes);

		// Create a representation of the desired output ITD
		itdTypeDetails = builder.build();

		new ItdSourceFileComposer(itdTypeDetails);
	}

	public static final String getMetadataIdentiferString() {
		return PROVIDES_TYPE_STRING;
	}

	public static final String getMetadataIdentiferType() {
		return PROVIDES_TYPE;
	}

	public static final String createIdentifier(JavaType javaType, Path path) {
		return PhysicalTypeIdentifierNamingUtils.createIdentifier(
				PROVIDES_TYPE_STRING, javaType, path);
	}

	public static final JavaType getJavaType(String metadataIdentificationString) {
		return PhysicalTypeIdentifierNamingUtils.getJavaType(
				PROVIDES_TYPE_STRING, metadataIdentificationString);
	}

	public static final Path getPath(String metadataIdentificationString) {
		return PhysicalTypeIdentifierNamingUtils.getPath(PROVIDES_TYPE_STRING,
				metadataIdentificationString);
	}

	public static boolean isValid(String metadataIdentificationString) {
		return PhysicalTypeIdentifierNamingUtils.isValid(PROVIDES_TYPE_STRING,
				metadataIdentificationString);
	}

	public static JavaType getAnnotationType() {
		return VISUALLY_COMPOSABLE_ENTITY_FORM_ANNOTATION_TYPE;
	}

	protected void addMethods(VisuallyComposableFormMethodBuilder formBuilder,
			Map<JavaSymbolName, JavaType> specialDomainTypes) {

		builder.addMethod(formBuilder.getGetBeanPropertiesMethod());

		// this adds a field as a side effect
		for (MethodMetadata method : formBuilder.getFieldMapMethods()) {
			builder.addMethod(method);
		}

		// this adds a field as a side effect
		for (MethodMetadata method : formBuilder.getConverterMapMethods()) {
			builder.addMethod(method);
		}

		for (MethodMetadata method : formBuilder
				.getDomainTypeContainerMethods()) {
			builder.addMethod(method);
		}

		for (MethodMetadata method : getDomainTypeCaptionMethods(specialDomainTypes)) {
			builder.addMethod(method);
		}

		for (MethodMetadata method : getEntityMethods()) {
			builder.addMethod(method);
		}

		for (MethodMetadata method : formBuilder.getFormLogicMethods()) {
			builder.addMethod(method);
		}

		builder.addMethod(formBuilder.getGetEntityClassMethod());

	}


}
