package com.vaadin.spring.roo.addon.entityform;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.addon.entity.EntityMetadata;
import org.springframework.roo.classpath.PhysicalTypeIdentifier;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.itd.ItdTypeDetailsProvidingMetadataItem;
import org.springframework.roo.model.JavaPackage;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.Path;

import com.vaadin.spring.roo.addon.entityview.VaadinEntityMetadataDetails;

/**
 * Provides {@link VaadinVisuallyComposableEntityFormMetadata}, creating ITD
 * with form content and field related methods.
 */
@Component(immediate = true)
@Service
public class VaadinVisuallyComposableEntityFormMetadataProvider extends
		AbstractVaadinEntityFormMetadataProvider {

	protected void activate(ComponentContext context) {
		metadataDependencyRegistry.registerDependency(
				PhysicalTypeIdentifier.getMetadataIdentiferType(),
				getProvidesType());
		addMetadataTrigger(VaadinVisuallyComposableEntityFormMetadata
				.getAnnotationType());
	}

	@Override
	protected ItdTypeDetailsProvidingMetadataItem getMetadata(
			String metadataIdentificationString, JavaType aspectName,
			PhysicalTypeMetadata governorPhysicalTypeMetadata,
			String itdFilename) {

		// We know governor type details are non-null and can be safely cast

		// We need to parse the annotation, which we expect to be present
		VaadinVisuallyComposableEntityFormAnnotationValues annotationValues = new VaadinVisuallyComposableEntityFormAnnotationValues(
				governorPhysicalTypeMetadata);
		if (!annotationValues.isAnnotationFound()
				|| annotationValues.formBackingObject == null) {
			return null;
		}

		return constructMetadata(metadataIdentificationString, aspectName,
				governorPhysicalTypeMetadata, itdFilename,
				annotationValues.formBackingObject);
	}

	@Override
	protected ItdTypeDetailsProvidingMetadataItem createMetadataItem(
			String metadataIdentificationString, JavaType aspectName,
			PhysicalTypeMetadata governorPhysicalTypeMetadata,
			JavaType formBackingObject, EntityMetadata entityMetadata,
			JavaPackage utilPackage, boolean useJpaContainer) {
		VaadinVisuallyComposableEntityFormAnnotationValues annotationValues = new VaadinVisuallyComposableEntityFormAnnotationValues(
				governorPhysicalTypeMetadata);
		return new VaadinVisuallyComposableEntityFormMetadata(
				metadataIdentificationString, aspectName,
				governorPhysicalTypeMetadata, metadataService,
				memberDetailsScanner, annotationValues,
				new VaadinEntityMetadataDetails(formBackingObject, entityMetadata),
				utilPackage, useJpaContainer);
	}

	public String getItdUniquenessFilenameSuffix() {
		return "VaadinVisuallyComposableEntityForm";
	}

	@Override
	protected String getGovernorPhysicalTypeIdentifier(
			String metadataIdentificationString) {
		JavaType javaType = VaadinVisuallyComposableEntityFormMetadata
				.getJavaType(metadataIdentificationString);
		Path path = VaadinVisuallyComposableEntityFormMetadata
				.getPath(metadataIdentificationString);
		String physicalTypeIdentifier = PhysicalTypeIdentifier
				.createIdentifier(javaType, path);
		return physicalTypeIdentifier;
	}

	@Override
	protected String createLocalIdentifier(JavaType javaType, Path path) {
		return VaadinVisuallyComposableEntityFormMetadata.createIdentifier(
				javaType,
				path);
	}

	public String getProvidesType() {
		return VaadinVisuallyComposableEntityFormMetadata
				.getMetadataIdentiferType();
	}

}
