package com.vaadin.spring.roo.addon.entityview;

import java.lang.reflect.Modifier;
import java.util.List;

import org.springframework.roo.addon.entity.EntityMetadata;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetails;
import org.springframework.roo.classpath.details.MethodMetadata;
import org.springframework.roo.classpath.details.MethodMetadataBuilder;
import org.springframework.roo.classpath.itd.InvocableMemberBodyBuilder;
import org.springframework.roo.classpath.scanner.MemberDetails;
import org.springframework.roo.classpath.scanner.MemberDetailsScanner;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.DataType;
import org.springframework.roo.model.ImportRegistrationResolver;
import org.springframework.roo.model.JavaPackage;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;

import com.vaadin.spring.roo.addon.VaadinRooUtils;

public abstract class AbstractVaadinEntityViewMethodBuilder {

	protected final ClassOrInterfaceTypeDetails governorTypeDetails;
	private final String metadataId;
	private final VaadinEntityMetadataDetails vaadinEntityDetails;
	private final ImportRegistrationResolver importResolver;
	private final MetadataService metadataService;
	private final MemberDetailsScanner memberDetailsScanner;

	public AbstractVaadinEntityViewMethodBuilder(
			ClassOrInterfaceTypeDetails governorTypeDetails, String metadataId,
			VaadinEntityMetadataDetails vaadinEntityDetails,
			ImportRegistrationResolver importResolver,
			MetadataService metadataService,
			MemberDetailsScanner memberDetailsScanner) {
		this.governorTypeDetails = governorTypeDetails;
		this.metadataId = metadataId;
		this.vaadinEntityDetails = vaadinEntityDetails;
		this.importResolver = importResolver;
		this.metadataService = metadataService;
		this.memberDetailsScanner = memberDetailsScanner;
	}

	/**
	 * Imports a type if necessary and returns the properly qualified type name
	 * including type parameters.
	 *
	 * @param type
	 * @return
	 */
	protected String getClassName(JavaType type) {
		return type.getNameIncludingTypeParameters(false, importResolver);
	}

	/**
	 * Imports a type if necessary and returns the properly qualified type name
	 * including type parameters.
	 *
	 * @param typeName
	 * @return
	 */
	protected String getClassName(String typeName) {
		JavaType type = new JavaType(typeName);
		return type.getNameIncludingTypeParameters(false, importResolver);
	}

	protected String getId() {
		return metadataId;
	}

	public static JavaType getJavaTypeInWebPackage(
			JavaPackage abstractViewPackage, String className,
			List<JavaType> typeParameters) {
		return new JavaType(
				abstractViewPackage.getFullyQualifiedPackageName() + "."
						+ className, 0, DataType.TYPE, null, typeParameters);
	}

	public static JavaSymbolName getItemCaptionIdMethodName(JavaType type) {
		return new JavaSymbolName("get" + type.getSimpleTypeName()
				+ "CaptionPropertyId");
	}

	public static MethodMetadata createReturnLiteralMethod(
			ClassOrInterfaceTypeDetails governorTypeDetails,
			String declaredbyMetadataId, String methodNameString,
			JavaType returnType, String literalValue) {
		JavaSymbolName methodName = new JavaSymbolName(methodNameString);
		MethodMetadata method = VaadinRooUtils.methodExists(methodName,
				governorTypeDetails);
		if (method != null) {
			return method;
		}

		InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
		bodyBuilder.appendFormalLine("return " + literalValue + ";");

		MethodMetadataBuilder methodBuilder = new MethodMetadataBuilder(
				declaredbyMetadataId, Modifier.PUBLIC, methodName, returnType,
				bodyBuilder);
		return methodBuilder.build();
	}

	protected JavaType getEntityType() {
		return vaadinEntityDetails.getJavaType();
	}

	protected EntityMetadata getEntityMetadata() {
		return vaadinEntityDetails.getEntityMetadata();
	}

	protected MetadataService getMetadataService() {
		return metadataService;
	}

	protected VaadinEntityMetadataDetails getVaadinEntityDetails() {
		return vaadinEntityDetails;
	}
	
	protected MemberDetails getMemberDetails(JavaType type) {
		return VaadinRooUtils.getMemberDetails(type, metadataService, getMemberDetailsScanner(), this.getClass().getName());
	}
	
	protected MemberDetails getMemberDetails() {
		return getMemberDetails(getEntityType());
	}

	protected MemberDetailsScanner getMemberDetailsScanner() {
		return memberDetailsScanner;
	}

}
