package com.vaadin.spring.roo.addon.entityview;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

import org.springframework.roo.addon.javabean.JavaBeanMetadata;
import org.springframework.roo.classpath.details.BeanInfoUtils;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetails;
import org.springframework.roo.classpath.details.FieldMetadata;
import org.springframework.roo.classpath.details.MethodMetadata;
import org.springframework.roo.classpath.details.annotations.AnnotationMetadata;
import org.springframework.roo.classpath.scanner.MemberDetails;
import org.springframework.roo.classpath.scanner.MemberDetailsScanner;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.ImportRegistrationResolver;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.Path;
import org.springframework.roo.support.util.StringUtils;

import com.vaadin.spring.roo.addon.VaadinRooUtils;
import com.vaadin.spring.roo.addon.annotations.RooVaadinDisplayProperty;

public class DomainTypeCaptionMethodBuilder extends
		AbstractVaadinEntityViewMethodBuilder {

	private static final String DISPLAY_PROPERTY_ANNOTATION = RooVaadinDisplayProperty.class
			.getName();

	// map from property name to the underlying (usually entity) type
	private Map<JavaSymbolName, JavaType> specialDomainTypes;

	public DomainTypeCaptionMethodBuilder(
			ClassOrInterfaceTypeDetails governorTypeDetails, String metadataId,
			VaadinEntityMetadataDetails vaadinEntityDetails,
			ImportRegistrationResolver importResolver,
			Map<JavaSymbolName, JavaType> specialDomainTypes,
			MetadataService metadataService,
			MemberDetailsScanner memberDetailsScanner) {
		super(governorTypeDetails, metadataId, vaadinEntityDetails,
				importResolver, metadataService, memberDetailsScanner);

		this.specialDomainTypes = specialDomainTypes;
	}

	// these are also used in the table
	public List<MethodMetadata> getDomainTypeCaptionMethods() {
		List<MethodMetadata> methods = new ArrayList<MethodMetadata>();
		// unique types only
		for (JavaType type : new LinkedHashSet<JavaType>(
				specialDomainTypes.values())) {
			if (type.equals(getEntityType())) {
				continue;
			}

			JavaSymbolName captionMethodName = getItemCaptionIdMethodName(type);
			MethodMetadata captionMethod = VaadinRooUtils.methodExists(
					captionMethodName, governorTypeDetails);
			if (captionMethod != null) {
				continue;
			}

			String propertyIdLiteral = null;
			// use RooVaadinDisplayProperty annotation if exists, then "name"
			// field and finally toString() if none of the above
			JavaBeanMetadata typeBeanMetadata = (JavaBeanMetadata) getMetadataService()
					.get(JavaBeanMetadata.createIdentifier(type,
							Path.SRC_MAIN_JAVA));

			// for enums etc.
			if (typeBeanMetadata == null) {
				captionMethod = createReturnLiteralMethod(governorTypeDetails,
						getId(), captionMethodName.getSymbolName(),
						new JavaType("java.lang.Object"), "null");

				methods.add(captionMethod);

				continue;
			}
			
			MemberDetails memberDetails = getMemberDetails(type);
			Map<JavaSymbolName, MethodMetadata> accessors = VaadinRooUtils
					.getAccessors(type, getEntityMetadata(), memberDetails, false);

			// check for annotations on methods and fields
			JavaType displayPropertyAnnotationType = new JavaType(
					DISPLAY_PROPERTY_ANNOTATION);
			findDisplayPropertyAnnotation: for (JavaSymbolName propertyName : accessors.keySet()) {
				String propertyIdString = StringUtils.uncapitalize(propertyName
						.getSymbolName());

				// check for annotations on accessor
				for (AnnotationMetadata annotation : accessors.get(propertyName).getAnnotations()) {
					if (displayPropertyAnnotationType.equals(annotation
							.getAnnotationType())) {
						propertyIdLiteral = "\"" + propertyIdString + "\"";
						break findDisplayPropertyAnnotation;
					}
				}
				// check for annotations on field
				FieldMetadata field = BeanInfoUtils
						.getFieldForPropertyName(memberDetails, propertyName);
				if (field == null) {
					continue;
				}
				for (AnnotationMetadata annotation : field.getAnnotations()) {
					if (displayPropertyAnnotationType.equals(annotation
							.getAnnotationType())) {
						propertyIdLiteral = "\"" + propertyIdString + "\"";
						break findDisplayPropertyAnnotation;
					}
				}
			}

			if (propertyIdLiteral == null) {
				FieldMetadata nameFieldMetadata = BeanInfoUtils
						.getFieldForPropertyName(memberDetails, new JavaSymbolName("name"));
				if (nameFieldMetadata != null
						&& "name".equals(nameFieldMetadata.getFieldName()
								.getSymbolName())) {
					// the property name and method name should be the same
					propertyIdLiteral = "\"name\"";
				}
			}
			// default to toString() (null) if nothing suitable found

			captionMethod = createReturnLiteralMethod(governorTypeDetails,
					getId(), captionMethodName.getSymbolName(), new JavaType(
							"java.lang.Object"), propertyIdLiteral);

			methods.add(captionMethod);

		}
		return methods;
	}

}
