package com.vaadin.spring.roo.addon.entityview;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetails;
import org.springframework.roo.classpath.details.FieldMetadata;
import org.springframework.roo.classpath.details.MethodMetadata;
import org.springframework.roo.classpath.details.MethodMetadataBuilder;
import org.springframework.roo.classpath.details.annotations.AnnotatedJavaType;
import org.springframework.roo.classpath.itd.InvocableMemberBodyBuilder;
import org.springframework.roo.classpath.scanner.MemberDetailsScanner;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.DataType;
import org.springframework.roo.model.ImportRegistrationResolver;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;

import com.vaadin.spring.roo.addon.VaadinRooUtils;

public class PersistenceMethodBuilder extends
		AbstractVaadinEntityViewMethodBuilder {

	public static final String LIST_ENTITIES_METHOD = "listEntities";
	public static final String SAVE_ENTITY_METHOD = "saveEntity";
	public static final String DELETE_ENTITY_METHOD = "deleteEntity";

	public static final String IS_NEW_ENTITY_METHOD = "isNewEntity";

	public static final String GET_ID_PROPERTY_METHOD = "getIdProperty";
	public static final String GET_VERSION_PROPERTY_METHOD = "getVersionProperty";

	public PersistenceMethodBuilder(
			ClassOrInterfaceTypeDetails governorTypeDetails,
			String metadataId, VaadinEntityMetadataDetails vaadinEntityDetails,
			ImportRegistrationResolver importResolver,
			MetadataService metadataService,
			MemberDetailsScanner memberDetailsScanner) {
		super(governorTypeDetails, metadataId, vaadinEntityDetails,
				importResolver, metadataService, memberDetailsScanner);
	}

	public List<MethodMetadata> getBasicPersistenceMethods() {
		List<MethodMetadata> methods = new ArrayList<MethodMetadata>();

		methods.add(getListMethod());
		methods.add(getSaveMethod());
		methods.add(getDeleteMethod());

		return methods;
	}

	public List<MethodMetadata> getEntityMetadataMethods() {
		List<MethodMetadata> methods = new ArrayList<MethodMetadata>();

		methods.add(getGetIdPropertyMethod());
		methods.add(getGetVersionPropertyMethod());

		return methods;
	}

	private MethodMetadata getListMethod() {
		if (getEntityMetadata().getFindAllMethod() == null) {
			// mandatory input is missing
			return null;
		}

		JavaSymbolName methodName = new JavaSymbolName(LIST_ENTITIES_METHOD);

		MethodMetadata method = VaadinRooUtils.methodExists(methodName,
				governorTypeDetails);
		if (method != null) {
			return method;
		}

		JavaType returnType = new JavaType(List.class.getName(), 0,
				DataType.TYPE, null, Collections.singletonList(getEntityType()));

		String entityClassName = getClassName(getEntityType());
		JavaSymbolName findAllMethodName = getEntityMetadata().getFindAllMethod()
				.getMethodName();
		String listClassName = getClassName(returnType);

		InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
		bodyBuilder.appendFormalLine("" + listClassName + " list = "
				+ entityClassName + "." + findAllMethodName + "();");
		bodyBuilder.appendFormalLine("return list;");

		MethodMetadataBuilder methodBuilder = new MethodMetadataBuilder(
				getId(), Modifier.PUBLIC, methodName, returnType,
				bodyBuilder);
		return methodBuilder.build();
	}

	private MethodMetadata getSaveMethod() {
		if (getEntityMetadata().getPersistMethod() == null
				|| getEntityMetadata().getMergeMethod() == null) {
			// mandatory input is missing
			return null;
		}

		JavaSymbolName methodName = new JavaSymbolName(SAVE_ENTITY_METHOD);

		MethodMetadata method = VaadinRooUtils.methodExists(methodName,
				governorTypeDetails);
		if (method != null) {
			return method;
		}

		List<JavaType> parameterTypes = new ArrayList<JavaType>();
		parameterTypes.add(getEntityType());
		List<JavaSymbolName> parameterNames = new ArrayList<JavaSymbolName>();
		parameterNames.add(new JavaSymbolName("entity"));

		JavaSymbolName mergeMethodName = getEntityMetadata().getMergeMethod()
				.getMethodName();

		InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
		bodyBuilder.appendFormalLine("if (entity == null) {");
		bodyBuilder.indent();
		bodyBuilder.appendFormalLine("return null;");
		bodyBuilder.indentRemove();
		bodyBuilder.appendFormalLine("}");
		// the cast may be necessary if merge() is in an abstract base class
		bodyBuilder.appendFormalLine("return (" + getClassName(getEntityType())
				+ ") entity." + mergeMethodName + "();");

		MethodMetadataBuilder methodBuilder = new MethodMetadataBuilder(
				getId(), Modifier.PUBLIC, methodName, getEntityType(),
				AnnotatedJavaType.convertFromJavaTypes(parameterTypes),
				parameterNames, bodyBuilder);
		return methodBuilder.build();
	}

	private MethodMetadata getDeleteMethod() {
		if (getEntityMetadata().getRemoveMethod() == null) {
			// mandatory input is missing
			return null;
		}

		JavaSymbolName methodName = new JavaSymbolName(DELETE_ENTITY_METHOD);

		MethodMetadata method = VaadinRooUtils.methodExists(methodName,
				governorTypeDetails);
		if (method != null) {
			return method;
		}

		List<JavaType> parameterTypes = new ArrayList<JavaType>();
		parameterTypes.add(getEntityType());
		List<JavaSymbolName> parameterNames = new ArrayList<JavaSymbolName>();
		parameterNames.add(new JavaSymbolName("entity"));

		JavaSymbolName deleteMethodName = getEntityMetadata().getRemoveMethod()
				.getMethodName();

		InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
		bodyBuilder.appendFormalLine("if (entity != null) {");
		bodyBuilder.indent();
		bodyBuilder.appendFormalLine("entity." + deleteMethodName + "();");
		bodyBuilder.indentRemove();
		bodyBuilder.appendFormalLine("}");

		MethodMetadataBuilder methodBuilder = new MethodMetadataBuilder(
				getId(), Modifier.PUBLIC, methodName,
				JavaType.VOID_PRIMITIVE,
				AnnotatedJavaType.convertFromJavaTypes(parameterTypes),
				parameterNames, bodyBuilder);
		return methodBuilder.build();
	}

	public MethodMetadata getIsNewEntityMethod() {
		JavaSymbolName methodName = new JavaSymbolName(IS_NEW_ENTITY_METHOD);

		MethodMetadata method = VaadinRooUtils.methodExists(methodName,
				governorTypeDetails);
		if (method != null) {
			return method;
		}

		List<JavaType> parameterTypes = Collections.singletonList(getEntityType());
		List<JavaSymbolName> parameterNames = Collections
				.singletonList(new JavaSymbolName("entity"));

		InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
		bodyBuilder
				.appendFormalLine("return (entity != null && getIdForEntity(entity) == null);");

		MethodMetadataBuilder methodBuilder = new MethodMetadataBuilder(
				getId(), Modifier.PUBLIC, methodName,
				JavaType.BOOLEAN_PRIMITIVE,
				AnnotatedJavaType.convertFromJavaTypes(parameterTypes),
				parameterNames, bodyBuilder);
		return methodBuilder.build();
	}

	private MethodMetadata getGetIdPropertyMethod() {
		FieldMetadata idField = getEntityMetadata().getIdentifierField();

		String literal = (idField != null) ? "\""
				+ idField.getFieldName().getSymbolName() + "\"" : "null";
		return createReturnLiteralMethod(governorTypeDetails, getId(),
				GET_ID_PROPERTY_METHOD, JavaType.STRING_OBJECT, literal);
	}

	private MethodMetadata getGetVersionPropertyMethod() {
		FieldMetadata versionField = getEntityMetadata().getVersionField();

		String literal = (versionField != null) ? "\""
				+ versionField.getFieldName().getSymbolName() + "\"" : "null";
		return createReturnLiteralMethod(governorTypeDetails, getId(),
				GET_VERSION_PROPERTY_METHOD, JavaType.STRING_OBJECT,
				literal);
	}

}
