package com.vaadin.spring.roo.addon.entityview;

import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.details.annotations.populator.AbstractAnnotationValues;
import org.springframework.roo.classpath.details.annotations.populator.AutoPopulate;
import org.springframework.roo.classpath.details.annotations.populator.AutoPopulationUtils;
import org.springframework.roo.model.JavaType;

import com.vaadin.spring.roo.addon.annotations.RooVaadinEntityView;

/**
 * Represents a parsed {@link RooVaadinEntityView} annotation.
 */
public class VaadinEntityViewAnnotationValues extends AbstractAnnotationValues {

	// From annotation
	@AutoPopulate
	JavaType formBackingObject = null;
	@AutoPopulate
	boolean delete = true;
	@AutoPopulate
	boolean create = true;
	@AutoPopulate
	boolean update = true;

	public VaadinEntityViewAnnotationValues(
			PhysicalTypeMetadata governorPhysicalTypeMetadata) {
		super(governorPhysicalTypeMetadata, new JavaType(
				RooVaadinEntityView.class.getName()));
		AutoPopulationUtils.populate(this, annotationMetadata);
	}

	public JavaType getFormBackingObject() {
		return formBackingObject;
	}

	public boolean isDelete() {
		return delete;
	}

	public boolean isCreate() {
		return create;
	}

	public boolean isUpdate() {
		return update;
	}

}
