/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.demo;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.demo.Card;
import com.vaadin.flow.demo.DemoNavigationBar;
import com.vaadin.flow.demo.SourceCodeExample;
import com.vaadin.flow.demo.SourceContent;
import com.vaadin.flow.demo.SourceContentResolver;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.theme.Theme;
import com.vaadin.flow.theme.lumo.Lumo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Tag(value="div")
@Theme(value=Lumo.class)
@StyleSheet.Container(value={@StyleSheet(value="src/css/demo.css"), @StyleSheet(value="src/css/prism.css")})
@JavaScript(value="src/script/prism.js")
public abstract class DemoView
extends Component
implements HasComponents,
HasUrlParameter<String>,
HasStyle {
    private DemoNavigationBar navBar = new DemoNavigationBar();
    private Div container = new Div();
    private Map<String, Div> tabComponents = new HashMap<String, Div>();
    private Map<String, List<SourceCodeExample>> sourceCodeExamples = new HashMap<String, List<SourceCodeExample>>();

    protected DemoView() {
        Route annotation = ((Object)((Object)this)).getClass().getAnnotation(Route.class);
        if (annotation == null) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getName() + " should be annotated with @" + Route.class.getName() + " to be a valid view");
        }
        this.addClassName("demo-view");
        this.navBar.addClassName("demo-nav");
        this.add(new Component[]{this.navBar});
        this.add(new Component[]{this.container});
        this.populateSources();
        this.initView();
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.tabComponents.size() <= 1) {
            this.remove(new Component[]{this.navBar});
        }
    }

    protected abstract void initView();

    public void populateSources() {
        SourceContentResolver.getSourceCodeExamplesForClass(((Object)((Object)this)).getClass()).forEach(this::putSourceCode);
    }

    private void putSourceCode(SourceCodeExample example) {
        String heading = example.getHeading();
        List list = this.sourceCodeExamples.computeIfAbsent(heading, key -> new ArrayList());
        list.add(example);
    }

    public Card addCard(String heading, Component ... components) {
        return this.addCard("Basic usage", "", heading, components);
    }

    public Card addCard(String tabName, String heading, Component ... components) {
        String tabUrl = tabName.toLowerCase().replaceAll("[\\W]", "-");
        return this.addCard(tabName, tabUrl, heading, components);
    }

    private Card addCard(String tabName, String tabUrl, String heading, Component ... components) {
        List<SourceCodeExample> list;
        Div tab = this.tabComponents.computeIfAbsent(tabUrl, url -> {
            this.navBar.addLink(tabName, this.getTabUrl(tabUrl));
            return new Div();
        });
        if (heading != null && !heading.isEmpty()) {
            tab.add(new Component[]{new H3(heading)});
        }
        Card card = new Card();
        if (components != null && components.length > 0) {
            card.add(components);
        }
        if ((list = this.sourceCodeExamples.get(heading)) != null) {
            list.stream().map(this::createSourceContent).forEach(xva$0 -> card.add((Component)xva$0));
        }
        tab.add(new Component[]{card});
        return card;
    }

    private String getTabUrl(String relativeHref) {
        String href = relativeHref == null || relativeHref.isEmpty() ? "" : "/" + relativeHref;
        return ((Object)((Object)this)).getClass().getAnnotation(Route.class).value() + href;
    }

    private SourceContent createSourceContent(SourceCodeExample sourceCodeExample) {
        SourceContent content = new SourceContent();
        String sourceString = sourceCodeExample.getSourceCode();
        switch (sourceCodeExample.getSourceType()) {
            case CSS: {
                content.addCss(sourceString);
                break;
            }
            case JAVA: {
                content.addCode(sourceString);
                break;
            }
            default: {
                content.addCode(sourceString);
            }
        }
        return content;
    }

    private void showTab(String tabUrl) {
        Div tab = this.tabComponents.get(tabUrl);
        if (tab != null) {
            this.container.removeAll();
            this.container.add(new Component[]{tab});
            this.navBar.setActive(this.getTabUrl(tabUrl));
            tab.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getPage().executeJavaScript("Prism.highlightAll();", new Serializable[0]));
        }
    }

    public void setParameter(BeforeEvent event, @OptionalParameter String parameter) {
        this.showTab(parameter == null ? "" : parameter);
    }
}

