/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.demo;

import com.vaadin.flow.demo.DemoView;
import com.vaadin.flow.demo.SourceCodeExample;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SourceContentResolver {
    private static final ConcurrentHashMap<Class<? extends DemoView>, List<SourceCodeExample>> CACHED_SOURCE_EXAMPLES = new ConcurrentHashMap();
    private static final Pattern SOURCE_CODE_EXAMPLE_BEGIN_PATTERN = Pattern.compile("\\s*// begin-source-example");
    private static final Pattern SOURCE_CODE_EXAMPLE_END_PATTERN = Pattern.compile("\\s*// end-source-example");
    private static final Pattern SOURCE_CODE_EXAMPLE_HEADING_PATTERN = Pattern.compile("\\s*// source-example-heading: (.*)");
    private static final Pattern SOURCE_CODE_EXAMPLE_TYPE_PATTERN = Pattern.compile("\\s*// source-example-type: ([A-Z]+)");

    private SourceContentResolver() {
    }

    public static List<SourceCodeExample> getSourceCodeExamplesForClass(Class<? extends DemoView> demoViewClass) {
        return CACHED_SOURCE_EXAMPLES.computeIfAbsent(demoViewClass, SourceContentResolver::parseSourceCodeExamplesForClass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<SourceCodeExample> parseSourceCodeExamplesForClass(Class<? extends DemoView> demoViewClass) {
        String resourcePath = SourceContentResolver.getResourcePath(demoViewClass);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(SourceContentResolver.class.getClassLoader().getResourceAsStream(resourcePath), StandardCharsets.UTF_8));){
            List<String> lines = reader.lines().collect(Collectors.toList());
            List<SourceCodeExample> list = Collections.unmodifiableList(SourceContentResolver.parseSourceCodeExamples(lines));
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading source examples for class " + demoViewClass, e);
        }
    }

    private static String getResourcePath(Class<? extends DemoView> demoViewClass) {
        String javaFile = demoViewClass.getSimpleName() + ".java";
        String formattedPackageName = demoViewClass.getPackage().getName().replaceAll("\\.", "/");
        String resourcePath = "../test-classes/" + formattedPackageName + "/" + javaFile;
        if (!(SourceContentResolver.isAvailable(resourcePath) || SourceContentResolver.isAvailable(resourcePath = "../test-classes/" + demoViewClass.getPackage().getName() + "/" + javaFile) || SourceContentResolver.isAvailable(resourcePath = "/" + formattedPackageName + "/" + javaFile))) {
            throw new IllegalArgumentException("Could not find file resources for '" + demoViewClass.getName() + "'!");
        }
        return resourcePath;
    }

    private static boolean isAvailable(String resourcePath) {
        return SourceContentResolver.class.getClassLoader().getResource(resourcePath) != null;
    }

    private static List<SourceCodeExample> parseSourceCodeExamples(List<String> sourceLines) {
        ArrayList<SourceCodeExample> examples = new ArrayList<SourceCodeExample>();
        int startIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < sourceLines.size(); ++i) {
            if (SOURCE_CODE_EXAMPLE_BEGIN_PATTERN.matcher(sourceLines.get(i)).matches()) {
                startIndex = i;
            } else if (SOURCE_CODE_EXAMPLE_END_PATTERN.matcher(sourceLines.get(i)).matches()) {
                endIndex = i;
            }
            if (startIndex == -1 || endIndex == -1 || startIndex + 1 >= endIndex) continue;
            examples.add(SourceContentResolver.parseSourceCodeExample(sourceLines.subList(startIndex + 1, endIndex)));
            startIndex = -1;
            endIndex = -1;
        }
        return examples;
    }

    private static SourceCodeExample parseSourceCodeExample(List<String> sourceLines) {
        String heading = SourceContentResolver.parseValueFromPattern(sourceLines, SOURCE_CODE_EXAMPLE_HEADING_PATTERN, Function.identity(), () -> null);
        SourceCodeExample.SourceType sourceType = SourceContentResolver.parseValueFromPattern(sourceLines, SOURCE_CODE_EXAMPLE_TYPE_PATTERN, SourceCodeExample.SourceType::valueOf, () -> SourceCodeExample.SourceType.UNDEFINED);
        SourceCodeExample example = new SourceCodeExample();
        example.setHeading(heading);
        example.setSourceType(sourceType);
        example.setSourceCode(String.join((CharSequence)"\n", SourceContentResolver.trimWhitespaceAtStart(sourceLines)));
        return example;
    }

    private static <T> T parseValueFromPattern(List<String> sourceLines, Pattern pattern, Function<String, T> valueProvider, Supplier<T> nullValueProvider) {
        for (int i = 0; i < sourceLines.size(); ++i) {
            Matcher matcher = pattern.matcher(sourceLines.get(i));
            if (!matcher.matches()) continue;
            sourceLines.remove(i);
            return valueProvider.apply(matcher.group(1));
        }
        return nullValueProvider.get();
    }

    private static List<String> trimWhitespaceAtStart(List<String> sourceLines) {
        int minIndent = Integer.MAX_VALUE;
        for (String line : sourceLines) {
            int indent;
            if (line == null || line.isEmpty() || (indent = SourceContentResolver.getWhitespaceCountAtStart(line)) >= minIndent) continue;
            minIndent = indent;
        }
        ArrayList<String> trimmed = new ArrayList<String>();
        for (String line : sourceLines) {
            if (line == null || line.isEmpty()) {
                trimmed.add("");
                continue;
            }
            trimmed.add(line.substring(minIndent));
        }
        return trimmed;
    }

    private static int getWhitespaceCountAtStart(String line) {
        int indent = 0;
        for (int i = 0; i < line.length(); ++i) {
            if (!Character.isWhitespace(line.charAt(i))) {
                return indent;
            }
            ++indent;
        }
        return indent;
    }
}

