/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.StrBean;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class DataProviderTestBase<D extends DataProvider<StrBean, SerializablePredicate<StrBean>>> {
    protected final SerializablePredicate<StrBean> fooFilter = (SerializablePredicate & Serializable)s -> s.getValue().equals("Foo");
    protected final SerializablePredicate<StrBean> gt5Filter = (SerializablePredicate & Serializable)bean -> bean.getRandomNumber() > 5;
    protected D dataProvider;
    protected List<StrBean> data = StrBean.generateRandomBeans(100);

    @Before
    public void setUp() {
        this.dataProvider = this.createDataProvider();
    }

    protected abstract D createDataProvider();

    protected final D getDataProvider() {
        return this.dataProvider;
    }

    protected abstract void setSortOrder(List<QuerySortOrder> var1, Comparator<StrBean> var2);

    private Query<StrBean, SerializablePredicate<StrBean>> createQuery(List<QuerySortOrder> sortOrder, Comparator<StrBean> comp) {
        return this.createQuery(sortOrder, comp, null);
    }

    private Query<StrBean, SerializablePredicate<StrBean>> createQuery(List<QuerySortOrder> sortOrder, Comparator<StrBean> comp, SerializablePredicate<StrBean> filter) {
        return new Query(0, Integer.MAX_VALUE, sortOrder, comp, filter);
    }

    @Test
    public void testListContainsAllData() {
        LinkedList<StrBean> list = new LinkedList<StrBean>(this.data);
        this.dataProvider.fetch(new Query()).forEach(str -> Assert.assertTrue((String)"Data provider contained values not in original data", (boolean)list.remove(str)));
        Assert.assertTrue((String)"Not all values from original data were in data provider", (boolean)list.isEmpty());
    }

    @Test
    public void testSortByComparatorListsDiffer() {
        Comparator<StrBean> comp = Comparator.comparing(StrBean::getValue).thenComparing(StrBean::getRandomNumber).thenComparing(StrBean::getId);
        List list = this.dataProvider.fetch(this.createQuery(QuerySortOrder.asc((String)"value").thenAsc("randomNumber").thenAsc("id").build(), comp)).collect(Collectors.toList());
        Assert.assertNotEquals((String)"First value should not match", (Object)this.data.get(0), list.get(0));
        Assert.assertEquals((String)"Sorted data and original data sizes don't match", (long)this.data.size(), (long)list.size());
        this.data.sort(comp);
        for (int i = 0; i < this.data.size(); ++i) {
            Assert.assertEquals((String)"Sorting result differed", (Object)this.data.get(i), list.get(i));
        }
    }

    @Test
    public void testDefaultSortWithSpecifiedPostSort() {
        Comparator<StrBean> comp = Comparator.comparing(StrBean::getValue).thenComparing(Comparator.comparing(StrBean::getId).reversed());
        this.setSortOrder(QuerySortOrder.asc((String)"value").thenDesc("id").build(), comp);
        List list = this.dataProvider.fetch(this.createQuery(QuerySortOrder.asc((String)"randomNumber").build(), Comparator.comparing(StrBean::getRandomNumber))).collect(Collectors.toList());
        Assert.assertEquals((String)"Sorted data and original data sizes don't match", (long)this.data.size(), (long)list.size());
        for (int i = 1; i < list.size(); ++i) {
            StrBean prev = (StrBean)list.get(i - 1);
            StrBean cur = (StrBean)list.get(i);
            Assert.assertTrue((String)("Failure: " + prev.getRandomNumber() + " > " + cur.getRandomNumber()), (prev.getRandomNumber() <= cur.getRandomNumber() ? 1 : 0) != 0);
            if (prev.getRandomNumber() != cur.getRandomNumber()) continue;
            Assert.assertTrue((prev.getValue().compareTo(cur.getValue()) <= 0 ? 1 : 0) != 0);
            if (!prev.getValue().equals(cur.getValue())) continue;
            Assert.assertTrue((prev.getId() > cur.getId() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDefaultSortWithFunction() {
        this.setSortOrder(QuerySortOrder.asc((String)"value").build(), Comparator.comparing(StrBean::getValue));
        List list = this.dataProvider.fetch(new Query()).collect(Collectors.toList());
        Assert.assertEquals((String)"Sorted data and original data sizes don't match", (long)this.data.size(), (long)list.size());
        for (int i = 1; i < list.size(); ++i) {
            StrBean prev = (StrBean)list.get(i - 1);
            StrBean cur = (StrBean)list.get(i);
            Assert.assertTrue((prev.getValue().compareTo(cur.getValue()) <= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void filteringListDataProvider_convertFilter() {
        DataProvider strFilterDataProvider = this.dataProvider.withConvertedFilter((SerializableFunction & Serializable)text -> (SerializablePredicate & Serializable)strBean -> strBean.getValue().contains((CharSequence)text));
        Assert.assertEquals((String)"Only one item should match 'Xyz'", (long)1L, (long)strFilterDataProvider.size(new Query((Object)"Xyz")));
        Assert.assertEquals((String)"No item should match 'Zyx'", (long)0L, (long)strFilterDataProvider.size(new Query((Object)"Zyx")));
        Assert.assertEquals((String)"Unexpected number of matches for 'Foo'", (long)36L, (long)strFilterDataProvider.size(new Query((Object)"Foo")));
        Assert.assertEquals((String)"No items should've been filtered out", (long)this.data.size(), (long)strFilterDataProvider.size(new Query()));
    }

    @Test
    public void filteringListDataProvider_defaultFilterType() {
        Assert.assertEquals((String)"Only one item should match 'Xyz'", (long)1L, (long)this.dataProvider.size(new Query((SerializablePredicate & Serializable)strBean -> strBean.getValue().contains("Xyz"))));
        Assert.assertEquals((String)"No item should match 'Zyx'", (long)0L, (long)this.dataProvider.size(new Query((SerializablePredicate & Serializable)strBean -> strBean.getValue().contains("Zyx"))));
        Assert.assertEquals((String)"Unexpected number of matches for 'Foo'", (long)36L, (long)this.dataProvider.size(new Query(this.fooFilter)));
    }

    protected long sizeWithUnfilteredQuery() {
        return this.dataProvider.fetch(new Query()).count();
    }

    protected static <F> void assertSizeWithFilter(int expectedSize, DataProvider<?, F> dataProvider, F filterValue) {
        Assert.assertEquals((long)expectedSize, (long)dataProvider.size(new Query(filterValue)));
    }

    protected static class CountingListener
    implements DataProviderListener {
        private int counter = 0;

        protected CountingListener() {
        }

        public void onDataChange(DataChangeEvent event) {
            ++this.counter;
        }

        public int getCounter() {
            return this.counter;
        }
    }
}

