/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class ComponentRendererTest {
    @Test
    public void componentFunction_invokedOnCreate() {
        AtomicInteger createInvocations = new AtomicInteger();
        ComponentRenderer renderer = new ComponentRenderer((SerializableFunction & Serializable)item -> {
            createInvocations.incrementAndGet();
            Assert.assertEquals((Object)"New item", (Object)item);
            return new Div();
        });
        renderer.createComponent((Object)"New item");
        Assert.assertEquals((String)"The component creation function should have been invoked once", (long)1L, (long)createInvocations.get());
    }

    @Test
    public void componentFunction_noUpdateFunction_invokedOnUpdate() {
        AtomicInteger createInvocations = new AtomicInteger();
        Div div = new Div();
        ComponentRenderer renderer = new ComponentRenderer((SerializableFunction & Serializable)item -> {
            createInvocations.incrementAndGet();
            Assert.assertEquals((Object)"New item", (Object)item);
            return div;
        });
        Component updatedComponent = renderer.updateComponent((Component)div, (Object)"New item");
        Assert.assertEquals((String)"The component creation function should have been invoked once", (long)1L, (long)createInvocations.get());
        Assert.assertEquals((String)"The two components should be the same", (Object)div, (Object)updatedComponent);
    }

    @Test
    public void updateFunction_invokedOnUpdate() {
        AtomicInteger createInvocations = new AtomicInteger();
        AtomicInteger updateInvocations = new AtomicInteger();
        ComponentRenderer renderer = new ComponentRenderer((SerializableFunction & Serializable)item -> {
            createInvocations.incrementAndGet();
            Assert.assertEquals((Object)"New item", (Object)item);
            return new Div();
        }, (SerializableBiFunction & Serializable)(component, item) -> {
            updateInvocations.incrementAndGet();
            Assert.assertEquals((Object)"Updated item", (Object)item);
            return component;
        });
        Div div = (Div)renderer.createComponent((Object)"New item");
        Component updatedComponent = renderer.updateComponent((Component)div, (Object)"Updated item");
        Assert.assertEquals((String)"The component creation function should have been invoked once", (long)1L, (long)createInvocations.get());
        Assert.assertEquals((String)"The component update function should have been invoked once", (long)1L, (long)updateInvocations.get());
        Assert.assertEquals((String)"The two components should be the same", (Object)div, (Object)updatedComponent);
    }
}

