/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.validator;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.validator.AbstractValidator;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;

public class ValidatorTestBase {
    private Label localeContext;
    private Locale locale = Locale.US;

    @Before
    public void setUp() {
        UI ui = new UI(){

            public Locale getLocale() {
                return ValidatorTestBase.this.locale;
            }
        };
        UI.setCurrent((UI)ui);
        this.localeContext = new Label();
    }

    protected <T> void assertPasses(T value, Validator<? super T> validator) {
        ValidationResult result = validator.apply(value, new ValueContext());
        if (result.isError()) {
            Assert.fail((String)(value + " should pass " + validator + " but got " + result.getErrorMessage()));
        }
    }

    protected <T> void assertFails(T value, String errorMessage, Validator<? super T> validator) {
        ValidationResult result = validator.apply(value, new ValueContext((Component)this.localeContext));
        Assert.assertTrue((boolean)result.isError());
        Assert.assertEquals((Object)errorMessage, (Object)result.getErrorMessage());
    }

    protected <T> void assertFails(T value, AbstractValidator<? super T> v) {
        this.assertFails(value, v.getMessage(value), (Validator<? super T>)v);
    }

    protected void setLocale(Locale locale) {
        this.locale = locale;
    }
}

