/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.value;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import org.junit.Assert;
import org.junit.Test;

public class ValueChangeModeTest {
    @Test
    public void field_setMode() {
        ValueChangeModeField field = new ValueChangeModeField();
        field.setValueChangeMode(ValueChangeMode.ON_BLUR);
        this.assertValueSynchronizedWithEvent((Component)field, "blur");
        field.setValueChangeMode(null);
        Assert.assertEquals((long)0L, (long)field.getElement().getSynchronizedPropertyEvents().count());
        field.setValueChangeMode(ValueChangeMode.EAGER);
        this.assertValueSynchronizedWithEvent((Component)field, "value-changed");
    }

    private void assertValueSynchronizedWithEvent(Component component, String eventName) {
        Assert.assertArrayEquals((String)"value should be the only synchronized property", (Object[])new String[]{"value"}, (Object[])component.getElement().getSynchronizedProperties().toArray(String[]::new));
        Object[] syncedPropertyEvents = (String[])component.getElement().getSynchronizedPropertyEvents().toArray(String[]::new);
        Object[] expectedPropertyEvents = new String[]{eventName};
        Assert.assertArrayEquals((String)(eventName + " should be the only synchronized property-event"), (Object[])expectedPropertyEvents, (Object[])syncedPropertyEvents);
    }

    @Tag(value="tag")
    private static class ValueChangeModeField
    extends AbstractSinglePropertyField<ValueChangeModeField, String>
    implements HasValueChangeMode {
        private ValueChangeMode valueChangeMode;

        public ValueChangeModeField() {
            super("value", (Object)"", false);
        }

        public void setValueChangeMode(ValueChangeMode valueChangeMode) {
            this.valueChangeMode = valueChangeMode;
            this.setSynchronizedEvent(ValueChangeMode.eventForMode((ValueChangeMode)valueChangeMode, (String)"value-changed"));
        }

        public ValueChangeMode getValueChangeMode() {
            return this.valueChangeMode;
        }
    }
}

