/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BinderTestBase;
import com.vaadin.flow.data.binder.StatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.tests.data.bean.Person;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinderStatusChangeTest
extends BinderTestBase<Binder<Person>, Person> {
    private AtomicReference<StatusChangeEvent> event;

    @Before
    public void setUp() {
        this.binder = new Binder();
        this.item = new Person();
        this.event = new AtomicReference();
    }

    @Test
    public void bindBinding_unbound_eventWhenBoundEndnoEventsBeforeBound() {
        this.binder.addStatusChangeListener(this::statusChanged);
        Binder.BindingBuilder binding = this.binder.forField((HasValue)this.nameField);
        this.nameField.setValue("");
        Assert.assertNull((Object)this.event.get());
        binding.bind(Person::getFirstName, Person::setFirstName);
        this.verifyEvent();
    }

    @Test
    public void bindBinder_unbound_singleEventWhenBound() {
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.setBean(this.item);
        this.verifyEvent();
    }

    @Test
    public void removeBean_bound_singleEventWhenUnBound() {
        this.binder.setBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.removeBean();
        this.verifyEvent();
    }

    @Test
    public void removeBean_unbound_noEventWhenUnBound() {
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.removeBean();
        Assert.assertNull((Object)this.event.get());
    }

    @Test
    public void setValue_bound_singleEventOnSetValue() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.nameField.setValue("foo");
        this.verifyEvent();
    }

    @Test
    public void setValue_severalBoundFieldsAndBoundBinder_singleEventOnSetValue() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.nameField.setValue("foo");
        this.verifyEvent();
    }

    @Test
    public void setInvalidValue_bound_singleEventOnSetValue() {
        this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate & Serializable)name -> false, "").bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.nameField.setValue("foo");
        this.verifyEvent(true);
    }

    @Test
    public void setInvalidBean_bound_singleEventOnSetValue() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.setBean(this.item);
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)bean -> false, (String)""));
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.nameField.setValue("foo");
        this.verifyEvent(true);
    }

    @Test
    public void readBean_hasBindings_singleEventOnLoad() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.readBean(this.item);
        this.verifyEvent();
    }

    @Test
    public void readBean_hasSeveralBindings_singleEventOnLoad() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.readBean(this.item);
        this.verifyEvent();
    }

    @Test
    public void readBean_hasNoBindings_singleEvent() {
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.readBean(this.item);
        this.verifyEvent();
    }

    @Test
    public void writeBean_hasNoBindings_singleEvent() throws ValidationException {
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.writeBean(this.item);
        this.verifyEvent();
    }

    @Test
    public void writeBeanIfValid_hasNoBindings_singleEvent() {
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.writeBeanIfValid(this.item);
        this.verifyEvent();
    }

    @Test
    public void writeBean_hasBindings_singleEvent() throws ValidationException {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.writeBean(this.item);
        this.verifyEvent();
    }

    @Test
    public void writeBean_hasSeveralBindings_singleEvent() throws ValidationException {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.readBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.writeBean(this.item);
        this.verifyEvent();
    }

    @Test
    public void writeBeanIfValid_hasBindings_singleEvent() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.writeBeanIfValid(this.item);
        this.verifyEvent();
    }

    @Test
    public void writeBeanIfValid_hasSeveralBindings_singleEvent() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.readBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.writeBeanIfValid(this.item);
        this.verifyEvent();
    }

    @Test
    public void writeBeanInvalidValue_hasBindings_singleEvent() {
        this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate & Serializable)name -> false, "").bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        try {
            this.binder.writeBean(this.item);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        this.verifyEvent(true);
    }

    @Test
    public void writeBeanIfValid_invalidValueAndBinderHasBindings_singleEvent() {
        this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate & Serializable)name -> false, "").bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.writeBeanIfValid(this.item);
        this.verifyEvent(true);
    }

    @Test
    public void writeBeanIfValid_invalidValueAndBinderHasSeveralBindings_singleEvent() {
        this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate & Serializable)name -> false, "").bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.readBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.writeBeanIfValid(this.item);
        this.verifyEvent(true);
    }

    @Test
    public void writeBeanInvalidBean_hasBindings_singleEvent() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean(this.item);
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)person -> false, (String)""));
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        try {
            this.binder.writeBean(this.item);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        this.verifyEvent(true);
    }

    @Test
    public void writeBeanIfValid_invalidBeanAndBinderHasBindings_singleEvent() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean(this.item);
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)person -> false, (String)""));
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.writeBeanIfValid(this.item);
        this.verifyEvent(true);
    }

    @Test
    public void writeValidBean_hasBindings_singleEvent() throws ValidationException {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean(this.item);
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)person -> true, (String)""));
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.writeBean(this.item);
        this.verifyEvent();
    }

    @Test
    public void writeBeanIfValid_validBeanAndBinderHasBindings_singleEvent() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.readBean(this.item);
        this.binder.withValidator(Validator.from((SerializablePredicate & Serializable)person -> true, (String)""));
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.writeBeanIfValid(this.item);
        this.verifyEvent();
    }

    @Test
    public void validateBinder_noValidationErrors_statusEventWithoutErrors() {
        this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.validate();
        this.verifyEvent();
    }

    @Test
    public void validateBinder_validationErrors_statusEventWithError() {
        this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate & Serializable)name -> false, "").bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        this.binder.validate();
        this.verifyEvent(true);
    }

    @Test
    public void validateBinding_noValidationErrors_statusEventWithoutErrors() {
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        binding.validate();
        this.verifyEvent();
    }

    @Test
    public void validateBinding_validationErrors_statusEventWithError() {
        Binder.Binding binding = this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate & Serializable)name -> false, "").bind(Person::getFirstName, Person::setFirstName);
        this.binder.forField((HasValue)this.ageField).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        this.binder.setBean(this.item);
        this.binder.addStatusChangeListener(this::statusChanged);
        Assert.assertNull((Object)this.event.get());
        binding.validate();
        this.verifyEvent(true);
    }

    private void verifyEvent() {
        this.verifyEvent(false);
    }

    private void verifyEvent(boolean validationErrors) {
        StatusChangeEvent statusChangeEvent = this.event.get();
        Assert.assertNotNull((Object)statusChangeEvent);
        Assert.assertEquals((Object)this.binder, (Object)statusChangeEvent.getBinder());
        Assert.assertEquals((Object)this.binder, (Object)statusChangeEvent.getSource());
        Assert.assertEquals((Object)validationErrors, (Object)statusChangeEvent.hasValidationErrors());
    }

    private void statusChanged(StatusChangeEvent evt) {
        Assert.assertNull((Object)this.event.get());
        this.event.set(evt);
    }
}

