/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.provider.AbstractDataProvider;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.Range;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class DataCommunicatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private DataCommunicator<Item> dataCommunicator;
    @Mock
    private DataGenerator<Item> dataGenerator;
    @Mock
    private ArrayUpdater arrayUpdater;
    private Element element;
    private MockUI ui;
    private ArrayUpdater.Update update;
    public Range lastClear = null;
    public Range lastSet = null;
    public int lastUpdateId = -1;

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
        this.ui = new MockUI();
        this.element = new Element("div");
        this.ui.getElement().appendChild(new Element[]{this.element});
        this.lastClear = null;
        this.lastSet = null;
        this.lastUpdateId = -1;
        this.update = new ArrayUpdater.Update(){

            public void clear(int start, int length) {
                DataCommunicatorTest.this.lastClear = Range.withLength((int)start, (int)length);
            }

            public void set(int start, List<JsonValue> items) {
                DataCommunicatorTest.this.lastSet = Range.withLength((int)start, (int)items.size());
            }

            public void commit(int updateId) {
                DataCommunicatorTest.this.lastUpdateId = updateId;
            }
        };
        Mockito.when((Object)this.arrayUpdater.startUpdate(Mockito.anyInt())).thenReturn((Object)this.update);
        this.dataCommunicator = new DataCommunicator(this.dataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> {}, this.element.getNode());
    }

    @Test
    public void communicator_with_0_items_should_not_refresh_all() {
        this.dataCommunicator.setRequestedRange(0, 0);
        this.fakeClientCommunication();
        Assert.assertEquals((Object)Range.withLength((int)0, (int)0), (Object)this.lastSet);
        Assert.assertNull((String)"Only requestAll should clear items. This may make us loop.", (Object)this.lastClear);
        this.dataCommunicator.setRequestedRange(0, 0);
        this.fakeClientCommunication();
        Assert.assertEquals((Object)Range.withLength((int)0, (int)0), (Object)this.lastSet);
        Assert.assertNull((String)"Only requestAll should clear items. Which would make us loop.", (Object)this.lastClear);
    }

    @Test
    public void communicator_with_items_should_send_updates_but_not_refresh_all() {
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected request range for 50 items on first request.", (Object)Range.withLength((int)0, (int)50), (Object)this.lastSet);
        this.dataCommunicator.setRequestedRange(0, 70);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected request range for 20 new items.", (Object)Range.withLength((int)50, (int)20), (Object)this.lastSet);
    }

    @Test
    public void reattach_different_roundtrip_refresh_all() {
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected initial full reset.", (Object)Range.withLength((int)0, (int)50), (Object)this.lastSet);
        this.lastSet = null;
        this.element.removeFromParent();
        this.fakeClientCommunication();
        Assert.assertNull((String)"Expected no during reattach.", (Object)this.lastSet);
        this.ui.getElement().appendChild(new Element[]{this.element});
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected initial full reset after reattach", (Object)Range.withLength((int)0, (int)50), (Object)this.lastSet);
    }

    @Test
    public void reattach_same_roundtrip_refresh_nothing() {
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected initial full reset.", (Object)Range.withLength((int)0, (int)50), (Object)this.lastSet);
        this.lastSet = null;
        this.element.removeFromParent();
        Assert.assertNull((String)"Expected no communication during reattach", (Object)this.lastSet);
        this.ui.getElement().appendChild(new Element[]{this.element});
        this.fakeClientCommunication();
        Assert.assertNull((String)"Expected no communication after reattach", (Object)this.lastSet);
    }

    @Test
    public void setDataProvider_keyMapperIsReset() {
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((long)0L, (long)((Item)this.dataCommunicator.getKeyMapper().get("1")).id);
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        Assert.assertNull((String)"The KeyMapper should be reset when a new DataProvider is set", (Object)this.dataCommunicator.getKeyMapper().get("1"));
    }

    @Test
    public void dataProviderBreaksContract_limitIsNotCalled_throw() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < 2; ++i) {
            items.add(new Item(i));
        }
        CallbackDataProvider dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> items.stream(), (CallbackDataProvider.CountCallback & Serializable)query -> items.size());
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"The data provider hasn't ever called getLimit"));
        this.dataCommunicator.fetchFromProvider(0, 1);
    }

    @Test
    public void dataProviderBreaksContract_offsetIsNotCalled_throw() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < 2; ++i) {
            items.add(new Item(i));
        }
        CallbackDataProvider dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getLimit();
            return items.stream();
        }, (CallbackDataProvider.CountCallback & Serializable)query -> items.size());
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"The data provider hasn't ever called getOffset"));
        this.dataCommunicator.fetchFromProvider(1, 1);
    }

    @Test
    public void dataProviderBreaksContract_tooManyItems_throw() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < 2; ++i) {
            items.add(new Item(i));
        }
        CallbackDataProvider dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return items.stream();
        }, (CallbackDataProvider.CountCallback & Serializable)query -> items.size());
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        Stream stream = this.dataCommunicator.fetchFromProvider(0, 1);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"exceeds the limit specified by the query (1)."));
        stream.forEach(item -> {});
    }

    @Test
    public void sameKeyDifferentInstance_latestInstanceUsed() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < 2; ++i) {
            items.add(new Item(i));
        }
        ListDataProvider dataProvider = new ListDataProvider(items);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Item originalItem = (Item)items.get(0);
        String key = this.dataCommunicator.getKeyMapper().key((Object)originalItem);
        Assert.assertSame((Object)originalItem, (Object)this.dataCommunicator.getKeyMapper().get(key));
        Item updatedItem = new Item(originalItem.id, "Updated");
        items.set(0, updatedItem);
        dataProvider.refreshAll();
        this.fakeClientCommunication();
        Assert.assertSame((Object)updatedItem, (Object)this.dataCommunicator.getKeyMapper().get(key));
    }

    @Test
    public void dataProviderReturnsLessItemsThanRequested_aNewSizeQueryIsPerformed() {
        AbstractDataProvider dataProvider = this.createDataProviderThatChangesSize(50, 10);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((long)40L, (long)this.lastSet.getEnd());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)2))).size((Query)Mockito.any());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)1))).fetch((Query)Mockito.any());
    }

    private void fakeClientCommunication() {
        this.ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.ui.getInternals().getStateTree().collectChanges(ignore -> {});
    }

    private AbstractDataProvider<Item, Object> createDataProviderThatChangesSize(final int size, final int delta) {
        return new AbstractDataProvider<Item, Object>(){
            private boolean modifiedCount;

            public boolean isInMemory() {
                return true;
            }

            public int size(Query<Item, Object> query) {
                if (this.modifiedCount) {
                    return size - delta;
                }
                return size;
            }

            public Stream<Item> fetch(Query<Item, Object> query) {
                int count = query.getLimit() + query.getOffset();
                if (!this.modifiedCount) {
                    count -= delta;
                    this.modifiedCount = true;
                }
                return IntStream.range(query.getOffset(), count).mapToObj(Item::new);
            }
        };
    }

    private AbstractDataProvider<Item, Object> createDataProvider() {
        return new AbstractDataProvider<Item, Object>(){

            public boolean isInMemory() {
                return true;
            }

            public int size(Query<Item, Object> query) {
                return 100;
            }

            public Stream<Item> fetch(Query<Item, Object> query) {
                return IntStream.range(query.getOffset(), query.getLimit() + query.getOffset()).mapToObj(Item::new);
            }
        };
    }

    public static class MockVaadinSession
    extends VaadinSession {
        private static final ThreadLocal<MockVaadinSession> referenceKeeper = new ThreadLocal();
        private int closeCount;
        private ReentrantLock lock = new ReentrantLock();

        public MockVaadinSession(VaadinService service) {
            super(service);
        }

        public void close() {
            super.close();
            ++this.closeCount;
        }

        public int getCloseCount() {
            return this.closeCount;
        }

        public Lock getLockInstance() {
            return this.lock;
        }

        public void lock() {
            super.lock();
            referenceKeeper.set(this);
        }

        public void unlock() {
            super.unlock();
            referenceKeeper.remove();
        }
    }

    public static class AlwaysLockedVaadinSession
    extends MockVaadinSession {
        public AlwaysLockedVaadinSession(VaadinService service) {
            super(service);
            this.lock();
        }
    }

    public static class MockUI
    extends UI {
        public MockUI() {
            this(MockUI.findOrcreateSession());
        }

        public MockUI(VaadinSession session) {
            this.getInternals().setSession(session);
            MockUI.setCurrent((UI)this);
        }

        protected void init(VaadinRequest request) {
        }

        private static VaadinSession findOrcreateSession() {
            VaadinSession session = VaadinSession.getCurrent();
            if (session == null) {
                session = new AlwaysLockedVaadinSession(null);
                VaadinSession.setCurrent((VaadinSession)session);
            }
            return session;
        }
    }

    private static class Item {
        private final int id;
        private String value;

        public Item(int id) {
            this(id, "Item " + id);
        }

        public Item(int id, String value) {
            this.id = id;
            this.value = value;
        }

        public String toString() {
            return this.id + ": " + this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                Item that = (Item)obj;
                return that.id == this.id;
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

