/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.data.binder.testcomponents.TestLabel;
import com.vaadin.flow.data.provider.ComponentDataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class ComponentRendererTest {
    @Test
    public void templateRenderered_parentAttachedBeforeChild() {
        TestUI ui = new TestUI();
        TestUIInternals internals = (TestUIInternals)ui.getInternals();
        ComponentRenderer renderer = new ComponentRenderer((SerializableFunction & Serializable)e -> new TestLabel());
        Element containerParent = new Element("div");
        Element container = new Element("div");
        KeyMapper keyMapper = new KeyMapper();
        ComponentDataGenerator rendering = (ComponentDataGenerator)renderer.render(container, (DataKeyMapper)keyMapper);
        containerParent.getNode().runWhenAttached((SerializableConsumer & Serializable)ui2 -> ui2.getInternals().getStateTree().beforeClientResponse(containerParent.getNode(), (SerializableConsumer & Serializable)context -> {
            Assert.assertNotNull((String)"NodeIdPropertyName should not be null", (Object)rendering.getNodeIdPropertyName());
            JsonObject value = Json.createObject();
            rendering.generateData((Object)"item", value);
            Assert.assertEquals((String)"generateData should add one element in the jsonobject", (long)1L, (long)value.keys().length);
        }));
        this.attachElement(ui, containerParent);
        this.attachElement(ui, container);
        internals.getStateTree().runExecutionsBeforeClientResponse();
    }

    @Test
    public void templateRenderered_childAttachedBeforeParent() {
        TestUI ui = new TestUI();
        TestUIInternals internals = (TestUIInternals)ui.getInternals();
        ComponentRenderer renderer = new ComponentRenderer((SerializableFunction & Serializable)e -> new TestLabel());
        Element containerParent = new Element("div");
        Element container = new Element("div");
        KeyMapper keyMapper = new KeyMapper();
        ComponentDataGenerator rendering = (ComponentDataGenerator)renderer.render(container, (DataKeyMapper)keyMapper);
        containerParent.getNode().runWhenAttached((SerializableConsumer & Serializable)ui2 -> ui2.getInternals().getStateTree().beforeClientResponse(containerParent.getNode(), (SerializableConsumer & Serializable)context -> {
            Assert.assertNotNull((String)"NodeIdPropertyName should not be null", (Object)rendering.getNodeIdPropertyName());
            JsonObject value = Json.createObject();
            rendering.generateData((Object)"item", value);
            Assert.assertEquals((String)"generateData should add one element in the jsonobject", (long)1L, (long)value.keys().length);
        }));
        this.attachElement(ui, container);
        this.attachElement(ui, containerParent);
        internals.getStateTree().runExecutionsBeforeClientResponse();
    }

    private void attachElement(UI ui, Element contentTemplate) {
        ui.getElement().appendChild(new Element[]{contentTemplate});
    }

    @Test
    public void componentFunction_invokedOnCreate() {
        AtomicInteger createInvocations = new AtomicInteger();
        ComponentRenderer renderer = new ComponentRenderer((SerializableFunction & Serializable)item -> {
            createInvocations.incrementAndGet();
            Assert.assertEquals((Object)"New item", (Object)item);
            return new TestLabel();
        });
        renderer.createComponent((Object)"New item");
        Assert.assertEquals((String)"The component creation function should have been invoked once", (long)1L, (long)createInvocations.get());
    }

    @Test
    public void componentFunction_noUpdateFunction_invokedOnUpdate() {
        AtomicInteger createInvocations = new AtomicInteger();
        TestLabel div = new TestLabel();
        ComponentRenderer renderer = new ComponentRenderer((SerializableFunction & Serializable)item -> {
            createInvocations.incrementAndGet();
            Assert.assertEquals((Object)"New item", (Object)item);
            return div;
        });
        Component updatedComponent = renderer.updateComponent((Component)div, (Object)"New item");
        Assert.assertEquals((String)"The component creation function should have been invoked once", (long)1L, (long)createInvocations.get());
        Assert.assertEquals((String)"The two components should be the same", (Object)((Object)div), (Object)updatedComponent);
    }

    @Test
    public void updateFunction_invokedOnUpdate() {
        AtomicInteger createInvocations = new AtomicInteger();
        AtomicInteger updateInvocations = new AtomicInteger();
        ComponentRenderer renderer = new ComponentRenderer((SerializableFunction & Serializable)item -> {
            createInvocations.incrementAndGet();
            Assert.assertEquals((Object)"New item", (Object)item);
            return new TestLabel();
        }, (SerializableBiFunction & Serializable)(component, item) -> {
            updateInvocations.incrementAndGet();
            Assert.assertEquals((Object)"Updated item", (Object)item);
            return component;
        });
        TestLabel div = (TestLabel)renderer.createComponent((Object)"New item");
        Component updatedComponent = renderer.updateComponent((Component)div, (Object)"Updated item");
        Assert.assertEquals((String)"The component creation function should have been invoked once", (long)1L, (long)createInvocations.get());
        Assert.assertEquals((String)"The component update function should have been invoked once", (long)1L, (long)updateInvocations.get());
        Assert.assertEquals((String)"The two components should be the same", (Object)((Object)div), (Object)updatedComponent);
    }

    private static class TestUI
    extends UI {
        private UIInternals internals;

        private TestUI() {
        }

        public UIInternals getInternals() {
            if (this.internals == null) {
                this.internals = new TestUIInternals(this);
            }
            return this.internals;
        }
    }

    private static class TestUIInternals
    extends UIInternals {
        private List<PendingJavaScriptInvocation> invocations = new ArrayList<PendingJavaScriptInvocation>();

        public TestUIInternals(UI ui) {
            super(ui);
        }

        public void addJavaScriptInvocation(PendingJavaScriptInvocation invocation) {
            this.invocations.add(invocation);
        }
    }
}

