/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.data.renderer.TemplateRenderer;
import org.junit.Assert;
import org.junit.Test;

public class TemplateRendererTest {
    @Test
    public void missingAttributeBindingDetector() {
        String[] missingDollar = new String[]{"<div class='[[item.className]]'>", "<div class = '[[item.className]]'>", "<div class=\"[[item.className]]\">", "<div class=[[item.className]]>", "<div class={{item.className}}>", "<div style='[[item.style]]'>"};
        String[] notMissingDollar = new String[]{"<div class$='[[item.className]]'>", "<div class$ = [[item.className]]>", "<div style$='[[item.style]]'>", "<div my-style='[[item.style]]'>", "<div className='[[item.className]]'>", "<div class='static list'>", "<div class=((item.not_a_binding))>"};
        for (String template : missingDollar) {
            if (TemplateRenderer.hasClassOrStyleWithoutDollar((String)template)) continue;
            Assert.fail((String)("Missing dollar should be detected for the string: " + template));
        }
        for (String template : notMissingDollar) {
            if (!TemplateRenderer.hasClassOrStyleWithoutDollar((String)template)) continue;
            Assert.fail((String)("Missing dollar should not be detected for the string: " + template));
        }
    }
}

