/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.ConverterFactory;
import com.vaadin.flow.data.converter.DateToLongConverter;
import com.vaadin.flow.data.converter.DateToSqlDateConverter;
import com.vaadin.flow.data.converter.LocalDateTimeToDateConverter;
import com.vaadin.flow.data.converter.LocalDateToDateConverter;
import com.vaadin.flow.data.converter.StringToBigDecimalConverter;
import com.vaadin.flow.data.converter.StringToBigIntegerConverter;
import com.vaadin.flow.data.converter.StringToBooleanConverter;
import com.vaadin.flow.data.converter.StringToDateConverter;
import com.vaadin.flow.data.converter.StringToDoubleConverter;
import com.vaadin.flow.data.converter.StringToFloatConverter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.data.converter.StringToLongConverter;
import com.vaadin.flow.data.converter.StringToUuidConverter;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.ReflectTools;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public final class DefaultConverterFactory
extends Enum<DefaultConverterFactory>
implements ConverterFactory {
    public static final /* enum */ DefaultConverterFactory INSTANCE = new DefaultConverterFactory();
    private final Map<Key, SerializableSupplier<? extends Converter>> converterMap = new HashMap<Key, SerializableSupplier<? extends Converter>>();
    private static final /* synthetic */ DefaultConverterFactory[] $VALUES;

    public static DefaultConverterFactory[] values() {
        return (DefaultConverterFactory[])$VALUES.clone();
    }

    public static DefaultConverterFactory valueOf(String name) {
        return Enum.valueOf(DefaultConverterFactory.class, name);
    }

    private DefaultConverterFactory() {
        this.registerConverter(DateToLongConverter.class, DateToLongConverter::new);
        this.registerConverter(DateToSqlDateConverter.class, DateToSqlDateConverter::new);
        this.registerConverter(LocalDateTimeToDateConverter.class, (SerializableSupplier & Serializable)() -> new LocalDateTimeToDateConverter(ZoneId.systemDefault()));
        this.registerConverter(LocalDateToDateConverter.class, LocalDateToDateConverter::new);
        this.registerConverterWithMessageProvider(StringToBigDecimalConverter.class, StringToBigDecimalConverter::new);
        this.registerConverterWithMessageProvider(StringToBigIntegerConverter.class, StringToBigIntegerConverter::new);
        this.registerConverterWithMessageProvider(StringToBooleanConverter.class, StringToBooleanConverter::new);
        this.registerConverter(StringToDateConverter.class, StringToDateConverter::new);
        this.registerConverterWithMessageProvider(StringToDoubleConverter.class, StringToDoubleConverter::new);
        this.registerConverterWithMessageProvider(StringToFloatConverter.class, StringToFloatConverter::new);
        this.registerConverterWithMessageProvider(StringToIntegerConverter.class, StringToIntegerConverter::new);
        this.registerConverterWithMessageProvider(StringToLongConverter.class, StringToLongConverter::new);
        this.registerConverterWithMessageProvider(StringToUuidConverter.class, StringToUuidConverter::new);
    }

    private <C extends Converter<?, ?>> void registerConverter(Class<C> converterType, SerializableSupplier<C> factory) {
        List types = ReflectTools.getGenericInterfaceTypes(converterType, Converter.class);
        assert (!types.isEmpty() && types.stream().allMatch(Objects::nonNull));
        Key key = new Key((Class)types.get(0), (Class)types.get(1));
        this.converterMap.put(key, factory);
    }

    private <C extends Converter<?, ?>> void registerConverterWithMessageProvider(Class<C> converterType, Function<ErrorMessageProvider, C> factory) {
        this.registerConverter(converterType, (SerializableSupplier & Serializable)() -> (Converter)factory.apply((ErrorMessageProvider & Serializable)context -> ""));
    }

    @Override
    public <P, M> Optional<Converter<P, M>> newInstance(Class<P> presentationType, Class<M> modelType) {
        if (presentationType == null) {
            throw new IllegalArgumentException("The presentation type cannot be null");
        }
        if (modelType == null) {
            throw new IllegalArgumentException("The model type must cannot be null");
        }
        return Optional.ofNullable(this.converterMap.get(new Key(presentationType, modelType))).map(Supplier::get);
    }

    static {
        $VALUES = new DefaultConverterFactory[]{INSTANCE};
    }

    private static final class Key
    implements Serializable {
        private final Class<?> presentationType;
        private final Class<?> modelType;

        private Key(Class<?> presentationType, Class<?> modelType) {
            assert (presentationType != null && modelType != null);
            this.presentationType = presentationType;
            this.modelType = ReflectTools.convertPrimitiveType(modelType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.presentationType.equals(key.presentationType) && this.modelType.equals(key.modelType);
        }

        public int hashCode() {
            return Objects.hash(this.presentationType, this.modelType);
        }
    }
}

