/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataCommunicatorTest;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalArrayUpdater;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class HierarchicalCommunicatorDataTest {
    private static final Item ROOT = new Item(0, "ROOT");
    private static final Item FOLDER = new Item(1, "FOLDER");
    private static final Item LEAF = new Item(2, "LEAF");
    private TreeDataProvider<Item> dataProvider;
    private HierarchicalDataCommunicator<Item> communicator;
    private TreeData<Item> treeData;
    private MockUI ui;
    private Element element;
    private boolean parentClearCalled = false;
    private int committedUpdateId;
    private final HierarchicalArrayUpdater arrayUpdater = new HierarchicalArrayUpdater(){

        public HierarchicalArrayUpdater.HierarchicalUpdate startUpdate(int sizeChange) {
            return new UpdateQueue();
        }

        public void initialize() {
        }
    };

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.ui = new MockUI();
        this.element = new Element("div");
        this.ui.getElement().appendChild(new Element[]{this.element});
        this.treeData = new TreeData();
        this.treeData.addItems(null, (Object[])new Item[]{ROOT});
        this.treeData.addItems((Object)ROOT, (Object[])new Item[]{FOLDER});
        this.treeData.addItems((Object)FOLDER, (Object[])new Item[]{LEAF});
        this.dataProvider = new TreeDataProvider(this.treeData);
        this.communicator = new HierarchicalDataCommunicator((CompositeDataGenerator)Mockito.mock(CompositeDataGenerator.class), this.arrayUpdater, (SerializableConsumer & Serializable)json -> {}, this.element.getNode(), (SerializableSupplier & Serializable)() -> (ValueProvider & Serializable)item -> String.valueOf(item.id));
        this.communicator.setDataProvider(this.dataProvider, null);
    }

    @Test
    public void sameKeyDifferentInstance_latestInstanceUsed() {
        this.communicator.expand((Object)ROOT);
        this.communicator.expand((Object)FOLDER);
        this.fakeClientCommunication();
        Item originalLeaf = (Item)this.treeData.getChildren((Object)FOLDER).get(0);
        String key = this.communicator.getKeyMapper().key((Object)originalLeaf);
        Assert.assertSame((Object)originalLeaf, (Object)this.communicator.getKeyMapper().get(key));
        Item updatedLeaf = new Item(originalLeaf.id, "Updated");
        this.treeData.removeItem((Object)LEAF);
        this.treeData.addItems((Object)FOLDER, (Object[])new Item[]{updatedLeaf});
        this.fakeClientCommunication();
        this.dataProvider.refreshItem((Object)FOLDER, true);
        this.fakeClientCommunication();
        Assert.assertSame((Object)updatedLeaf, (Object)this.communicator.getKeyMapper().get(key));
    }

    @Test
    public void uniqueKeyProviderIsSet_keysGeneratedByProvider() {
        this.communicator = new HierarchicalDataCommunicator((CompositeDataGenerator)Mockito.mock(CompositeDataGenerator.class), this.arrayUpdater, (SerializableConsumer & Serializable)json -> {}, this.element.getNode(), (SerializableSupplier & Serializable)() -> (ValueProvider & Serializable)item -> item.value);
        this.communicator.setDataProvider(this.dataProvider, null);
        this.communicator.expand((Object)ROOT);
        this.communicator.expand((Object)FOLDER);
        this.communicator.setParentRequestedRange(0, 50, (Object)LEAF);
        this.fakeClientCommunication();
        Arrays.asList("ROOT", "FOLDER", "LEAF").forEach(key -> Assert.assertNotNull((String)("Expected key '" + key + "' to be generated when unique key provider used"), (Object)this.communicator.getKeyMapper().get(key)));
    }

    @Test
    public void uniqueKeyProviderIsNotSet_keysGeneratedByKeyMapper() {
        this.communicator = new HierarchicalDataCommunicator((CompositeDataGenerator)Mockito.mock(CompositeDataGenerator.class), this.arrayUpdater, (SerializableConsumer & Serializable)json -> {}, this.element.getNode(), (SerializableSupplier & Serializable)() -> null);
        this.communicator.setDataProvider(this.dataProvider, null);
        this.communicator.expand((Object)ROOT);
        this.communicator.expand((Object)FOLDER);
        this.communicator.setParentRequestedRange(0, 50, (Object)LEAF);
        this.fakeClientCommunication();
        IntStream.range(1, 4).mapToObj(String::valueOf).forEach(i -> Assert.assertNotNull((String)("Expected key '" + i + "' to be generated when unique key provider is not set"), (Object)this.communicator.getKeyMapper().get(i)));
    }

    @Test
    public void expandRoot_filterOutAllChildren_clearCalled() {
        this.parentClearCalled = false;
        this.communicator.expand((Object)ROOT);
        this.fakeClientCommunication();
        this.communicator.setParentRequestedRange(0, 50, (Object)ROOT);
        this.fakeClientCommunication();
        SerializablePredicate & Serializable filter = (SerializablePredicate & Serializable)item -> ROOT.equals(item);
        this.communicator.setFilter((Object)filter);
        this.fakeClientCommunication();
        this.dataProvider.refreshItem((Object)ROOT, true);
        this.fakeClientCommunication();
        this.communicator.reset();
        Assert.assertTrue((boolean)this.parentClearCalled);
    }

    @Test
    public void expandItem_requestNonOverlappingRange_expandedItemPersistsInKeyMapper() {
        this.committedUpdateId = -1;
        int indexToTest = 2;
        int requestedRangeLength = 5;
        this.treeData = new TreeData();
        for (int id = 0; id < requestedRangeLength * 4; ++id) {
            this.treeData.addItems(null, (Object[])new Item[]{new Item(id, "Item " + id)});
        }
        Item itemToTest = (Item)this.treeData.getRootItems().get(indexToTest);
        this.treeData.addItems((Object)itemToTest, (Object[])new Item[]{new Item(this.treeData.getRootItems().size(), "Item " + indexToTest + "_0")});
        this.dataProvider = new TreeDataProvider(this.treeData);
        this.communicator.setDataProvider(this.dataProvider, null);
        this.communicator.setRequestedRange(0, requestedRangeLength);
        this.fakeClientCommunication();
        Assert.assertTrue((boolean)this.communicator.getKeyMapper().has((Object)itemToTest));
        String initialKey = this.communicator.getKeyMapper().key((Object)itemToTest);
        this.communicator.expand((Object)itemToTest);
        this.communicator.setRequestedRange(requestedRangeLength * 2, requestedRangeLength);
        this.fakeClientCommunication();
        this.assertKeyItemPairIsPresentInKeyMapper(initialKey, itemToTest);
        this.communicator.confirmUpdate(this.committedUpdateId);
        this.fakeClientCommunication();
        this.assertKeyItemPairIsPresentInKeyMapper(initialKey, itemToTest);
        this.communicator.reset();
    }

    private void assertKeyItemPairIsPresentInKeyMapper(String key, Item item) {
        Assert.assertTrue((boolean)this.communicator.getKeyMapper().has((Object)item));
        Assert.assertEquals((Object)key, (Object)this.communicator.getKeyMapper().key((Object)item));
    }

    private void fakeClientCommunication() {
        this.ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.ui.getInternals().getStateTree().collectChanges(ignore -> {});
    }

    public static class AlwaysLockedVaadinSession
    extends DataCommunicatorTest.MockVaadinSession {
        public AlwaysLockedVaadinSession(VaadinService service) {
            super(service);
            this.lock();
        }
    }

    public static class MockUI
    extends UI {
        public MockUI() {
            this(MockUI.findOrCreateSession());
        }

        public MockUI(VaadinSession session) {
            this.getInternals().setSession(session);
            MockUI.setCurrent((UI)this);
        }

        protected void init(VaadinRequest request) {
        }

        private static VaadinSession findOrCreateSession() {
            VaadinSession session = VaadinSession.getCurrent();
            if (session == null) {
                session = new DataCommunicatorTest.AlwaysLockedVaadinSession(null);
                VaadinSession.setCurrent((VaadinSession)session);
            }
            return session;
        }
    }

    private class UpdateQueue
    implements HierarchicalArrayUpdater.HierarchicalUpdate {
        private UpdateQueue() {
        }

        public void clear(int start, int length) {
        }

        public void set(int start, List<JsonValue> items) {
        }

        public void commit(int updateId) {
            HierarchicalCommunicatorDataTest.this.committedUpdateId = updateId;
        }

        public void enqueue(String name, Serializable ... arguments) {
        }

        public void set(int start, List<JsonValue> items, String parentKey) {
        }

        public void clear(int start, int length, String parentKey) {
            HierarchicalCommunicatorDataTest.this.parentClearCalled = true;
        }

        public void commit(int updateId, String parentKey, int levelSize) {
        }

        public void commit() {
        }
    }

    private static class Item {
        private final int id;
        private String value;

        public Item(int id, String value) {
            this.id = id;
            this.value = value;
        }

        public String toString() {
            return this.id + ": " + this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                Item that = (Item)obj;
                return that.id == this.id;
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

