/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.data.provider.AbstractDataView;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.tests.data.bean.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractDataViewTest {
    private Collection<Item> items;
    private ListDataProvider<Item> dataProvider;
    private AbstractDataView<Item> dataView;
    private Component component;

    @Before
    public void init() {
        this.items = new ArrayList<Item>(Arrays.asList(new Item(1L, "first", "description1"), new Item(2L, "middle", "description2"), new Item(3L, "last", "description3")));
        this.dataProvider = DataProvider.ofCollection(this.items);
        this.component = new TestComponent();
        this.dataView = new DataViewImpl((SerializableSupplier & Serializable)() -> this.dataProvider, this.component);
    }

    @Test
    public void getItems_noFiltersSet_allItemsObtained() {
        Stream allItems = this.dataView.getItems();
        Assert.assertArrayEquals((String)"Unexpected data set", (Object[])this.items.toArray(), (Object[])allItems.toArray());
    }

    @Test
    public void getItems_filtersSet_filteredItemsObtained() {
        this.dataProvider.setFilter((SerializablePredicate & Serializable)item -> item.getValue().equals("first"));
        Assert.assertArrayEquals((String)"Unexpected data set after filtering", (Object[])new String[]{"first"}, (Object[])this.dataView.getItems().map(Item::getValue).toArray());
    }

    @Test
    public void getItems_sortingSet_sortedItemsObtained() {
        this.dataProvider.setSortOrder(Item::getId, SortDirection.DESCENDING);
        Assert.assertArrayEquals((String)"Unexpected items sorting", (Object[])new Long[]{3L, 2L, 1L}, (Object[])this.dataView.getItems().map(Item::getId).toArray());
    }

    @Test
    public void addItemCountChangeListener_fireEvent_listenerNotified() {
        AtomicInteger fired = new AtomicInteger(0);
        this.dataView.addItemCountChangeListener((ComponentEventListener & Serializable)event -> fired.compareAndSet(0, event.getItemCount()));
        ComponentUtil.fireEvent((Component)this.component, (ComponentEvent)new ItemCountChangeEvent(this.component, 10, false));
        Assert.assertEquals((long)10L, (long)fired.get());
    }

    @Test
    public void refreshAll_listenersNotified() {
        AtomicReference refreshAllEvent = new AtomicReference();
        this.dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> {
            Assert.assertNull(refreshAllEvent.get());
            refreshAllEvent.set(event);
        });
        this.dataView.refreshAll();
        Assert.assertNotNull(refreshAllEvent.get());
        Assert.assertEquals(this.dataProvider, (Object)((DataChangeEvent)refreshAllEvent.get()).getSource());
    }

    @Tag(value="test-component")
    private static class TestComponent
    extends Component {
        private TestComponent() {
        }
    }

    private static class DataViewImpl
    extends AbstractDataView<Item> {
        public DataViewImpl(SerializableSupplier<DataProvider<Item, ?>> dataProviderSupplier, Component component) {
            super(dataProviderSupplier, component);
        }

        protected Class<?> getSupportedDataProviderType() {
            return DataProvider.class;
        }

        public Item getItem(int index) {
            return null;
        }
    }

    static class CustomIdentityItemDataProvider
    extends ListDataProvider<Item> {
        public CustomIdentityItemDataProvider(Collection<Item> items) {
            super(items);
        }

        public Object getId(Item item) {
            return item.getId();
        }
    }
}

