/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.provider.AbstractDataProvider;
import com.vaadin.flow.data.provider.AbstractListDataView;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.Range;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class DataCommunicatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private DataCommunicator<Item> dataCommunicator;
    @Mock
    private DataGenerator<Item> dataGenerator;
    @Mock
    private ArrayUpdater arrayUpdater;
    private Element element;
    private MockUI ui;
    private ArrayUpdater.Update update;
    public Range lastClear = null;
    public Range lastSet = null;
    public int lastUpdateId = -1;
    private int pageSize;
    private final boolean dataProviderWithParallelStream;

    public DataCommunicatorTest(boolean dataProviderWithParallelStream) {
        this.dataProviderWithParallelStream = dataProviderWithParallelStream;
    }

    @Parameterized.Parameters
    public static Collection<Boolean> testParameters() {
        return Arrays.asList(false, true);
    }

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
        this.ui = new MockUI();
        this.element = new Element("div");
        this.ui.getElement().appendChild(new Element[]{this.element});
        this.lastClear = null;
        this.lastSet = null;
        this.lastUpdateId = -1;
        this.update = new ArrayUpdater.Update(){

            public void clear(int start, int length) {
                DataCommunicatorTest.this.lastClear = Range.withLength((int)start, (int)length);
            }

            public void set(int start, List<JsonValue> items) {
                DataCommunicatorTest.this.lastSet = Range.withLength((int)start, (int)items.size());
            }

            public void commit(int updateId) {
                DataCommunicatorTest.this.lastUpdateId = updateId;
            }
        };
        Mockito.when((Object)this.arrayUpdater.startUpdate(Mockito.anyInt())).thenReturn((Object)this.update);
        this.dataCommunicator = new DataCommunicator(this.dataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> {}, this.element.getNode());
        this.pageSize = this.dataCommunicator.getPageSize();
    }

    @Test
    public void communicator_with_0_items_should_not_refresh_all() {
        this.dataCommunicator.setRequestedRange(0, 0);
        this.fakeClientCommunication();
        Assert.assertEquals((Object)Range.withLength((int)0, (int)0), (Object)this.lastSet);
        Assert.assertNull((String)"Only requestAll should clear items. This may make us loop.", (Object)this.lastClear);
        this.dataCommunicator.setRequestedRange(0, 0);
        this.fakeClientCommunication();
        Assert.assertEquals((Object)Range.withLength((int)0, (int)0), (Object)this.lastSet);
        Assert.assertNull((String)"Only requestAll should clear items. Which would make us loop.", (Object)this.lastClear);
    }

    @Test
    public void communicator_with_items_should_send_updates_but_not_refresh_all() {
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected request range for 50 items on first request.", (Object)Range.withLength((int)0, (int)50), (Object)this.lastSet);
        this.dataCommunicator.setRequestedRange(0, 70);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected request range for 20 new items.", (Object)Range.withLength((int)50, (int)20), (Object)this.lastSet);
    }

    @Test
    public void reattach_different_roundtrip_refresh_all() {
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected initial full reset.", (Object)Range.withLength((int)0, (int)50), (Object)this.lastSet);
        this.lastSet = null;
        this.element.removeFromParent();
        this.fakeClientCommunication();
        Assert.assertNull((String)"Expected no during reattach.", (Object)this.lastSet);
        this.ui.getElement().appendChild(new Element[]{this.element});
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected initial full reset after reattach", (Object)Range.withLength((int)0, (int)50), (Object)this.lastSet);
    }

    @Test
    public void reattach_same_roundtrip_refresh_nothing() {
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected initial full reset.", (Object)Range.withLength((int)0, (int)50), (Object)this.lastSet);
        this.lastSet = null;
        this.element.removeFromParent();
        Assert.assertNull((String)"Expected no communication during reattach", (Object)this.lastSet);
        this.ui.getElement().appendChild(new Element[]{this.element});
        this.fakeClientCommunication();
        Assert.assertNull((String)"Expected no communication after reattach", (Object)this.lastSet);
    }

    @Test
    public void setDataProvider_keyMapperIsReset() {
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((long)0L, (long)((Item)this.dataCommunicator.getKeyMapper().get((String)"1")).id);
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        Assert.assertNull((String)"The KeyMapper should be reset when a new DataProvider is set", (Object)this.dataCommunicator.getKeyMapper().get("1"));
    }

    @Test
    public void dataProviderBreaksContract_limitOrPageSizeAreNotCalled_throw() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < 2; ++i) {
            items.add(new Item(i));
        }
        CallbackDataProvider dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> items.stream(), (CallbackDataProvider.CountCallback & Serializable)query -> items.size());
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"The data provider hasn't ever called getLimit() or getPageSize()"));
        this.dataCommunicator.fetchFromProvider(0, 1);
    }

    @Test
    public void dataProviderBreaksContract_offsetOrPageAreNotCalled_throw() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < 2; ++i) {
            items.add(new Item(i));
        }
        CallbackDataProvider dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getLimit();
            return items.stream();
        }, (CallbackDataProvider.CountCallback & Serializable)query -> items.size());
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"The data provider hasn't ever called getOffset() or getPage()"));
        this.dataCommunicator.fetchFromProvider(1, 1);
    }

    @Test
    public void dataProviderContract_pageAndPageSizeAreCalled_itemsFetched() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < 2; ++i) {
            items.add(new Item(i));
        }
        CallbackDataProvider dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getPage();
            query.getPageSize();
            return items.stream();
        }, (CallbackDataProvider.CountCallback & Serializable)query -> items.size());
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        Assert.assertEquals((long)2L, (long)this.dataCommunicator.fetchFromProvider(1, 1).count());
    }

    @Test
    public void dataProviderBreaksContract_tooManyItems_throw() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < 10; ++i) {
            items.add(new Item(i));
        }
        CallbackDataProvider dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return items.stream();
        }, (CallbackDataProvider.CountCallback & Serializable)query -> items.size());
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.dataCommunicator.setPageSize(2);
        Stream stream = this.dataCommunicator.fetchFromProvider(0, 3);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"exceeds the limit specified by the query (4)."));
        stream.forEach(item -> {});
    }

    @Test
    public void sameKeyDifferentInstance_latestInstanceUsed() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < 2; ++i) {
            items.add(new Item(i));
        }
        ListDataProvider dataProvider = new ListDataProvider(items);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Item originalItem = (Item)items.get(0);
        String key = this.dataCommunicator.getKeyMapper().key((Object)originalItem);
        Assert.assertSame((Object)originalItem, (Object)this.dataCommunicator.getKeyMapper().get(key));
        Item updatedItem = new Item(originalItem.id, "Updated");
        items.set(0, updatedItem);
        dataProvider.refreshAll();
        this.fakeClientCommunication();
        Assert.assertSame((Object)updatedItem, (Object)this.dataCommunicator.getKeyMapper().get(key));
    }

    @Test
    public void dataProviderReturnsLessItemsThanRequested_aNewSizeQueryIsPerformed() {
        AbstractDataProvider dataProvider = this.createDataProviderThatChangesSize(50, 10);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((long)40L, (long)this.lastSet.getEnd());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)2))).size((Query)Mockito.any());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)1))).fetch((Query)Mockito.any());
    }

    @Test
    public void setSizeCallback_usedForDataSize() {
        AbstractDataProvider dataProvider = this.createDataProvider();
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.dataCommunicator.setRequestedRange(0, 50);
        Assert.assertTrue((boolean)this.dataCommunicator.isDefinedSize());
        this.fakeClientCommunication();
        AtomicBoolean sizeCallbackCall = new AtomicBoolean(false);
        this.dataCommunicator.setCountCallback((CallbackDataProvider.CountCallback & Serializable)query -> {
            sizeCallbackCall.set(true);
            return 100;
        });
        Assert.assertTrue((boolean)this.dataCommunicator.isDefinedSize());
        this.fakeClientCommunication();
        Assert.assertTrue((String)"SizeCallback not called", (boolean)sizeCallbackCall.getAndSet(false));
        Assert.assertEquals((String)"Size not used", (long)100L, (long)this.dataCommunicator.getItemCount());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)1))).size((Query)Mockito.any());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)1))).fetch((Query)Mockito.any());
        this.dataCommunicator.setRequestedRange(50, 50);
        this.fakeClientCommunication();
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)1))).size((Query)Mockito.any());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)2))).fetch((Query)Mockito.any());
        Assert.assertFalse((String)"SizeCallback called when should not have", (boolean)sizeCallbackCall.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setSizeCallback_null_throws() {
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.setCountCallback(null);
    }

    @Test
    public void setCountCallback_itemCountEstimatesWereSet_overridesItemCountEstimates() {
        AbstractDataProvider dataProvider = this.createDataProvider(5000);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        int itemCountEstimate = 200;
        this.dataCommunicator.setItemCountEstimate(200);
        int itemCountEstimateIncrease = 300;
        this.dataCommunicator.setItemCountEstimateIncrease(300);
        this.dataCommunicator.setRequestedRange(150, 50);
        Assert.assertFalse((boolean)this.dataCommunicator.isDefinedSize());
        this.fakeClientCommunication();
        Assert.assertEquals((String)"initial estimate+increase not used", (long)500L, (long)this.dataCommunicator.getItemCount());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)0))).size((Query)Mockito.any());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)1))).fetch((Query)Mockito.any());
        AtomicBoolean sizeCallbackCall = new AtomicBoolean(false);
        int exactSize = 1234;
        this.dataCommunicator.setCountCallback((CallbackDataProvider.CountCallback & Serializable)query -> {
            sizeCallbackCall.set(true);
            return 1234;
        });
        Assert.assertTrue((boolean)this.dataCommunicator.isDefinedSize());
        this.fakeClientCommunication();
        Assert.assertTrue((String)"SizeCallback not called", (boolean)sizeCallbackCall.getAndSet(false));
        Assert.assertEquals((String)"Size not used", (long)1234L, (long)this.dataCommunicator.getItemCount());
    }

    @Test
    public void setInitialCountEstimate_usedInitiallyThenDiscarded() {
        AbstractDataProvider dataProvider = this.createDataProvider(250);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        int initialCountEstimate = 100;
        this.dataCommunicator.setItemCountEstimate(100);
        this.dataCommunicator.setRequestedRange(0, 50);
        Assert.assertFalse((boolean)this.dataCommunicator.isDefinedSize());
        this.fakeClientCommunication();
        Assert.assertEquals((String)"initial size estimate not used", (long)100L, (long)this.dataCommunicator.getItemCount());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)0))).size((Query)Mockito.any());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)1))).fetch((Query)Mockito.any());
        this.dataCommunicator.setRequestedRange(50, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"initial size estimate was not discarded", (long)(100 + this.getPageSizeIncrease()), (long)this.dataCommunicator.getItemCount());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)0))).size((Query)Mockito.any());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)2))).fetch((Query)Mockito.any());
    }

    @Test
    public void setInitialCountEstimate_lessThanCurrentFetchedSize_discarded() {
        AbstractDataProvider<Item, Object> dataProvider = this.createDataProvider(250);
        this.dataCommunicator.setDataProvider(dataProvider, null);
        this.dataCommunicator.setDefinedSize(false);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        int initialCountEstimate = 111;
        this.dataCommunicator.setItemCountEstimate(111);
        Assert.assertFalse((boolean)this.dataCommunicator.isDefinedSize());
        this.dataCommunicator.setRequestedRange(50, 100);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"too small initial size estimate should not be applied", (long)(111 + this.getPageSizeIncrease()), (long)this.dataCommunicator.getItemCount());
    }

    @Test
    public void setInitialCountEstimate_lessThanRequestedRange_sizeIsIncreasedAutomatically() {
        AbstractDataProvider dataProvider = this.createDataProvider(250);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        int requestedRangeEnd = 50;
        this.dataCommunicator.setRequestedRange(0, requestedRangeEnd);
        int initialCountEstimate = 49;
        this.dataCommunicator.setItemCountEstimate(49);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Size should be automatically adjusted for too small estimate", (long)(49 + this.getPageSizeIncrease()), (long)this.dataCommunicator.getItemCount());
    }

    @Test
    public void setInitialItemCountEstimateAndIncrease_lessThanRequestedRange_estimateIncreaseUsed() {
        AbstractDataProvider dataProvider = this.createDataProvider(5000);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        int rangeLength = 100;
        this.dataCommunicator.setRequestedRange(400, rangeLength);
        int initialCountEstimate = 300;
        this.dataCommunicator.setItemCountEstimate(300);
        int itemCountEstimateIncrease = 99;
        this.dataCommunicator.setItemCountEstimateIncrease(99);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Size should be automatically adjusted for too small estimate", (long)597L, (long)this.dataCommunicator.getItemCount());
    }

    @Test
    public void setInitialItemCountEstimateAndIncrease_requestedItemsMuchHigherThanExactCount_exactCountIsResolvedOnServer() {
        int exactSize = 200;
        AbstractDataProvider dataProvider = this.createDataProvider(200);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        int itemCountEstimate = 1000;
        this.dataCommunicator.setItemCountEstimate(1000);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((long)1000L, (long)this.dataCommunicator.getItemCount());
        this.dataCommunicator.setRequestedRange(900, 100);
        this.fakeClientCommunication();
        Assert.assertEquals((long)200L, (long)this.dataCommunicator.getItemCount());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)0))).size((Query)Mockito.any());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)11))).fetch((Query)Mockito.any());
    }

    @Test
    public void setInitialItemCountEstimateAndIncrease_backendEmpty_noEndlessFlushLoop() {
        boolean exactSize = false;
        AbstractDataProvider dataProvider = this.createDataProvider(0);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        int itemCountEstimate = 1000;
        this.dataCommunicator.setItemCountEstimate(1000);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((long)0L, (long)this.dataCommunicator.getItemCount());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)0))).size((Query)Mockito.any());
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)1))).fetch((Query)Mockito.any());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setInitialCountEstimate_lessThanOne_throws() {
        this.dataCommunicator.setItemCountEstimate(0);
    }

    @Test
    public void getActiveItemOnIndex_activeRangeChanges_itemsReturned() {
        this.dataCommunicator.setDataProvider(this.createDataProvider(300), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Wrong active item", (Object)new Item(0), (Object)this.dataCommunicator.getItem(0));
        Assert.assertEquals((String)"Wrong active item", (Object)new Item(49), (Object)this.dataCommunicator.getItem(49));
        this.dataCommunicator.setRequestedRange(50, 50);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Wrong active item", (Object)new Item(50), (Object)this.dataCommunicator.getItem(50));
        Assert.assertEquals((String)"Wrong active item", (Object)new Item(69), (Object)this.dataCommunicator.getItem(69));
        Assert.assertEquals((String)"Wrong active item", (Object)new Item(99), (Object)this.dataCommunicator.getItem(99));
    }

    @Test
    public void isItemActive_newItems() {
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        Assert.assertFalse((String)"Item should not be active", (boolean)this.dataCommunicator.isItemActive((Object)new Item(0)));
        this.fakeClientCommunication();
        Assert.assertTrue((String)"Item should be active", (boolean)this.dataCommunicator.isItemActive((Object)new Item(0)));
        Assert.assertTrue((String)"Item should be active", (boolean)this.dataCommunicator.isItemActive((Object)new Item(49)));
        Assert.assertFalse((String)"Item should not be active", (boolean)this.dataCommunicator.isItemActive((Object)new Item(50)));
        this.dataCommunicator.setRequestedRange(50, 50);
        this.fakeClientCommunication();
        Assert.assertTrue((String)"Item should be active", (boolean)this.dataCommunicator.isItemActive((Object)new Item(50)));
        Assert.assertTrue((String)"Item should be active", (boolean)this.dataCommunicator.isItemActive((Object)new Item(99)));
        Assert.assertFalse((String)"Item should not be active", (boolean)this.dataCommunicator.isItemActive((Object)new Item(100)));
    }

    @Test
    public void getItem_withDefinedSizeAndCorrectIndex() {
        this.dataCommunicator.setRequestedRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return IntStream.of(0, 1, 2).mapToObj(Item::new);
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 3), null);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item on index 1", (Object)new Item(1), (Object)this.dataCommunicator.getItem(1));
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> IntStream.range(0, 300).mapToObj(Item::new).skip(query.getOffset()).limit(query.getLimit()), (CallbackDataProvider.CountCallback & Serializable)query -> 300), null);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item on index 260", (Object)new Item(260), (Object)this.dataCommunicator.getItem(260));
    }

    @Test
    public void getItem_withDefinedSizeAndNegativeIndex() {
        this.expectedException.expect(IndexOutOfBoundsException.class);
        this.expectedException.expectMessage("Index must be non-negative");
        this.dataCommunicator.setRequestedRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.of(new Item(0));
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 1), null);
        this.fakeClientCommunication();
        this.dataCommunicator.getItem(-1);
    }

    @Test
    public void getItem_withDefinedSizeAndEmptyDataset() {
        this.expectedException.expect(IndexOutOfBoundsException.class);
        this.expectedException.expectMessage("Requested index 0 on empty data.");
        this.dataCommunicator.setRequestedRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.empty();
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 0), null);
        this.fakeClientCommunication();
        this.dataCommunicator.getItem(0);
    }

    @Test
    public void getItem_withDefinedSizeAndIndexOutsideOfRange() {
        this.expectedException.expect(IndexOutOfBoundsException.class);
        this.expectedException.expectMessage("Given index 3 is outside of the accepted range '0 - 2'");
        this.dataCommunicator.setRequestedRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return IntStream.of(0, 1, 2).mapToObj(Item::new);
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 3), null);
        this.fakeClientCommunication();
        this.dataCommunicator.getItem(3);
    }

    @Test
    public void getItem_withDefinedSizeAndFiltering() {
        Item initialFilter = new Item(1);
        Item newFilter = new Item(2);
        this.dataCommunicator.setRequestedRange(0, 50);
        SerializableConsumer newFilterProvider = this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromFilteringCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return IntStream.of(0, 1, 2).mapToObj(Item::new).filter(item -> item.equals(query.getFilter().get()));
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 1), (Object)initialFilter);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item on index 0", (Object)initialFilter, (Object)this.dataCommunicator.getItem(0));
        newFilterProvider.accept((Object)newFilter);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item on index 0", (Object)newFilter, (Object)this.dataCommunicator.getItem(0));
    }

    @Test
    public void getItem_withDefinedSizeAndSorting() {
        this.dataCommunicator.setRequestedRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            Stream<Item> stream = IntStream.of(1, 2, 0).mapToObj(Item::new);
            if (query.getInMemorySorting() != null) {
                stream = stream.sorted(query.getInMemorySorting());
            }
            return stream;
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 3), null);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item on index 0", (Object)new Item(1), (Object)this.dataCommunicator.getItem(0));
        Assert.assertEquals((String)"Invalid item on index 1", (Object)new Item(2), (Object)this.dataCommunicator.getItem(1));
        Assert.assertEquals((String)"Invalid item on index 2", (Object)new Item(0), (Object)this.dataCommunicator.getItem(2));
        this.dataCommunicator.setInMemorySorting((SerializableComparator & Serializable)(i1, i2) -> Integer.compare(i1.id, i2.id));
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item on index 0", (Object)new Item(0), (Object)this.dataCommunicator.getItem(0));
        Assert.assertEquals((String)"Invalid item on index 1", (Object)new Item(1), (Object)this.dataCommunicator.getItem(1));
        Assert.assertEquals((String)"Invalid item on index 2", (Object)new Item(2), (Object)this.dataCommunicator.getItem(2));
    }

    @Test
    public void getItem_withUndefinedSizeAndCorrectIndex() {
        this.dataCommunicator.setRequestedRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> IntStream.of(0, 1, 2).mapToObj(Item::new).skip(query.getOffset()).limit(query.getLimit()), (CallbackDataProvider.CountCallback & Serializable)query -> -1), null);
        this.dataCommunicator.setItemCountEstimate(5);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Wrong item on index 0", (Object)new Item(0), (Object)this.dataCommunicator.getItem(0));
        Assert.assertEquals((String)"Wrong item on index 1", (Object)new Item(1), (Object)this.dataCommunicator.getItem(1));
        this.dataCommunicator.setRequestedRange(100, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> IntStream.range(0, 500).mapToObj(Item::new).skip(query.getOffset()).limit(query.getLimit()), (CallbackDataProvider.CountCallback & Serializable)query -> -1), null);
        int itemCountEstimate = 400;
        this.dataCommunicator.setItemCountEstimate(400);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Wrong item on index 375", (Object)new Item(375), (Object)this.dataCommunicator.getItem(375));
        Assert.assertEquals((String)"Wrong item on index 450", (Object)new Item(450), (Object)this.dataCommunicator.getItem(450));
    }

    @Test
    public void getItem_withUndefinedSizeAndEmptyDataset() {
        this.dataCommunicator.setRequestedRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> IntStream.of(0, 1, 2).mapToObj(Item::new).skip(query.getOffset()).limit(query.getLimit()), (CallbackDataProvider.CountCallback & Serializable)query -> -1), null);
        this.dataCommunicator.setItemCountEstimate(5);
        Assert.assertEquals((String)"Invalid item on index 1", (Object)new Item(1), (Object)this.dataCommunicator.getItem(1));
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.empty();
        }, (CallbackDataProvider.CountCallback & Serializable)query -> -1), null);
        this.dataCommunicator.setItemCountEstimate(2);
        this.fakeClientCommunication();
        Assert.assertNull((String)"Item on index 0 supposed to be null", (Object)this.dataCommunicator.getItem(0));
    }

    @Test
    public void getItem_withUndefinedSizeAndIndexOutsideOfRange() {
        this.dataCommunicator.setRequestedRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> IntStream.of(0, 1, 2, 3, 4).mapToObj(Item::new).skip(query.getOffset()).limit(query.getLimit()), (CallbackDataProvider.CountCallback & Serializable)query -> -1), null);
        this.dataCommunicator.setItemCountEstimate(3);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item on index 3", (Object)new Item(3), (Object)this.dataCommunicator.getItem(3));
        Assert.assertNull((String)"Item on index 5 supposed to be null", (Object)this.dataCommunicator.getItem(5));
    }

    @Test
    public void getItem_withUndefinedSizeAndNegativeIndex() {
        this.expectedException.expect(IndexOutOfBoundsException.class);
        this.expectedException.expectMessage("Index must be non-negative");
        this.dataCommunicator.setRequestedRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return Stream.of(new Item(0));
        }, (CallbackDataProvider.CountCallback & Serializable)query -> -1), null);
        this.dataCommunicator.setItemCountEstimate(1);
        this.fakeClientCommunication();
        this.dataCommunicator.getItem(-1);
    }

    @Test
    public void getItem_withUndefinedSizeAndFiltering() {
        Item initialFilter = new Item(1);
        Item newFilter = new Item(2);
        this.dataCommunicator.setRequestedRange(0, 50);
        SerializableConsumer newFilterProvider = this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromFilteringCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            return IntStream.of(0, 1, 2).mapToObj(Item::new).filter(item -> item.equals(query.getFilter().get()));
        }, (CallbackDataProvider.CountCallback & Serializable)query -> -1), (Object)initialFilter);
        this.dataCommunicator.setItemCountEstimate(5);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item on index 0", (Object)initialFilter, (Object)this.dataCommunicator.getItem(0));
        newFilterProvider.accept((Object)newFilter);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item on index 0", (Object)newFilter, (Object)this.dataCommunicator.getItem(0));
    }

    @Test
    public void getItem_withUndefinedSizeAndSorting() {
        this.dataCommunicator.setRequestedRange(0, 50);
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            query.getOffset();
            query.getLimit();
            Stream<Item> stream = IntStream.of(1, 2, 0).mapToObj(Item::new);
            if (query.getInMemorySorting() != null) {
                stream = stream.sorted(query.getInMemorySorting());
            }
            return stream;
        }, (CallbackDataProvider.CountCallback & Serializable)query -> 3), null);
        this.dataCommunicator.setItemCountEstimate(5);
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item on index 0", (Object)new Item(1), (Object)this.dataCommunicator.getItem(0));
        Assert.assertEquals((String)"Invalid item on index 1", (Object)new Item(2), (Object)this.dataCommunicator.getItem(1));
        Assert.assertEquals((String)"Invalid item on index 2", (Object)new Item(0), (Object)this.dataCommunicator.getItem(2));
        this.dataCommunicator.setInMemorySorting((SerializableComparator & Serializable)(i1, i2) -> Integer.compare(i1.id, i2.id));
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Invalid item on index 0", (Object)new Item(0), (Object)this.dataCommunicator.getItem(0));
        Assert.assertEquals((String)"Invalid item on index 1", (Object)new Item(1), (Object)this.dataCommunicator.getItem(1));
        Assert.assertEquals((String)"Invalid item on index 2", (Object)new Item(2), (Object)this.dataCommunicator.getItem(2));
    }

    @Test
    public void itemCountEstimateAndStep_defaults() {
        Assert.assertEquals((long)this.dataCommunicator.getItemCountEstimate(), (long)(this.pageSize * 4));
        Assert.assertEquals((long)this.dataCommunicator.getItemCountEstimateIncrease(), (long)(this.pageSize * 4));
        int customPageSize = 100;
        this.dataCommunicator.setPageSize(customPageSize);
        Assert.assertEquals((long)this.dataCommunicator.getItemCountEstimate(), (long)(customPageSize * 4));
        Assert.assertEquals((long)this.dataCommunicator.getItemCountEstimateIncrease(), (long)(customPageSize * 4));
        int customItemCountEstimate = 123;
        this.dataCommunicator.setItemCountEstimate(customItemCountEstimate);
        int customItemCountEstimateStep = 456;
        this.dataCommunicator.setItemCountEstimateIncrease(customItemCountEstimateStep);
        Assert.assertEquals((long)this.dataCommunicator.getItemCountEstimate(), (long)customItemCountEstimate);
        Assert.assertEquals((long)this.dataCommunicator.getItemCountEstimateIncrease(), (long)customItemCountEstimateStep);
    }

    @Test
    public void itemCountChangeEvent_exactSize_correctCountAndIsCountEstimated() {
        TestComponent component = new TestComponent();
        this.ui.add(new Component[]{component});
        this.dataCommunicator = new DataCommunicator(this.dataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> {}, component.getElement().getNode());
        AtomicReference cachedEvent = new AtomicReference();
        ComponentUtil.addListener((Component)component, ItemCountChangeEvent.class, (ComponentEventListener & Serializable)event -> {
            Assert.assertNull(cachedEvent.get());
            cachedEvent.set((ItemCountChangeEvent)event);
        });
        int exactCount = 500;
        this.dataCommunicator.setDataProvider(this.createDataProvider(exactCount), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        ItemCountChangeEvent event2 = cachedEvent.getAndSet(null);
        Assert.assertEquals((String)"Invalid count provided", (long)exactCount, (long)event2.getItemCount());
        Assert.assertFalse((boolean)event2.isItemCountEstimated());
        this.dataCommunicator.setRequestedRange(450, 50);
        this.fakeClientCommunication();
        Assert.assertNull(cachedEvent.get());
        this.dataCommunicator.setDataProvider(this.createDataProvider(500), null);
        this.fakeClientCommunication();
        Assert.assertNull(cachedEvent.get());
        exactCount = 1000;
        this.dataCommunicator.setDataProvider(this.createDataProvider(1000), null);
        this.fakeClientCommunication();
        event2 = cachedEvent.getAndSet(null);
        Assert.assertEquals((String)"Invalid count provided", (long)exactCount, (long)event2.getItemCount());
        Assert.assertFalse((boolean)event2.isItemCountEstimated());
    }

    @Test
    public void itemCountChangeEvent_estimatedCount_estimateUsedUntilEndReached() {
        TestComponent component = new TestComponent();
        this.ui.add(new Component[]{component});
        this.dataCommunicator = new DataCommunicator(this.dataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> {}, component.getElement().getNode());
        AtomicReference<Object> cachedEvent = new AtomicReference<Object>();
        ComponentUtil.addListener((Component)component, ItemCountChangeEvent.class, (ComponentEventListener & Serializable)event -> {
            Assert.assertNull(cachedEvent.get());
            cachedEvent.set((ItemCountChangeEvent)event);
        });
        int exactCount = 500;
        this.dataCommunicator.setDataProvider(this.createDataProvider(exactCount), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.dataCommunicator.setDefinedSize(false);
        this.fakeClientCommunication();
        ItemCountChangeEvent event2 = cachedEvent.getAndSet(null);
        Assert.assertEquals((String)"Invalid count provided", (long)200L, (long)event2.getItemCount());
        Assert.assertTrue((boolean)event2.isItemCountEstimated());
        this.dataCommunicator.setRequestedRange(150, 50);
        this.fakeClientCommunication();
        event2 = cachedEvent.getAndSet(null);
        Assert.assertEquals((String)"Invalid count provided", (long)400L, (long)event2.getItemCount());
        Assert.assertTrue((boolean)event2.isItemCountEstimated());
        this.dataCommunicator.setRequestedRange(350, 50);
        this.fakeClientCommunication();
        event2 = cachedEvent.getAndSet(null);
        Assert.assertEquals((String)"Invalid count provided", (long)600L, (long)event2.getItemCount());
        Assert.assertTrue((boolean)event2.isItemCountEstimated());
        this.dataCommunicator.setRequestedRange(550, 50);
        this.fakeClientCommunication();
        event2 = cachedEvent.getAndSet(null);
        Assert.assertEquals((String)"Invalid count provided", (long)500L, (long)event2.getItemCount());
        Assert.assertFalse((boolean)event2.isItemCountEstimated());
    }

    @Test
    public void setDefinedSize_rangeEndEqualsAssumedSize_flushRequested() {
        this.fakeClientCommunication();
        StateNode stateNode = (StateNode)Mockito.spy((Object)this.element.getNode());
        DataCommunicator dataCommunicator = new DataCommunicator(this.dataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> {}, stateNode);
        dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.fakeClientCommunication();
        dataCommunicator.setRequestedRange(0, 100);
        this.fakeClientCommunication();
        Mockito.reset((Object[])new StateNode[]{stateNode});
        dataCommunicator.setDefinedSize(false);
        this.fakeClientCommunication();
        ((StateNode)Mockito.verify((Object)stateNode)).runWhenAttached((SerializableConsumer)Mockito.any());
        Assert.assertEquals((long)300L, (long)dataCommunicator.getItemCount());
    }

    @Test
    public void pageSize_defaultPageSizeUsed_returnsItemNormally() {
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.ofItems((Object[])new Item[]{new Item(0)}), null);
        Stream itemStream = this.dataCommunicator.fetchFromProvider(0, 100);
        Assert.assertNotNull((Object)itemStream);
        Assert.assertEquals((long)1L, (long)itemStream.count());
    }

    @Test
    public void fetchFromProvider_pageSizeLessThanLimit_multiplePagedQueries() {
        AbstractDataProvider dataProvider = this.createDataProvider(100);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setPageSize(10);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        Stream stream = this.dataCommunicator.fetchFromProvider(0, 23);
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(Query.class);
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)3))).fetch((Query)queryCaptor.capture());
        List items = stream.collect(Collectors.toList());
        Assert.assertEquals((long)30L, (long)items.size());
        Assert.assertEquals(IntStream.range(0, 30).mapToObj(Item::new).collect(Collectors.toList()), items);
        List allQueries = queryCaptor.getAllValues();
        Assert.assertEquals((long)3L, (long)allQueries.size());
        Query query = (Query)allQueries.get(0);
        Assert.assertEquals((long)0L, (long)query.getOffset());
        Assert.assertEquals((long)10L, (long)query.getLimit());
        Assert.assertEquals((long)0L, (long)query.getPage());
        Assert.assertEquals((long)10L, (long)query.getPageSize());
        query = (Query)allQueries.get(1);
        Assert.assertEquals((long)10L, (long)query.getOffset());
        Assert.assertEquals((long)10L, (long)query.getLimit());
        Assert.assertEquals((long)1L, (long)query.getPage());
        Assert.assertEquals((long)10L, (long)query.getPageSize());
        query = (Query)allQueries.get(2);
        Assert.assertEquals((long)20L, (long)query.getOffset());
        Assert.assertEquals((long)10L, (long)query.getLimit());
        Assert.assertEquals((long)2L, (long)query.getPage());
        Assert.assertEquals((long)10L, (long)query.getPageSize());
        Mockito.reset((Object[])new AbstractDataProvider[]{dataProvider});
        this.dataCommunicator.fetchFromProvider(0, 30);
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)3))).fetch((Query)Mockito.any(Query.class));
    }

    @Test
    public void fetchFromProvider_limitEqualsPageSize_singleQuery() {
        AbstractDataProvider dataProvider = this.createDataProvider(100);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        Stream stream = this.dataCommunicator.fetchFromProvider(0, 50);
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(Query.class);
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider)).fetch((Query)queryCaptor.capture());
        List items = stream.collect(Collectors.toList());
        Assert.assertEquals((long)50L, (long)items.size());
        Assert.assertEquals(IntStream.range(0, 50).mapToObj(Item::new).collect(Collectors.toList()), items);
        Query query = (Query)queryCaptor.getValue();
        Assert.assertEquals((long)0L, (long)query.getOffset());
        Assert.assertEquals((long)50L, (long)query.getLimit());
        Assert.assertEquals((long)0L, (long)query.getPage());
        Assert.assertEquals((long)50L, (long)query.getPageSize());
    }

    @Test
    public void fetchFromProvider_limitLessThanPageSize_singleQuery_fetchedLessThanPage() {
        AbstractDataProvider dataProvider = this.createDataProvider(100);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        Stream stream = this.dataCommunicator.fetchFromProvider(10, 42);
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(Query.class);
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider)).fetch((Query)queryCaptor.capture());
        List items = stream.collect(Collectors.toList());
        Assert.assertEquals((long)42L, (long)items.size());
        Assert.assertEquals(IntStream.range(10, 52).mapToObj(Item::new).collect(Collectors.toList()), items);
        Query query = (Query)queryCaptor.getValue();
        Assert.assertEquals((long)10L, (long)query.getOffset());
        Assert.assertEquals((long)42L, (long)query.getLimit());
        Assert.assertEquals((long)0L, (long)query.getPage());
        Assert.assertEquals((long)42L, (long)query.getPageSize());
    }

    @Test
    public void fetchFromProvider_disablePaging_singleQueryWithLimit() {
        AbstractDataProvider dataProvider = this.createDataProvider(200);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setPagingEnabled(false);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        Stream stream = this.dataCommunicator.fetchFromProvider(0, 123);
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(Query.class);
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider)).fetch((Query)queryCaptor.capture());
        List items = stream.collect(Collectors.toList());
        Assert.assertEquals((long)123L, (long)items.size());
        Assert.assertEquals(IntStream.range(0, 123).mapToObj(Item::new).collect(Collectors.toList()), items);
        List allQueries = queryCaptor.getAllValues();
        Assert.assertEquals((long)1L, (long)allQueries.size());
        Query query = (Query)allQueries.get(0);
        Assert.assertEquals((long)0L, (long)query.getOffset());
        Assert.assertEquals((long)123L, (long)query.getLimit());
        Assert.assertEquals((long)0L, (long)query.getPage());
        Assert.assertEquals((long)123L, (long)query.getPageSize());
    }

    @Test
    public void fetchFromProvider_maxLimitValue_pagesCalculatedProperly() {
        AbstractDataProvider dataProvider = this.createDataProvider(42);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.dataCommunicator.setPageSize(2000000000);
        this.dataCommunicator.fetchFromProvider(0, Integer.MAX_VALUE);
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)1))).fetch((Query)Mockito.any(Query.class));
    }

    @Test
    public void fetchFromProvider_backendRunsOutOfItems_secondPageRequestSkipped() {
        AbstractDataProvider dataProvider = this.createDataProvider(42);
        dataProvider = (AbstractDataProvider)Mockito.spy(dataProvider);
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.dataCommunicator.fetchFromProvider(0, 100);
        ((AbstractDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)1))).fetch((Query)Mockito.any(Query.class));
    }

    @Test
    public void fetchEnabled_getItemCount_stillReturnsItemsCount() {
        this.dataCommunicator.setFetchEnabled(false);
        Assert.assertEquals((long)0L, (long)this.dataCommunicator.getItemCount());
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        Assert.assertEquals((long)100L, (long)this.dataCommunicator.getItemCount());
    }

    @Test
    public void fetchEnabled_getItem_stillReturnsItem() {
        this.dataCommunicator.setFetchEnabled(false);
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        Assert.assertNotNull((Object)this.dataCommunicator.getItem(42));
    }

    @Test
    public void fetchEnabled_requestRange_fetchIgnored() {
        DataCommunicator dataCommunicator = new DataCommunicator(this.dataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> {}, this.element.getNode(), false);
        DataProvider dataProvider = (DataProvider)Mockito.spy((Object)DataProvider.ofItems((Object[])new Item[]{new Item(0)}));
        dataCommunicator.setDataProvider(dataProvider, null);
        dataCommunicator.setRequestedRange(0, 0);
        this.fakeClientCommunication();
        ((DataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)0))).fetch((Query)Mockito.any(Query.class));
        ((DataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)0))).size((Query)Mockito.any(Query.class));
        dataCommunicator.setFetchEnabled(true);
        dataCommunicator.setRequestedRange(0, 10);
        this.fakeClientCommunication();
        ((DataProvider)Mockito.verify((Object)dataProvider)).fetch((Query)Mockito.any(Query.class));
        ((DataProvider)Mockito.verify((Object)dataProvider)).size((Query)Mockito.any(Query.class));
    }

    @Test
    public void setPageSize_setIncorrectPageSize_throws() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Page size cannot be less than 1, got 0");
        this.dataCommunicator.setPageSize(0);
    }

    @Test
    public void filter_setFilterThroughFilterConsumer_shouldRetainFilterBetweenRequests() {
        SerializableConsumer filterConsumer = this.dataCommunicator.setDataProvider((DataProvider)DataProvider.ofItems((Object[])new Item[]{new Item(1), new Item(2), new Item(3)}), (SerializablePredicate & Serializable)item -> item.id > 1);
        Assert.assertNotNull((String)"Expected initial filter to be set", (Object)this.dataCommunicator.getFilter());
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertNotNull((String)"Filter should be retained after data request", (Object)this.dataCommunicator.getFilter());
        Assert.assertEquals((String)"Unexpected items count", (long)2L, (long)this.dataCommunicator.getItemCount());
        filterConsumer.accept((SerializablePredicate & Serializable)item -> item.id > 2);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertNotNull((String)"Filter should be retained after data request", (Object)this.dataCommunicator.getFilter());
        Assert.assertEquals((String)"Unexpected items count", (long)1L, (long)this.dataCommunicator.getItemCount());
    }

    @Test
    public void filter_setNotifyOnFilterChange_firesItemChangeEvent() {
        TestComponent testComponent = new TestComponent(this.element);
        AtomicBoolean eventTriggered = new AtomicBoolean(false);
        testComponent.addItemChangeListener((ComponentEventListener & Serializable)event -> {
            eventTriggered.set(true);
            Assert.assertEquals((String)"Unexpected item count", (long)2L, (long)event.getItemCount());
        });
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.ofItems((Object[])new Item[]{new Item(1), new Item(2), new Item(3)}), (SerializablePredicate & Serializable)item -> item.id > 1);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
        Assert.assertTrue((String)"Expected event to be triggered", (boolean)eventTriggered.get());
    }

    @Test
    public void filter_skipNotifyOnFilterChange_doesNotFireItemChangeEvent() {
        TestComponent testComponent = new TestComponent(this.element);
        testComponent.addItemChangeListener((ComponentEventListener & Serializable)event -> Assert.fail((String)"Event triggering not expected"));
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.ofItems((Object[])new Item[]{new Item(1), new Item(2), new Item(3)}), (SerializablePredicate & Serializable)item -> item.id > 1, false);
        this.dataCommunicator.setRequestedRange(0, 50);
        this.fakeClientCommunication();
    }

    @Test
    public void setDataProvider_setNewDataProvider_filteringAndSortingRemoved() {
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.ofItems((Object[])new Item[]{new Item(0), new Item(1), new Item(2)}), null);
        AbstractListDataView<Item> listDataView = new AbstractListDataView<Item>(() -> this.dataCommunicator.getDataProvider(), (Component)new TestComponent(this.element), (SerializableBiConsumer & Serializable)(filter, sorting) -> {}){};
        Assert.assertEquals((String)"Unexpected items count before filter", (long)3L, (long)listDataView.getItems().count());
        Assert.assertEquals((String)"Unexpected items order before sorting", (Object)new Item(0), listDataView.getItems().findFirst().orElse(null));
        listDataView.setFilter((SerializablePredicate & Serializable)item -> item.id < 2);
        listDataView.setSortOrder((ValueProvider & Serializable)item -> item.id, SortDirection.DESCENDING);
        Assert.assertEquals((String)"Unexpected items count after filter", (long)2L, (long)listDataView.getItems().count());
        Assert.assertEquals((String)"Unexpected items order after sorting", (Object)new Item(1), listDataView.getItems().findFirst().orElse(null));
        this.dataCommunicator.setDataProvider((DataProvider)DataProvider.ofItems((Object[])new Item[]{new Item(0), new Item(1), new Item(2)}), null);
        Assert.assertEquals((String)"Unexpected items count after data provider reset", (long)3L, (long)listDataView.getItems().count());
        Assert.assertEquals((String)"Unexpected items order after data provider reset", (Object)new Item(0), listDataView.getItems().findFirst().orElse(null));
    }

    @Test
    public void lazyLoadingFiltering_filterAppliedAfterScrolling_requestedRangeResolvedProperly() {
        AtomicReference<Object> filter = new AtomicReference<Object>(null);
        CallbackDataProvider dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> IntStream.range(0, 1000).mapToObj(counter -> new Item(counter, String.valueOf(counter))).filter(item -> filter.get() == null || ((Item)filter.get()).equals(item)).limit(query.getLimit()).skip(query.getOffset()), (CallbackDataProvider.CountCallback & Serializable)query -> {
            Assert.fail((String)"Count query is not expected in this test.");
            return 0;
        });
        this.dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        this.dataCommunicator.setDefinedSize(false);
        this.dataCommunicator.setRequestedRange(0, 100);
        this.fakeClientCommunication();
        this.dataCommunicator.setRequestedRange(100, 150);
        this.fakeClientCommunication();
        filter.set(new Item(42, "42"));
        this.dataCommunicator.getDataProvider().refreshAll();
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected 1 item after the filtering", (long)1L, (long)this.dataCommunicator.getItemCount());
        Assert.assertEquals((String)"Expected the item with value 42", filter.get(), (Object)this.dataCommunicator.getItem(0));
    }

    @Test
    public void handleAttach_componentAttached_oldDataProviderListenerRemoved() {
        final AtomicInteger listenerInvocationCounter = new AtomicInteger(0);
        TestComponent componentWithDataProvider = new TestComponent(new Element("div"));
        this.dataCommunicator = new DataCommunicator<Item>(this.dataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> {}, componentWithDataProvider.getElement().getNode()){

            public void reset() {
                listenerInvocationCounter.incrementAndGet();
                super.reset();
            }
        };
        this.dataCommunicator.setRequestedRange(0, 100);
        AbstractDataProvider<Item, Object> dataProvider = this.createDataProvider();
        this.dataCommunicator.setDataProvider(dataProvider, null);
        this.ui.add(new Component[]{componentWithDataProvider});
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected two DataCommunicator::reset() invocations: upon setting the data provider and component attaching", (long)2L, (long)listenerInvocationCounter.get());
        dataProvider.refreshAll();
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected only one reset() invocation, because the old listener was removed and then only one listener is stored", (long)3L, (long)listenerInvocationCounter.get());
    }

    @Test
    public void setRequestedRange_defaultPageSize_tooMuchItemsRequested_maxItemsAllowedRequested() {
        DataProvider dataProvider = (DataProvider)Mockito.spy(this.createDataProvider(1000));
        this.dataCommunicator.setDataProvider(dataProvider, null);
        this.dataCommunicator.setPagingEnabled(false);
        this.dataCommunicator.setRequestedRange(0, 501);
        this.fakeClientCommunication();
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(Query.class);
        ((DataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)1))).fetch((Query)queryCaptor.capture());
        Assert.assertEquals((String)"Expected the requested items count to be limited to allowed threshold", (long)500L, (long)((Query)queryCaptor.getValue()).getLimit());
    }

    @Test
    public void setSmallPageSize_fetchMaximumItemsLowerLimit() {
        DataProvider dataProvider = (DataProvider)Mockito.spy(this.createDataProvider(1000));
        this.dataCommunicator.setDataProvider(dataProvider, null);
        this.dataCommunicator.setPageSize(2);
        this.dataCommunicator.setRequestedRange(0, 1000);
        this.fakeClientCommunication();
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(Query.class);
        ((DataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)250))).fetch((Query)queryCaptor.capture());
    }

    @Test
    public void setRequestedRange_customPageSize_customPageSizeConsidered_itemsRequested() {
        int newPageSize = 300;
        this.dataCommunicator.setPageSize(newPageSize);
        DataProvider dataProvider = (DataProvider)Mockito.spy(this.createDataProvider(1000));
        this.dataCommunicator.setDataProvider(dataProvider, null);
        this.dataCommunicator.setPagingEnabled(false);
        this.dataCommunicator.setRequestedRange(0, newPageSize * 2);
        this.fakeClientCommunication();
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(Query.class);
        ((DataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)1))).fetch((Query)queryCaptor.capture());
        Assert.assertEquals((String)"Expected two pages with page size = 300 to be requested and not limited", (long)600L, (long)((Query)queryCaptor.getValue()).getLimit());
    }

    @Test
    public void reattach_differentUI_requestFlushExecuted() {
        this.dataCommunicator.setDataProvider(this.createDataProvider(), null);
        this.dataCommunicator.setRequestedRange(0, 50);
        MockUI newUI = new MockUI();
        newUI.getInternals().moveElementsFrom((UI)this.ui);
        this.ui = newUI;
        this.fakeClientCommunication();
        Assert.assertEquals((String)"Expected initial full reset.", (Object)Range.withLength((int)0, (int)50), (Object)this.lastSet);
    }

    private int getPageSizeIncrease() {
        return this.dataCommunicator.getPageSize() * 4;
    }

    private void fakeClientCommunication() {
        this.ui.getInternals().getStateTree().runExecutionsBeforeClientResponse();
        this.ui.getInternals().getStateTree().collectChanges(ignore -> {});
    }

    private AbstractDataProvider<Item, Object> createDataProviderThatChangesSize(final int size, final int delta) {
        return new AbstractDataProvider<Item, Object>(){
            private boolean modifiedCount;

            public boolean isInMemory() {
                return true;
            }

            public int size(Query<Item, Object> query) {
                if (this.modifiedCount) {
                    return size - delta;
                }
                return size;
            }

            public Stream<Item> fetch(Query<Item, Object> query) {
                int count = query.getLimit() + query.getOffset();
                if (!this.modifiedCount) {
                    count -= delta;
                    this.modifiedCount = true;
                }
                return DataCommunicatorTest.this.asParallelIfRequired(IntStream.range(query.getOffset(), count)).mapToObj(Item::new);
            }
        };
    }

    private AbstractDataProvider<Item, Object> createDataProvider() {
        return new AbstractDataProvider<Item, Object>(){

            public boolean isInMemory() {
                return true;
            }

            public int size(Query<Item, Object> query) {
                return 100;
            }

            public Stream<Item> fetch(Query<Item, Object> query) {
                return DataCommunicatorTest.this.asParallelIfRequired(IntStream.range(query.getOffset(), query.getLimit() + query.getOffset())).mapToObj(Item::new);
            }
        };
    }

    private AbstractDataProvider<Item, Object> createDataProvider(final int size) {
        return new AbstractDataProvider<Item, Object>(){

            public boolean isInMemory() {
                return true;
            }

            public int size(Query<Item, Object> query) {
                return size;
            }

            public Stream<Item> fetch(Query<Item, Object> query) {
                int end = Math.min(query.getRequestedRangeEnd(), size);
                return DataCommunicatorTest.this.asParallelIfRequired(IntStream.range(query.getOffset(), end)).mapToObj(Item::new);
            }
        };
    }

    private IntStream asParallelIfRequired(IntStream stream) {
        if (this.dataProviderWithParallelStream) {
            return stream.parallel();
        }
        return stream;
    }

    public static class MockUI
    extends UI {
        public MockUI() {
            this(MockUI.findOrcreateSession());
        }

        public MockUI(VaadinSession session) {
            this.getInternals().setSession(session);
            MockUI.setCurrent((UI)this);
        }

        protected void init(VaadinRequest request) {
        }

        private static VaadinSession findOrcreateSession() {
            VaadinSession session = VaadinSession.getCurrent();
            if (session == null) {
                session = new AlwaysLockedVaadinSession(null);
                VaadinSession.setCurrent((VaadinSession)session);
            }
            return session;
        }
    }

    private static class Item {
        private final int id;
        private String value;

        public Item(int id) {
            this(id, "Item " + id);
        }

        public Item(int id, String value) {
            this.id = id;
            this.value = value;
        }

        public String toString() {
            return this.id + ": " + this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                Item that = (Item)obj;
                return that.id == this.id;
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }
    }

    @Tag(value="test-component")
    private static class TestComponent
    extends Component {
        public TestComponent() {
        }

        public TestComponent(Element element) {
            super(element);
        }

        void addItemChangeListener(ComponentEventListener<ItemCountChangeEvent<?>> listener) {
            ComponentUtil.addListener((Component)this, ItemCountChangeEvent.class, listener);
        }
    }

    public static class MockVaadinSession
    extends VaadinSession {
        private static final ThreadLocal<MockVaadinSession> referenceKeeper = new ThreadLocal();
        private int closeCount;
        private ReentrantLock lock = new ReentrantLock();

        public MockVaadinSession(VaadinService service) {
            super(service);
        }

        public void close() {
            super.close();
            ++this.closeCount;
        }

        public int getCloseCount() {
            return this.closeCount;
        }

        public Lock getLockInstance() {
            return this.lock;
        }

        public void lock() {
            super.lock();
            referenceKeeper.set(this);
        }

        public void unlock() {
            super.unlock();
            referenceKeeper.remove();
        }
    }

    public static class AlwaysLockedVaadinSession
    extends MockVaadinSession {
        public AlwaysLockedVaadinSession(VaadinService service) {
            super(service);
            this.lock();
        }
    }
}

