/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.binder.PropertyFilterDefinition;
import com.vaadin.flow.data.binder.PropertySet;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.tests.data.bean.Address;
import com.vaadin.flow.tests.data.bean.Country;
import com.vaadin.flow.tests.data.bean.FatherAndSon;
import com.vaadin.flow.tests.data.bean.Sex;
import com.vaadin.flow.tests.server.ClassesSerializableUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Test;

public class BeanPropertySetTest {
    @Test
    public void testSerializeDeserialize_propertySet() throws Exception {
        PropertySet originalPropertySet = BeanPropertySet.get(Person.class);
        PropertySet deserializedPropertySet = ClassesSerializableUtils.serializeAndDeserialize(originalPropertySet);
        this.comparePropertySet(originalPropertySet, deserializedPropertySet, "Deserialized instance should be the same as the original");
    }

    private void comparePropertySet(PropertySet<?> propertySetA, PropertySet<?> propertySetB, String message) {
        PropertyDefinition[] propertiesA = (PropertyDefinition[])propertySetA.getProperties().sorted(Comparator.comparing(PropertyDefinition::getName)).toArray(PropertyDefinition[]::new);
        PropertyDefinition[] propertiesB = (PropertyDefinition[])propertySetA.getProperties().sorted(Comparator.comparing(PropertyDefinition::getName)).toArray(PropertyDefinition[]::new);
        Assert.assertEquals((String)message, (long)propertiesA.length, (long)propertiesB.length);
        for (int i = 0; i < propertiesB.length; ++i) {
            Assert.assertSame((String)message, (Object)propertiesA[i], (Object)propertiesB[i]);
        }
    }

    @Test
    public void testSerializeDeserialize_propertySet_cacheCleared() throws Exception {
        PropertySet originalPropertySet = BeanPropertySet.get(Person.class);
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bs);
        out.writeObject(originalPropertySet);
        byte[] data = bs.toByteArray();
        Field instancesField = BeanPropertySet.class.getDeclaredField("INSTANCES");
        instancesField.setAccessible(true);
        Map instances = (Map)instancesField.get(null);
        instances.clear();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        PropertySet deserializedPropertySet = (PropertySet)in.readObject();
        this.comparePropertySet(BeanPropertySet.get(Person.class), deserializedPropertySet, "Deserialized instance should be the same as in the cache");
        Assert.assertNotSame((String)"Deserialized instance should not be the same as the original", (Object)originalPropertySet, (Object)deserializedPropertySet);
    }

    @Test
    public void testSerializeDeserialize_propertyDefinition() throws Exception {
        PropertyDefinition definition = (PropertyDefinition)BeanPropertySet.get(Person.class).getProperty("born").orElseThrow(RuntimeException::new);
        PropertyDefinition deserializedDefinition = ClassesSerializableUtils.serializeAndDeserialize(definition);
        ValueProvider getter = deserializedDefinition.getGetter();
        Person person = new Person("Milennial", 2000);
        Integer age = (Integer)getter.apply((Object)person);
        Assert.assertEquals((String)"Deserialized definition should be functional", (Object)2000, (Object)age);
        Assert.assertSame((String)"Deserialized instance should be the same as in the cache", BeanPropertySet.get(Person.class).getProperty("born").orElseThrow(RuntimeException::new), (Object)deserializedDefinition);
    }

    @Test
    public void testSerializeDeserialize_nestedPropertyDefinition() throws Exception {
        PropertyDefinition definition = (PropertyDefinition)BeanPropertySet.get(com.vaadin.flow.tests.data.bean.Person.class, (boolean)true, (PropertyFilterDefinition)PropertyFilterDefinition.getDefaultFilter()).getProperty("address.postalCode").orElseThrow(AssertionFailedError::new);
        PropertyDefinition deserializedDefinition = ClassesSerializableUtils.serializeAndDeserialize(definition);
        ValueProvider getter = deserializedDefinition.getGetter();
        Address address = new Address("Ruukinkatu 2-4", 20540, "Turku", Country.FINLAND);
        com.vaadin.flow.tests.data.bean.Person person = new com.vaadin.flow.tests.data.bean.Person("Jon", "Doe", "jon.doe@vaadin.com", 32, Sex.MALE, address);
        Integer postalCode = (Integer)getter.apply((Object)person);
        Assert.assertEquals((String)"Deserialized definition should be functional", (Object)address.getPostalCode(), (Object)postalCode);
    }

    @Test
    public void nestedPropertyDefinition_samePropertyNameOnMultipleLevels() {
        PropertyDefinition definition = (PropertyDefinition)BeanPropertySet.get(FatherAndSon.class).getProperty("father.father.firstName").orElseThrow(RuntimeException::new);
        ValueProvider getter = definition.getGetter();
        FatherAndSon grandFather = new FatherAndSon("Grand Old Jon", "Doe", null, null);
        FatherAndSon father = new FatherAndSon("Old Jon", "Doe", grandFather, null);
        FatherAndSon son = new FatherAndSon("Jon", "Doe", father, null);
        String firstName = (String)getter.apply((Object)son);
        Assert.assertEquals((Object)grandFather.getFirstName(), (Object)firstName);
    }

    @Test(expected=NullPointerException.class)
    public void nestedPropertyDefinition_propertyChainBroken() {
        PropertyDefinition definition = (PropertyDefinition)BeanPropertySet.get(FatherAndSon.class).getProperty("father.firstName").orElseThrow(RuntimeException::new);
        ValueProvider getter = definition.getGetter();
        getter.apply((Object)new FatherAndSon("Jon", "Doe", null, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nestedPropertyDefinition_invalidPropertyNameInChain() {
        BeanPropertySet.get(FatherAndSon.class).getProperty("grandfather.firstName");
    }

    @Test(expected=IllegalArgumentException.class)
    public void nestedPropertyDefinition_invalidPropertyNameAtChainEnd() {
        BeanPropertySet.get(FatherAndSon.class).getProperty("father.age");
    }

    @Test
    public void properties() {
        PropertySet propertySet = BeanPropertySet.get(Person.class);
        Set propertyNames = propertySet.getProperties().map(PropertyDefinition::getName).collect(Collectors.toSet());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("name", "born")), propertyNames);
    }

    @Test
    public void isSubProperty() {
        PropertySet propertySet = BeanPropertySet.get(FatherAndSon.class);
        Assert.assertTrue((String)"Dot-separated property chain \"father.firstName\" should refer to a sub-property", (boolean)((PropertyDefinition)propertySet.getProperty("father.firstName").get()).isSubProperty());
        Assert.assertFalse((String)"Property name without dot-separated parent properties should not refer to a sub-property", (boolean)((PropertyDefinition)propertySet.getProperty("father").get()).isSubProperty());
        Assert.assertTrue((String)"Dot-separated property chain \"father.son.father.son\" should refer to a sub-property", (boolean)((PropertyDefinition)propertySet.getProperty("father.son.father.son").get()).isSubProperty());
    }

    @Test
    public void getFullName_returnsFullPropertyChain() {
        PropertySet propertySet = BeanPropertySet.get(FatherAndSon.class);
        String subPropertyFullName = "father.son.father.son.firstName";
        PropertyDefinition subProperty = (PropertyDefinition)propertySet.getProperty(subPropertyFullName).get();
        Assert.assertEquals((String)"Name of a sub-property should be the simple name of the property", (Object)"firstName", (Object)subProperty.getTopLevelName());
        Assert.assertEquals((String)"Full name of a sub-property should be the full property chain with parent properties", (Object)subPropertyFullName, (Object)subProperty.getName());
    }

    @Test
    public void getParentForDirectProperty_returnsNull() {
        PropertySet propertySet = BeanPropertySet.get(FatherAndSon.class);
        Assert.assertNull((String)"Direct property of a property set should not have a parent", (Object)((PropertyDefinition)propertySet.getProperty("father").get()).getParent());
    }

    @Test
    public void getParentForSubProperty_returnsParent() {
        PropertySet propertySet = BeanPropertySet.get(FatherAndSon.class);
        Assert.assertEquals((String)"Parent property of \"father.son.father\" should be \"father.son\"", (Object)"father.son", (Object)((PropertyDefinition)propertySet.getProperty("father.son.father").get()).getParent().getName());
    }

    public static class Person
    implements Serializable {
        private String name;
        private final int born;

        public Person(String name, int born) {
            this.name = name;
            this.born = born;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getBorn() {
            return this.born;
        }

        public String toString() {
            return this.name + "(" + this.born + ")";
        }
    }
}

