/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.data.binder.BeanPropertySet;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.PropertyFilterDefinition;
import com.vaadin.flow.data.binder.PropertyId;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.binder.testcomponents.TestDatePicker;
import com.vaadin.flow.data.binder.testcomponents.TestFormLayout;
import com.vaadin.flow.data.binder.testcomponents.TestTextField;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.StringToIntegerConverter;
import com.vaadin.flow.data.validator.StringLengthValidator;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.tests.data.bean.Address;
import com.vaadin.flow.tests.data.bean.Person;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class BinderInstanceFieldTest {
    @Test
    public void bindInstanceFields_bindAllFields() {
        BindAllFields form = new BindAllFields();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        person.setBirthDate(LocalDate.now());
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        Assert.assertEquals((Object)person.getBirthDate(), (Object)form.birthDate.getValue());
        form.firstName.setValue("bar");
        form.birthDate.setValue(person.getBirthDate().plusDays(345L));
        Assert.assertEquals((Object)form.firstName.getValue(), (Object)person.getFirstName());
        Assert.assertEquals((Object)form.birthDate.getValue(), (Object)person.getBirthDate());
    }

    @Test(expected=IllegalStateException.class)
    public void bind_instanceFields_noArgsConstructor() {
        BindAllFields form = new BindAllFields();
        Binder binder = new Binder();
        binder.bindInstanceFields((Object)form);
    }

    @Test
    public void bindInstanceFields_bindOnlyOneFields() {
        BindOnlyOneField form = new BindOnlyOneField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        Assert.assertNull((Object)((Object)form.noFieldInPerson));
        form.firstName.setValue("bar");
        Assert.assertEquals((Object)form.firstName.getValue(), (Object)person.getFirstName());
    }

    @Test
    public void bindInstanceFields_bindNotHasValueField_fieldIsNull() {
        BindFieldHasWrongType form = new BindFieldHasWrongType();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertNull((Object)form.firstName);
    }

    @Test
    public void bindInstanceFields_genericField() {
        BindGenericField form = new BindGenericField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        form.firstName.setValue("bar");
        Assert.assertEquals((Object)form.firstName.getValue(), (Object)person.getFirstName());
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_genericFieldWithWrongTypeParameter() {
        BindGenericWrongTypeParameterField form = new BindGenericWrongTypeParameterField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_generic() {
        BindGeneric form = new BindGeneric();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields(form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_rawFieldType() {
        BindRaw form = new BindRaw();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_abstractFieldType() {
        BindAbstract form = new BindAbstract();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_noInstantiatableFieldType() {
        BindNonInstantiatableType form = new BindNonInstantiatableType();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_wrongFieldType() {
        BindWrongTypeParameterField form = new BindWrongTypeParameterField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test
    public void bindInstanceFields_complexGenericHierarchy() {
        BindComplextHierarchyGenericType form = new BindComplextHierarchyGenericType();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        form.firstName.setValue("bar");
        Assert.assertEquals((Object)form.firstName.getValue(), (Object)person.getFirstName());
    }

    @Test
    public void bindInstanceFields_bindNotHasValueField_fieldIsNotReplaced() {
        BindFieldHasWrongType form = new BindFieldHasWrongType();
        Binder binder = new Binder(Person.class);
        String name = "foo";
        form.firstName = name;
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)name, (Object)form.firstName);
    }

    @Test
    public void bindInstanceFields_bindAllFieldsUsingAnnotations() {
        BindFieldsUsingAnnotation form = new BindFieldsUsingAnnotation();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        person.setBirthDate(LocalDate.now());
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.nameField.getValue());
        Assert.assertEquals((Object)person.getBirthDate(), (Object)form.birthDateField.getValue());
        form.nameField.setValue("bar");
        form.birthDateField.setValue(person.getBirthDate().plusDays(345L));
        Assert.assertEquals((Object)form.nameField.getValue(), (Object)person.getFirstName());
        Assert.assertEquals((Object)form.birthDateField.getValue(), (Object)person.getBirthDate());
    }

    @Test
    public void bindInstanceFields_bindNestedFieldUsingAnnotation() {
        BindNestedFieldsUsingAnnotation form = new BindNestedFieldsUsingAnnotation();
        Binder binder = new Binder(Person.class, true);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        Address address = new Address();
        address.setStreetAddress("Foo st.");
        person.setAddress(address);
        binder.setBean((Object)person);
        Assert.assertEquals((String)"Reading nested properties bound using annotation", (Object)person.getAddress().getStreetAddress(), (Object)form.streetAddressField.getValue());
        form.streetAddressField.setValue("Bar ave.");
        Assert.assertEquals((String)"Changing nested properties bound using annotation", (Object)form.streetAddressField.getValue(), (Object)person.getAddress().getStreetAddress());
    }

    @Test
    public void bindInstanceFields_bindDeepNestedFieldsUsingAnnotation() {
        BindDeepNestedFieldsUsingAnnotation form = new BindDeepNestedFieldsUsingAnnotation();
        Binder binder = new Binder(Couple.class, true);
        binder.bindInstanceFields((Object)form);
        Person first = new Person();
        Person second = new Person();
        Address firstAddress = new Address();
        firstAddress.setStreetAddress("Foo st.");
        first.setAddress(firstAddress);
        Address secondAddress = new Address();
        second.setAddress(secondAddress);
        secondAddress.setStreetAddress("Bar ave.");
        Couple couple = new Couple();
        couple.setFirst(first);
        couple.setSecond(second);
        binder.setBean((Object)couple);
        Assert.assertEquals((String)"Binding deep nested properties using annotation", (Object)couple.first.getAddress().getStreetAddress(), (Object)form.firstStreetField.getValue());
        Assert.assertEquals((String)"Binding parallel deep nested properties using annotation", (Object)couple.second.getAddress().getStreetAddress(), (Object)form.secondStreetField.getValue());
        form.firstStreetField.setValue(second.getAddress().getStreetAddress());
        Assert.assertEquals((String)"Updating value in deep nested properties", (Object)form.firstStreetField.getValue(), (Object)first.getAddress().getStreetAddress());
    }

    @Test
    public void bindInstanceFields_circular() {
        BindDeepNestingFieldsWithCircularStructure form = new BindDeepNestingFieldsWithCircularStructure();
        Binder binder = new Binder(NestingStructure.class, true);
        binder.bindInstanceFields((Object)form);
        NestingStructure parent = new NestingStructure();
        parent.setName("parent");
        NestingStructure child = new NestingStructure();
        child.setName("child");
        parent.setChild(child);
        NestingStructure grandchild = new NestingStructure();
        grandchild.setName("grandchild");
        child.setChild(grandchild);
        NestingStructure root = grandchild;
        for (int i = 1; i < 15; ++i) {
            NestingStructure ns = new NestingStructure();
            ns.setName("great " + root.getName());
            root.setChild(ns);
            root = ns;
        }
        binder.setBean((Object)parent);
        Assert.assertEquals((Object)child.getName(), (Object)form.childName.getValue());
        Assert.assertEquals((Object)grandchild.getName(), (Object)form.grandchildName.getValue());
        Assert.assertNotNull((String)"Reading nested properties within default supported nested depth (max 10 levels)", (Object)((Object)form.eighthLevelGrandchildName));
        Assert.assertNull((String)"By default, only 10 levels of nesting properties are scanned.", (Object)((Object)form.distantGreatGrandchildName));
    }

    @Test
    public void bindInstanceFields_customNestingLevel() {
        BindDeepNestingFieldsWithCircularStructure form = new BindDeepNestingFieldsWithCircularStructure();
        int customScanningDepth = 5;
        PropertyFilterDefinition shallowFilter = new PropertyFilterDefinition(customScanningDepth, Arrays.asList("java.lang"));
        Binder binder = new Binder(BeanPropertySet.get(NestingStructure.class, (boolean)true, (PropertyFilterDefinition)shallowFilter));
        binder.bindInstanceFields((Object)form);
        NestingStructure parent = new NestingStructure();
        parent.setName("parent");
        NestingStructure child = new NestingStructure();
        child.setName("child");
        parent.setChild(child);
        NestingStructure grandchild = new NestingStructure();
        grandchild.setName("grandchild");
        child.setChild(grandchild);
        NestingStructure root = grandchild;
        for (int i = 1; i < 15; ++i) {
            NestingStructure ns = new NestingStructure();
            ns.setName("great " + root.getName());
            root.setChild(ns);
            root = ns;
        }
        binder.setBean((Object)parent);
        Assert.assertEquals((Object)child.getName(), (Object)form.childName.getValue());
        Assert.assertEquals((String)"Reading 3rd level nesting works when custom scanning depth is 5", (Object)grandchild.getName(), (Object)form.grandchildName.getValue());
        Assert.assertNull((String)"Reading eighth level nesting doesn't work when custom scanning depth is 5", (Object)((Object)form.eighthLevelGrandchildName));
    }

    @Test
    public void bindInstanceFields_bindNotBoundFieldsOnly_customBindingIsNotReplaced() {
        BindAllFields form = new BindAllFields();
        Binder binder = new Binder(Person.class);
        TestTextField name = new TestTextField();
        form.firstName = name;
        binder.forField((HasValue)form.firstName).withValidator((Validator)new StringLengthValidator("Name is invalid", Integer.valueOf(3), Integer.valueOf(10))).bind("firstName");
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        String personName = "foo";
        person.setFirstName(personName);
        person.setBirthDate(LocalDate.now());
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        Assert.assertEquals((Object)person.getBirthDate(), (Object)form.birthDate.getValue());
        Assert.assertEquals((Object)((Object)name), (Object)((Object)form.firstName));
        form.birthDate.setValue(person.getBirthDate().plusDays(345L));
        Assert.assertEquals((Object)form.birthDate.getValue(), (Object)person.getBirthDate());
        form.firstName.setValue("aa");
        Assert.assertEquals((Object)personName, (Object)person.getFirstName());
        Assert.assertFalse((boolean)binder.validate().isOk());
    }

    @Test
    public void bindInstanceFields_fieldsAreConfigured_customBindingIsNotReplaced() {
        BindWithNoFieldInPerson form = new BindWithNoFieldInPerson();
        Binder binder = new Binder(Person.class);
        TestTextField name = new TestTextField();
        form.firstName = name;
        binder.forField((HasValue)form.firstName).withValidator((Validator)new StringLengthValidator("Name is invalid", Integer.valueOf(3), Integer.valueOf(10))).bind("firstName");
        TestTextField ageField = new TestTextField();
        form.noFieldInPerson = ageField;
        binder.forField((HasValue)form.noFieldInPerson).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        String personName = "foo";
        int age = 11;
        person.setFirstName(personName);
        person.setAge(age);
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        Assert.assertEquals((Object)String.valueOf(person.getAge()), (Object)form.noFieldInPerson.getValue());
        Assert.assertEquals((Object)((Object)name), (Object)((Object)form.firstName));
        Assert.assertEquals((Object)((Object)ageField), (Object)((Object)form.noFieldInPerson));
        form.noFieldInPerson.setValue(String.valueOf(age += 56));
        Assert.assertEquals((Object)form.noFieldInPerson.getValue(), (Object)String.valueOf(person.getAge()));
        form.firstName.setValue("aa");
        Assert.assertEquals((Object)personName, (Object)person.getFirstName());
        Assert.assertFalse((boolean)binder.validate().isOk());
    }

    @Test
    public void bindInstanceFields_preconfiguredFieldNotBoundToPropertyPreserved() {
        BindOneFieldRequiresConverter form = new BindOneFieldRequiresConverter();
        form.age = new TestTextField();
        form.firstName = new TestTextField();
        Binder binder = new Binder(Person.class);
        binder.forField((HasValue)form.age).withConverter((SerializableFunction & Serializable)str -> Integer.parseInt(str) / 2, (SerializableFunction & Serializable)integer -> Integer.toString(integer * 2)).bind(Person::getAge, Person::setAge);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("first");
        person.setAge(45);
        binder.setBean((Object)person);
        Assert.assertEquals((Object)"90", (Object)form.age.getValue());
    }

    @Test
    public void bindInstanceFields_explicitelyBoundFieldAndNotBoundField() {
        BindOnlyOneField form = new BindOnlyOneField();
        Binder binder = new Binder(Person.class);
        binder.forField((HasValue)new TestTextField()).bind("firstName");
        binder.bindInstanceFields((Object)form);
    }

    @Test
    public void bindInstanceFields_tentativelyBoundFieldAndNotBoundField() {
        BindOnlyOneField form = new BindOnlyOneField();
        Binder binder = new Binder(Person.class);
        TestTextField field = new TestTextField();
        form.firstName = field;
        binder.forMemberField((HasValue)field);
        binder.bindInstanceFields((Object)form);
    }

    final class NestingStructure {
        NestingStructure child;
        String name;

        NestingStructure() {
        }

        public NestingStructure getChild() {
            return this.child;
        }

        public void setChild(NestingStructure child) {
            this.child = child;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    static final class Couple {
        Person first;
        Person second;

        Couple() {
        }

        public Person getFirst() {
            return this.first;
        }

        public Person getSecond() {
            return this.second;
        }

        public void setFirst(Person first) {
            this.first = first;
        }

        public void setSecond(Person second) {
            this.second = second;
        }
    }

    @Tag(value="input")
    public static class CustomField<T>
    extends AbstractField<CustomField<T>, T> {
        public CustomField() {
            super(null);
        }

        protected void setPresentationValue(T newPresentationValue) {
        }
    }

    public static class ComplexGeneric<U, V, S>
    extends CustomField<V> {
    }

    public static class Generic<T>
    extends ComplexGeneric<Boolean, String, T> {
    }

    public static class ComplexHierarchy
    extends Generic<Long> {
    }

    public static class IntegerTextField
    extends CustomField<Integer> {
    }

    public static class NoDefaultCtor
    extends TestTextField {
        public NoDefaultCtor(int arg) {
        }
    }

    public static class BindComplextHierarchyGenericType
    extends TestFormLayout {
        private ComplexHierarchy firstName;
    }

    public static class BindNonInstantiatableType
    extends TestFormLayout {
        private NoDefaultCtor firstName;
    }

    public static class BindAbstract
    extends TestFormLayout {
        private AbstractTextField firstName;
    }

    public static abstract class AbstractTextField
    extends Component
    implements HasValue<HasValue.ValueChangeEvent<String>, String> {
    }

    public static class BindRaw
    extends TestFormLayout {
        private CustomField firstName;
    }

    public static class BindGeneric<T>
    extends TestFormLayout {
        private CustomField<T> firstName;
    }

    public static class BindOneFieldRequiresConverter
    extends TestFormLayout {
        private TestTextField firstName;
        private TestTextField age;
    }

    public static class BindWrongTypeParameterField
    extends TestFormLayout {
        private IntegerTextField firstName;
    }

    public static class BindGenericWrongTypeParameterField
    extends TestFormLayout {
        private CustomField<Boolean> firstName;
    }

    public static class BindGenericField
    extends TestFormLayout {
        private CustomField<String> firstName;
    }

    public static class BindFieldHasWrongType
    extends TestFormLayout {
        private String firstName;
        private TestDatePicker birthDate;
    }

    public static class BindWithNoFieldInPerson
    extends TestFormLayout {
        private TestTextField firstName;
        private TestDatePicker birthDate;
        private TestTextField noFieldInPerson;
    }

    public static class BindOnlyOneField
    extends TestFormLayout {
        private TestTextField firstName;
        private TestTextField noFieldInPerson;
    }

    public static class BindDeepNestingFieldsWithCircularStructure
    extends TestFormLayout {
        @PropertyId(value="child.name")
        private TestTextField childName;
        @PropertyId(value="child.child.name")
        private TestTextField grandchildName;
        @PropertyId(value="child.child.child.child.child.child.child.child.name")
        private TestTextField eighthLevelGrandchildName;
        @PropertyId(value="child.child.child.child.child.child.child.child.child.child.child.child.child.name")
        private TestTextField distantGreatGrandchildName;
    }

    public static class BindDeepNestedFieldsUsingAnnotation
    extends TestFormLayout {
        @PropertyId(value="first.address.streetAddress")
        private TestTextField firstStreetField;
        @PropertyId(value="second.address.streetAddress")
        private TestTextField secondStreetField;
    }

    public static class BindNestedFieldsUsingAnnotation
    extends TestFormLayout {
        @PropertyId(value="address.streetAddress")
        private TestTextField streetAddressField;
    }

    public static class BindFieldsUsingAnnotation
    extends TestFormLayout {
        @PropertyId(value="firstName")
        private TestTextField nameField;
        @PropertyId(value="birthDate")
        private TestDatePicker birthDateField;
    }

    public static class BindAllFields
    extends TestFormLayout {
        private TestTextField firstName;
        private TestDatePicker birthDate;
    }
}

