/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.renderer.BasicRenderer;
import com.vaadin.flow.data.renderer.NativeButtonRenderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;

public class NativeButtonRendererTest {
    @Test
    public void templateRenderered_containerIsDisabled_buttonIsDisabled() {
        NativeButtonRenderer renderer = new NativeButtonRenderer("Label");
        Element container = new Element("div");
        KeyMapper keyMapper = new KeyMapper();
        Rendering rendering = renderer.render(container, (DataKeyMapper)keyMapper);
        this.mockAttach((NativeButtonRenderer<String>)renderer, container, (Rendering<String>)rendering, (DataKeyMapper<String>)keyMapper);
        Assert.assertTrue((String)"The DataGenerator should be present", (boolean)rendering.getDataGenerator().isPresent());
        DataGenerator dataGenerator = (DataGenerator)rendering.getDataGenerator().get();
        JsonObject json = Json.createObject();
        dataGenerator.generateData((Object)"something", json);
        Assert.assertFalse((String)"The button shouldn't be disabled", (boolean)json.getBoolean(renderer.getTemplatePropertyName(rendering) + "_disabled"));
        this.mockDisabled(container);
        json = Json.createObject();
        dataGenerator.generateData((Object)"something", json);
        Assert.assertTrue((String)"The button should be disabled", (boolean)json.getBoolean(renderer.getTemplatePropertyName(rendering) + "_disabled"));
    }

    private void mockAttach(NativeButtonRenderer<String> renderer, Element container, Rendering<String> rendering, DataKeyMapper<String> keyMapper) {
        try {
            Method method = BasicRenderer.class.getDeclaredMethod("setupTemplateWhenAttached", Element.class, BasicRenderer.SimpleValueRendering.class, DataKeyMapper.class);
            method.setAccessible(true);
            method.invoke(renderer, container, rendering, keyMapper);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void mockDisabled(Element container) {
        container.setEnabled(false);
        container.getChildren().forEach(child -> child.setEnabled(false));
    }
}

