/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.binder.BindingException;
import com.vaadin.flow.data.binder.DefaultBindingExceptionHandler;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultBindingExceptionHandlerTest {
    private DefaultBindingExceptionHandler handler = new DefaultBindingExceptionHandler();
    private TestComponent component = (TestComponent)Mockito.mock(TestComponent.class);
    private Element element = ElementFactory.createAnchor();

    @Before
    public void setUp() {
        Mockito.when((Object)this.component.getElement()).thenReturn((Object)this.element);
    }

    @Test
    public void handleException_elementHasId_messageContainsIdReference() {
        this.element.setProperty("id", "foo");
        Optional result = this.handler.handleException((HasValue)this.component, new Exception());
        String message = ((BindingException)result.get()).getMessage();
        Assert.assertEquals((Object)"An exception has been thrown inside binding logic for the field element [id='foo']", (Object)message);
    }

    @Test
    public void handleException_elementHasLabel_messageContainsLabelReference() {
        this.element.setProperty("label", "foo");
        Optional result = this.handler.handleException((HasValue)this.component, new Exception());
        String message = ((BindingException)result.get()).getMessage();
        Assert.assertEquals((Object)"An exception has been thrown inside binding logic for the field element [label='foo']", (Object)message);
    }

    @Test
    public void handleException_elementHasNoLabelAndId_devMode_messageContainsPropertiesReference() {
        UI ui = this.mockUI(false);
        ui.getElement().appendChild(new Element[]{this.element});
        this.element.setProperty("foo", "bar");
        this.element.setAttribute("baz", "foo-bar");
        Optional result = this.handler.handleException((HasValue)this.component, new Exception());
        String message = ((BindingException)result.get()).getMessage();
        Assert.assertEquals((Object)"An exception has been thrown inside binding logic for the field element [baz='foo-bar', foo='bar']", (Object)message);
    }

    @Test
    public void handleException_elementHasNoLabelAndId_prodcutionMode_returnsEmpty() {
        UI ui = this.mockUI(true);
        ui.getElement().appendChild(new Element[]{this.element});
        this.element.setProperty("foo", "bar");
        this.element.setAttribute("baz", "foo-bar");
        Optional result = this.handler.handleException((HasValue)this.component, new Exception());
        Assert.assertFalse((boolean)result.isPresent());
    }

    private UI mockUI(boolean productionMode) {
        UI ui = new UI();
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        ui.getInternals().setSession(session);
        Mockito.when((Object)session.getService()).thenReturn((Object)service);
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        Mockito.when((Object)service.getContext()).thenReturn((Object)context);
        ApplicationConfiguration configuration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)context.getAttribute((Class)Mockito.eq(ApplicationConfiguration.class), (Supplier)Mockito.any())).thenReturn((Object)configuration);
        Mockito.when((Object)configuration.isProductionMode()).thenReturn((Object)productionMode);
        return ui;
    }

    private abstract class TestComponent
    implements HasElement,
    HasValue {
        private TestComponent() {
        }
    }
}

