/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.converter.Converter;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public class RequiredFieldConfiguratorUtil {
    private RequiredFieldConfiguratorUtil() {
    }

    public static boolean hasZeroSize(Object value) {
        if (value instanceof CharSequence) {
            return ((CharSequence)value).length() == 0;
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value != null && value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return false;
    }

    public static boolean testConvertedDefaultValue(Binder.BindingBuilder<?, ?> binding, Predicate<Object> predicate) {
        if (binding instanceof Binder.BindingBuilderImpl) {
            HasValue<?, ?> field = binding.getField();
            Converter converter = ((Binder.BindingBuilderImpl)binding).getConverterValidatorChain();
            Result<?> result = converter.convertToModel(field.getEmptyValue(), Binder.BindingImpl.createValueContext(field));
            if (!result.isError()) {
                Object convertedEmptyValue = result.getOrThrow(IllegalStateException::new);
                return predicate.test(convertedEmptyValue);
            }
        }
        return false;
    }
}

