/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.gradle;

import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.gradle.GradlePluginAdapter;
import com.vaadin.gradle.VaadinFlowPluginExtension;
import com.vaadin.gradle.VaadinUtilsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/vaadin/gradle/VaadinPrepareFrontendTask;", "Lorg/gradle/api/DefaultTask;", "()V", "vaadinPrepareFrontend", "", "flow-gradle-plugin"})
public class VaadinPrepareFrontendTask
extends DefaultTask {
    public VaadinPrepareFrontendTask() {
        this.setGroup("Vaadin");
        this.setDescription("checks that node and npm tools are installed, copies frontend resources available inside `.jar` dependencies to `node_modules`, and creates or updates `package.json` and `webpack.config.json` files.");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        VaadinFlowPluginExtension extension = VaadinFlowPluginExtension.Companion.get(project);
        TaskContainer taskContainer = this.getProject().getTasks();
        String string = extension.getProcessResourcesTaskName();
        Intrinsics.checkNotNull((Object)string);
        Object[] objectArray = new Object[]{"vaadinPrepareFrontend"};
        taskContainer.getByName(string).mustRunAfter(objectArray);
        objectArray = new Object[1];
        ConfigurationContainer configurationContainer = this.getProject().getConfigurations();
        String string2 = extension.getDependencyScope();
        Intrinsics.checkNotNull((Object)string2);
        Configuration configuration = configurationContainer.getByName(string2);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.g\u2026ension.dependencyScope!!)");
        objectArray[0] = VaadinUtilsKt.getJars(configuration);
        this.dependsOn(objectArray);
    }

    @TaskAction
    public final void vaadinPrepareFrontend() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        VaadinFlowPluginExtension extension = VaadinFlowPluginExtension.Companion.get(project);
        Object[] objectArray = new Object[]{extension.getGeneratedTsFolder().getAbsolutePath()};
        this.getProject().delete(objectArray);
        this.getLogger().info("Running the vaadinPrepareFrontend task with effective configuration " + extension);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        GradlePluginAdapter adapter = new GradlePluginAdapter(project2, true);
        File tokenFile = BuildFrontendUtil.propagateBuildInfo((PluginAdapterBase)((PluginAdapterBase)adapter));
        if (extension.getRequireHomeNodeExec()) {
            FrontendTools tools = VaadinUtilsKt.createFrontendTools(extension);
            tools.forceAlternativeNodeExecutable();
        }
        this.getLogger().info("Generated token file " + tokenFile);
        if (!tokenFile.exists()) {
            boolean bl = false;
            String string = "token file " + tokenFile + " doesn't exist!";
            throw new IllegalStateException(string.toString());
        }
        BuildFrontendUtil.prepareFrontend((PluginAdapterBase)((PluginAdapterBase)adapter));
    }
}

