/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendWebComponentGenerator;
import com.vaadin.flow.server.frontend.TaskCopyFrontendFiles;
import com.vaadin.flow.server.frontend.TaskCopyLocalFrontendFiles;
import com.vaadin.flow.server.frontend.TaskCreatePackageJson;
import com.vaadin.flow.server.frontend.TaskRunNpmInstall;
import com.vaadin.flow.server.frontend.TaskUpdateImports;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.TaskUpdateWebpack;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import elemental.json.JsonObject;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class NodeTasks
implements FallibleCommand {
    private final Collection<FallibleCommand> commands = new ArrayList<FallibleCommand>();

    private NodeTasks(Builder builder) {
        ClassFinder.CachedClassFinder classFinder = null;
        FrontendDependenciesScanner frontendDependencies = null;
        if (builder.enablePackagesUpdate || builder.enableImportsUpdate) {
            classFinder = new ClassFinder.CachedClassFinder(builder.classFinder);
            if (builder.generateEmbeddableWebComponents) {
                FrontendWebComponentGenerator generator = new FrontendWebComponentGenerator(classFinder);
                generator.generateWebComponents(builder.generatedFolder);
            }
            frontendDependencies = new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(!builder.useByteCodeScanner, classFinder, builder.generateEmbeddableWebComponents);
        }
        if (builder.createMissingPackageJson) {
            TaskCreatePackageJson packageCreator = new TaskCreatePackageJson(builder.npmFolder, builder.generatedFolder);
            this.commands.add(packageCreator);
        }
        if (builder.enablePackagesUpdate) {
            TaskUpdatePackages packageUpdater = new TaskUpdatePackages(classFinder, frontendDependencies, builder.npmFolder, builder.generatedFolder, builder.cleanNpmFiles);
            this.commands.add(packageUpdater);
            if (builder.runNpmInstall) {
                this.commands.add(new TaskRunNpmInstall(packageUpdater));
            }
        }
        if (builder.copyResources) {
            this.commands.add(new TaskCopyFrontendFiles(builder.npmFolder, builder.jarFiles));
        }
        if (builder.frontendResourcesDirectory != null) {
            this.commands.add(new TaskCopyLocalFrontendFiles(builder.npmFolder, builder.frontendResourcesDirectory));
        }
        if (builder.webpackTemplate != null && !builder.webpackTemplate.isEmpty()) {
            this.commands.add(new TaskUpdateWebpack(builder.frontendDirectory, builder.npmFolder, builder.webpackOutputDirectory, builder.webpackTemplate, builder.webpackGeneratedTemplate, new File(builder.generatedFolder, "generated-flow-imports.js")));
        }
        if (builder.enableImportsUpdate) {
            this.commands.add(new TaskUpdateImports(classFinder, frontendDependencies, finder -> this.getFallbackScanner(builder, (ClassFinder)finder), builder.npmFolder, builder.generatedFolder, builder.frontendDirectory, builder.tokenFile, builder.tokenFileData));
        }
    }

    private FrontendDependenciesScanner getFallbackScanner(Builder builder, ClassFinder finder) {
        if (builder.useByteCodeScanner) {
            return new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(true, finder, builder.generateEmbeddableWebComponents);
        }
        return null;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        for (FallibleCommand command : this.commands) {
            command.execute();
        }
    }

    public static class Builder
    implements Serializable {
        private final ClassFinder classFinder;
        private final File frontendDirectory;
        private File webpackOutputDirectory = null;
        private String webpackTemplate = null;
        private String webpackGeneratedTemplate = null;
        private boolean enablePackagesUpdate = false;
        private boolean createMissingPackageJson = false;
        private boolean enableImportsUpdate = false;
        private boolean runNpmInstall = false;
        private Set<File> jarFiles = null;
        private boolean copyResources = false;
        private boolean generateEmbeddableWebComponents = true;
        private boolean cleanNpmFiles = false;
        private File frontendResourcesDirectory = null;
        private boolean useByteCodeScanner = false;
        private JsonObject tokenFileData;
        private File tokenFile;
        public final File npmFolder;
        public final File generatedFolder;

        public Builder(ClassFinder classFinder, File npmFolder) {
            this(classFinder, npmFolder, new File(npmFolder, System.getProperty("vaadin.frontend.generated.folder", "target/frontend/")));
        }

        public Builder(ClassFinder classFinder, File npmFolder, File generatedPath) {
            this(classFinder, npmFolder, generatedPath, new File(npmFolder, System.getProperty("vaadin.frontend.frontend.folder", "./frontend/")));
        }

        public Builder(ClassFinder classFinder, File npmFolder, File generatedPath, File frontendDirectory) {
            this.classFinder = classFinder;
            this.npmFolder = npmFolder;
            this.generatedFolder = generatedPath.isAbsolute() ? generatedPath : new File(npmFolder, generatedPath.getPath());
            this.frontendDirectory = frontendDirectory.isAbsolute() ? frontendDirectory : new File(npmFolder, frontendDirectory.getPath());
        }

        public NodeTasks build() {
            return new NodeTasks(this);
        }

        public Builder withWebpack(File webpackOutputDirectory, String webpackTemplate, String webpackGeneratedTemplate) {
            this.webpackOutputDirectory = webpackOutputDirectory;
            this.webpackTemplate = webpackTemplate;
            this.webpackGeneratedTemplate = webpackGeneratedTemplate;
            return this;
        }

        public Builder enablePackagesUpdate(boolean enablePackagesUpdate) {
            this.enablePackagesUpdate = enablePackagesUpdate;
            return this;
        }

        public Builder enableNpmFileCleaning(boolean forceClean) {
            this.cleanNpmFiles = forceClean;
            return this;
        }

        public Builder enableImportsUpdate(boolean enableImportsUpdate) {
            this.enableImportsUpdate = enableImportsUpdate;
            this.createMissingPackageJson = enableImportsUpdate || this.createMissingPackageJson;
            return this;
        }

        public Builder runNpmInstall(boolean runNpmInstall) {
            this.runNpmInstall = runNpmInstall;
            return this;
        }

        public Builder copyResources(Set<File> jars) {
            Objects.requireNonNull(jars, "Parameter 'jars' must not be null!");
            this.jarFiles = jars;
            this.copyResources = true;
            return this;
        }

        public Builder withEmbeddableWebComponents(boolean generateEmbeddableWebComponents) {
            this.generateEmbeddableWebComponents = generateEmbeddableWebComponents;
            return this;
        }

        public Builder createMissingPackageJson(boolean create) {
            this.createMissingPackageJson = create;
            return this;
        }

        public Builder copyLocalResources(File frontendResourcesDirectory) {
            this.frontendResourcesDirectory = frontendResourcesDirectory;
            return this;
        }

        public Builder useByteCodeScanner(boolean byteCodeScanner) {
            this.useByteCodeScanner = byteCodeScanner;
            return this;
        }

        public Builder populateTokenFileData(JsonObject object) {
            this.tokenFileData = object;
            return this;
        }

        public Builder withTokenFile(File tokenFile) {
            this.tokenFile = tokenFile;
            return this;
        }
    }
}

