/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaskUpdatePackages
extends NodeUpdater {
    static final String APP_PACKAGE_HASH = "vaadinAppPackageHash";
    private static final String VERSION = "version";
    private static final String SHRINK_WRAP = "@vaadin/vaadin-shrinkwrap";
    private boolean forceCleanUp;

    TaskUpdatePackages(ClassFinder finder, FrontendDependenciesScanner frontendDependencies, File npmFolder, File generatedPath, boolean forceCleanUp) {
        super(finder, frontendDependencies, npmFolder, generatedPath);
        this.forceCleanUp = forceCleanUp;
    }

    @Override
    public void execute() {
        try {
            boolean isModified;
            Map<String, String> deps = this.frontDeps.getPackages();
            JsonObject packageJson = this.getAppPackageJson();
            if (packageJson == null) {
                packageJson = Json.createObject();
            }
            if (isModified = this.updatePackageJsonDependencies(packageJson, deps)) {
                this.writeAppPackageFile(packageJson);
            }
            this.modified = this.checkPackageHash(packageJson);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean checkPackageHash(JsonObject packageJson) throws IOException {
        String content = "";
        if (packageJson.hasKey("dependencies")) {
            JsonObject dependencies = packageJson.getObject("dependencies");
            content = Stream.of(dependencies.keys()).map(key -> String.format("\"%s\": \"%s\"", key, dependencies.get(key).asString())).sorted(String::compareToIgnoreCase).collect(Collectors.joining(",\n  "));
        }
        return this.updateAppPackageHash(this.getHash(content));
    }

    private boolean updatePackageJsonDependencies(JsonObject packageJson, Map<String, String> deps) throws IOException {
        boolean added = false;
        for (Map.Entry<String, String> dep : deps.entrySet()) {
            added = this.addDependency(packageJson, "dependencies", dep.getKey(), dep.getValue()) || added;
        }
        JsonObject dependencies = packageJson.getObject("dependencies");
        boolean doCleanUp = this.forceCleanUp;
        if (dependencies != null) {
            for (String key : dependencies.keys()) {
                if (deps.containsKey(key)) continue;
                dependencies.remove(key);
            }
            boolean bl = doCleanUp = doCleanUp || !this.ensureReleaseVersion(dependencies);
        }
        if (doCleanUp) {
            this.cleanUp();
        }
        return added;
    }

    private boolean ensureReleaseVersion(JsonObject dependencies) throws IOException {
        String shrinkWrapVersion = null;
        if (dependencies.hasKey(SHRINK_WRAP)) {
            shrinkWrapVersion = dependencies.getString(SHRINK_WRAP);
        }
        return Objects.equals(shrinkWrapVersion, this.getCurrentShrinkWrapVersion());
    }

    private void cleanUp() throws IOException {
        File generatedNodeModules;
        File packageLock = this.getPackageLock();
        if (packageLock.exists() && !packageLock.delete()) {
            throw new IOException("Could not remove " + packageLock.getPath() + " file. This file has been generated with a different platform version. Try to remove it manually.");
        }
        if (this.nodeModulesFolder.exists()) {
            this.removeDir(this.nodeModulesFolder);
        }
        if ((generatedNodeModules = new File(this.generatedFolder, "node_modules/")).exists()) {
            this.removeDir(generatedNodeModules);
        }
    }

    private void removeDir(File file) throws IOException {
        Files.walkFileTree(file.toPath(), new RemoveFileVisitor());
    }

    private String getCurrentShrinkWrapVersion() throws IOException {
        String shrinkWrapVersion = this.getShrinkWrapVersion(this.getMainPackageJson());
        if (shrinkWrapVersion != null) {
            return shrinkWrapVersion;
        }
        shrinkWrapVersion = this.getShrinkWrapVersion(this.getAppPackageJson());
        if (shrinkWrapVersion != null) {
            return shrinkWrapVersion;
        }
        File flowDeps = new File(this.nodeModulesFolder, "@vaadin/flow-deps");
        shrinkWrapVersion = this.getShrinkWrapVersion(this.getPackageJson(new File(flowDeps, "package.json")));
        if (shrinkWrapVersion != null) {
            return shrinkWrapVersion;
        }
        shrinkWrapVersion = this.getPackageLockShrinkWrapVersion();
        return shrinkWrapVersion;
    }

    private String getPackageLockShrinkWrapVersion() throws IOException {
        File packageLock = this.getPackageLock();
        if (!packageLock.exists()) {
            return null;
        }
        JsonObject packageLockJson = this.getPackageJson(packageLock);
        if (packageLockJson == null) {
            return null;
        }
        if (!packageLockJson.hasKey("dependencies")) {
            return null;
        }
        JsonObject dependencies = packageLockJson.getObject("dependencies");
        if (!dependencies.hasKey(SHRINK_WRAP)) {
            return null;
        }
        JsonObject shrinkWrap = dependencies.getObject(SHRINK_WRAP);
        if (shrinkWrap.hasKey(VERSION)) {
            return shrinkWrap.get(VERSION).asString();
        }
        return null;
    }

    private File getPackageLock() {
        return new File(this.npmFolder, "package-lock.json");
    }

    private String getShrinkWrapVersion(JsonObject packageJson) throws IOException {
        JsonObject dependencies;
        if (packageJson == null) {
            return null;
        }
        if (packageJson.hasKey("dependencies") && (dependencies = packageJson.getObject("dependencies")).hasKey(SHRINK_WRAP)) {
            JsonValue value = dependencies.get(SHRINK_WRAP);
            return value.asString();
        }
        return null;
    }

    private String getHash(String content) {
        if (content.isEmpty()) {
            return content;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return this.bytesToHex(digest.digest(content.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to find a provider for SHA-256 algorithm", e);
        }
    }

    private boolean updateAppPackageHash(String hash) throws IOException {
        boolean modified;
        JsonObject mainContent = this.getMainPackageJson();
        if (mainContent == null) {
            mainContent = Json.createObject();
        }
        boolean bl = modified = !mainContent.hasKey(APP_PACKAGE_HASH) || !hash.equals(mainContent.getString(APP_PACKAGE_HASH));
        if (modified) {
            mainContent.put(APP_PACKAGE_HASH, hash);
            this.writeMainPackageFile(mainContent);
        }
        return modified;
    }

    private String bytesToHex(byte[] hash) {
        StringBuilder result = new StringBuilder();
        for (byte bit : hash) {
            String hex = Integer.toHexString(0xFF & bit);
            if (hex.length() == 1) {
                result.append('0');
            }
            result.append(hex);
        }
        return result.toString();
    }

    private static class RemoveFileVisitor
    extends SimpleFileVisitor<Path>
    implements Serializable {
        private RemoveFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return super.visitFile(file, attrs);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return super.postVisitDirectory(dir, exc);
        }
    }
}

