/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.ParserProcessor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIUtil.class);

    public static String getCurrentOpenAPI(Path buildDirectory, boolean isProductionMode) throws IOException {
        Optional<Path> openAPIPath = OpenAPIUtil.getCurrentOpenAPIPath(buildDirectory, isProductionMode);
        if (openAPIPath.isEmpty()) {
            LOGGER.debug("Trying to read the non-existing OpenApi json file. Empty string is returned.");
            return "";
        }
        return Files.readString(openAPIPath.get());
    }

    public static Optional<Path> getCurrentOpenAPIPath(Path buildDirectory, boolean isProductionMode) throws IOException {
        EngineConfiguration engineConfiguration = EngineConfiguration.loadDirectory((Path)buildDirectory);
        if (engineConfiguration == null) {
            return Optional.empty();
        }
        return Optional.of(engineConfiguration.getOpenAPIFile(isProductionMode));
    }

    public static String generateOpenAPI(Path buildDirectory, boolean isProductionMode) throws IOException {
        EngineConfiguration engineConfiguration = EngineConfiguration.loadDirectory((Path)buildDirectory);
        ParserProcessor parserProcessor = new ParserProcessor(engineConfiguration, OpenAPIUtil.class.getClassLoader(), isProductionMode);
        return parserProcessor.createOpenAPI();
    }

    public static Set<String> findOpenApiClasses(String openApiAsText) throws IOException {
        ObjectNode schemas;
        ArrayNode tags;
        JsonNode openApi = new ObjectMapper().readTree(openApiAsText);
        HashSet<String> types = new HashSet<String>();
        if (openApi.has("tags") && (tags = (ArrayNode)openApi.get("tags")) != null) {
            tags.forEach(nameAndClass -> types.add(nameAndClass.get("x-class-name").asText()));
        }
        if (openApi.has("components") && (schemas = (ObjectNode)openApi.get("components").get("schemas")) != null) {
            schemas.fieldNames().forEachRemaining(type -> types.add((String)type));
        }
        return types;
    }
}

