/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.internal.hotswap;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.hilla.internal.hotswap.EndpointHotSwapService;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HotSwapServiceInitializer
implements VaadinServiceInitListener {
    private final Logger LOGGER;
    boolean endpointHotReloadEnabled;
    private final EndpointHotSwapService endpointHotSwapService;

    public HotSwapServiceInitializer(EndpointHotSwapService endpointHotSwapService, boolean endpointHotReloadEnabled) {
        this.endpointHotSwapService = endpointHotSwapService;
        this.endpointHotReloadEnabled = endpointHotReloadEnabled;
        this.LOGGER = LoggerFactory.getLogger(this.getClass());
    }

    public void serviceInit(ServiceInitEvent serviceInitEvent) {
        VaadinService vaadinService = serviceInitEvent.getSource();
        BrowserLiveReloadAccessor.getLiveReloadFromService((VaadinService)vaadinService).ifPresent(browserLiveReload -> {
            if (browserLiveReload.getBackend() != null && BrowserLiveReload.Backend.SPRING_BOOT_DEVTOOLS != browserLiveReload.getBackend() && this.isDevModeLiveReloadEnabled(vaadinService)) {
                if (this.isEndpointHotReloadEnabled()) {
                    this.endpointHotSwapService.monitorChanges(this.getBuildDir(vaadinService), (BrowserLiveReload)browserLiveReload);
                    this.info("Hilla Endpoint Hot-Reload service is enabled. You can disable it by defining the hilla.endpoint.hot-reload.enabled=false property in application.properties file.");
                    this.info("The default polling interval for Hilla Endpoint Hot-Reload is 5 seconds. You can change the interval by defining a positive value for the hilla.endpoint.hot-reload.pollInterval property in application.properties file.");
                } else {
                    this.info("Hilla Endpoint Hot-Reload service is disabled. You can enable it by adding the hilla.endpoint.hot-reload.enabled=true property to your application.properties file, or by setting its value to true.");
                }
            }
        });
    }

    private boolean isDevModeLiveReloadEnabled(VaadinService vaadinService) {
        return vaadinService.getDeploymentConfiguration().isDevModeLiveReloadEnabled();
    }

    private Path getBuildDir(VaadinService vaadinService) {
        DeploymentConfiguration deploymentConfig = vaadinService.getDeploymentConfiguration();
        Path projectFolder = deploymentConfig.getProjectFolder().toPath();
        return projectFolder.resolve(deploymentConfig.getBuildFolder());
    }

    private boolean isEndpointHotReloadEnabled() {
        return this.endpointHotReloadEnabled;
    }

    private void info(String message) {
        this.LOGGER.info(message);
    }
}

