/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.route;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.internal.ClientRoutesProvider;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.hilla.route.records.ClientViewConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

@Component
public class ClientRouteRegistry
implements ClientRoutesProvider {
    public static final String FILE_ROUTES_JSON_NAME = "file-routes.json";
    public static final String FILE_ROUTES_JSON_PROD_PATH = "/META-INF/VAADIN/file-routes.json";
    private final Map<String, ClientViewConfig> registeredRoutes = new LinkedHashMap<String, ClientViewConfig>();
    private final ObjectMapper mapper = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientRouteRegistry.class);
    private volatile LocalDateTime lastUpdated;
    private volatile boolean hasMainLayout;

    public synchronized Map<String, ClientViewConfig> getAllRoutes() {
        return Map.copyOf(this.registeredRoutes);
    }

    synchronized void clearRoutes() {
        this.hasMainLayout = false;
        this.registeredRoutes.clear();
    }

    synchronized void addRoute(String route, ClientViewConfig clientView) {
        if (this.registeredRoutes.containsKey(route)) {
            throw new IllegalStateException("An attempt to register a route that is already registered. Route: " + route + " View: " + clientView.getRoute());
        }
        this.registeredRoutes.put(route, clientView);
    }

    public synchronized ClientViewConfig getRouteByPath(String path) {
        Set<String> routes = this.registeredRoutes.keySet();
        AntPathMatcher pathMatcher = new AntPathMatcher();
        return Stream.of(this.addTrailingSlash(path), this.removeTrailingSlash(path)).map(p -> {
            for (String route : routes) {
                if (!pathMatcher.match(route, p)) continue;
                return this.registeredRoutes.get(route);
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private String addTrailingSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    private String removeTrailingSlash(String path) {
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }

    public synchronized void registerClientRoutes(DeploymentConfiguration deploymentConfiguration, LocalDateTime lastUpdated) {
        URL fileRoutesJsonAsResource = this.getFileRoutesJsonAsResource(deploymentConfiguration);
        if (fileRoutesJsonAsResource == null) {
            LOGGER.debug("No {} found under {} directory. Skipping client route registration.", (Object)FILE_ROUTES_JSON_NAME, (Object)(deploymentConfiguration.isProductionMode() ? "'META-INF/VAADIN'" : "'frontend/generated'"));
            return;
        }
        try (InputStream source = fileRoutesJsonAsResource.openStream();){
            if (source != null) {
                this.clearRoutes();
                ((List)this.mapper.readValue(source, (TypeReference)new TypeReference<List<ClientViewConfig>>(){})).forEach(route -> this.registerAndRecurseChildren("", (ClientViewConfig)route));
                this.lastUpdated = lastUpdated;
            }
        }
        catch (IOException e) {
            if (deploymentConfiguration.isProductionMode()) {
                LOGGER.error("Failed to load {} from {}", new Object[]{FILE_ROUTES_JSON_NAME, fileRoutesJsonAsResource.getPath(), e});
            }
            LOGGER.debug("Failed to load {} from {}. Skipping client route registration. There might be a problem with the contents of the file-routes.json file.", (Object)FILE_ROUTES_JSON_NAME, (Object)"'frontend/generated'");
        }
    }

    public synchronized void loadLatestDevModeFileRoutesJsonIfNeeded(DeploymentConfiguration deploymentConfiguration) {
        File devModeFileRoutesJsonFile = deploymentConfiguration.getFrontendFolder().toPath().resolve("generated").resolve(FILE_ROUTES_JSON_NAME).toFile();
        if (!devModeFileRoutesJsonFile.exists()) {
            LOGGER.debug("No file-routes.json found under {}", (Object)deploymentConfiguration.getFrontendFolder().toPath().resolve("generated"));
            return;
        }
        long lastModified = devModeFileRoutesJsonFile.lastModified();
        LocalDateTime lastModifiedTime = Instant.ofEpochMilli(lastModified).atZone(ZoneId.systemDefault()).toLocalDateTime();
        if (this.lastUpdated == null || lastModifiedTime.isAfter(this.lastUpdated)) {
            LOGGER.debug("Loading latest file-routes.json from dev mode");
            this.registerClientRoutes(deploymentConfiguration, lastModifiedTime);
        }
    }

    private URL getFileRoutesJsonAsResource(DeploymentConfiguration deploymentConfiguration) {
        boolean isProductionMode = deploymentConfiguration.isProductionMode();
        if (isProductionMode) {
            return this.getClass().getResource(FILE_ROUTES_JSON_PROD_PATH);
        }
        try {
            File fileRoutesJson = FrontendUtils.getFrontendGeneratedFolder((File)deploymentConfiguration.getFrontendFolder()).toPath().resolve(FILE_ROUTES_JSON_NAME).toFile();
            if (!fileRoutesJson.exists()) {
                return null;
            }
            return fileRoutesJson.toURI().toURL();
        }
        catch (MalformedURLException e) {
            LOGGER.error("Unexpected error while getting {} as resource from 'frontend/generated'.", (Object)FILE_ROUTES_JSON_NAME, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void registerAndRecurseChildren(String basePath, ClientViewConfig view) {
        String path;
        String string = path = view.getRoute() == null || view.getRoute().isEmpty() ? basePath : basePath + "/" + view.getRoute();
        if (!this.hasMainLayout && this.isMainLayout(view)) {
            this.hasMainLayout = true;
        }
        if (view.getChildren() == null) {
            this.addRoute(path, view);
        } else {
            view.getChildren().forEach(child -> {
                child.setParent(view);
                this.registerAndRecurseChildren(path, (ClientViewConfig)child);
            });
        }
    }

    private boolean isMainLayout(ClientViewConfig view) {
        return (view.getRoute() == null || view.getRoute().isBlank()) && view.getChildren() != null && view.getParent() == null;
    }

    public synchronized boolean hasMainLayout() {
        return this.hasMainLayout;
    }

    public synchronized List<String> getClientRoutes() {
        return this.getAllRoutes().keySet().stream().toList();
    }
}

