/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.models;

import com.vaadin.hilla.parser.models.AnnotationInfoModel;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.FieldInfoModel;
import com.vaadin.hilla.parser.models.ReflectionModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;

final class FieldInfoReflectionModel
extends FieldInfoModel
implements ReflectionModel {
    private final Field origin;

    FieldInfoReflectionModel(Field origin) {
        this.origin = origin;
    }

    @Override
    public Field get() {
        return this.origin;
    }

    @Override
    public String getClassName() {
        return this.origin.getDeclaringClass().getName();
    }

    @Override
    public String getName() {
        return this.origin.getName();
    }

    @Override
    public boolean isEnum() {
        return this.origin.isEnumConstant();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.origin.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.origin.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.origin.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.origin.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.origin.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        return this.origin.isSynthetic();
    }

    @Override
    public boolean isTransient() {
        return Modifier.isTransient(this.origin.getModifiers());
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return FieldInfoReflectionModel.processAnnotations(this.origin.getAnnotations());
    }

    @Override
    protected ClassInfoModel prepareOwner() {
        return ClassInfoModel.of(this.origin.getDeclaringClass());
    }

    @Override
    protected SignatureModel prepareType() {
        return SignatureModel.of(this.origin.getAnnotatedType());
    }
}

