/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter;

import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.vaadin.flow.spring.SpringBootAutoConfiguration;
import com.vaadin.kubernetes.starter.KubernetesKitProperties;
import com.vaadin.kubernetes.starter.SerializationProperties;
import com.vaadin.kubernetes.starter.sessiontracker.SessionListener;
import com.vaadin.kubernetes.starter.sessiontracker.SessionSerializer;
import com.vaadin.kubernetes.starter.sessiontracker.SessionTrackerFilter;
import com.vaadin.kubernetes.starter.sessiontracker.backend.BackendConnector;
import com.vaadin.kubernetes.starter.sessiontracker.backend.HazelcastConnector;
import com.vaadin.kubernetes.starter.sessiontracker.backend.RedisConnector;
import com.vaadin.kubernetes.starter.sessiontracker.push.PushSendListener;
import com.vaadin.kubernetes.starter.sessiontracker.push.PushSessionTracker;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.SpringTransientHandler;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientHandler;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.DebugMode;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.SerializationDebugRequestHandler;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import java.util.EventListener;
import java.util.function.Predicate;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnProperty(name={"auto-configure"}, prefix="vaadin.kubernetes", matchIfMissing=true)
@AutoConfigureAfter(value={SpringBootAutoConfiguration.class, RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={KubernetesKitProperties.class, SerializationProperties.class})
public class KubernetesKitConfiguration {

    @AutoConfiguration
    @ConditionalOnClass(value={HazelcastInstance.class})
    public static class HazelcastConfiguration {
        final KubernetesKitProperties properties;

        public HazelcastConfiguration(KubernetesKitProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean
        HazelcastConnector hazelcastConnector(HazelcastInstance hazelcastInstance) {
            return new HazelcastConnector(hazelcastInstance);
        }

        @Bean
        @ConditionalOnMissingBean
        public HazelcastInstance hazelcastInstance() {
            Config config = new Config();
            this.configure(config);
            this.configureKubernetes(config);
            return this.createHazelcastInstance(config);
        }

        HazelcastInstance createHazelcastInstance(Config config) {
            return Hazelcast.newHazelcastInstance((Config)config);
        }

        protected void configure(Config config) {
        }

        private void configureKubernetes(Config config) {
            KubernetesKitProperties.HazelcastProperties k8sProperties = this.properties.getHazelcast();
            String k8sServiceName = k8sProperties.getServiceName();
            if (StringUtils.hasText((String)k8sServiceName)) {
                JoinConfig networkConfig = config.getNetworkConfig().getJoin();
                networkConfig.getTcpIpConfig().setEnabled(false);
                networkConfig.getMulticastConfig().setEnabled(false);
                KubernetesConfig k8sConfig = networkConfig.getKubernetesConfig();
                k8sConfig.setEnabled(true);
                String k8sNamespace = k8sProperties.getNamespace();
                k8sConfig.setProperty("namespace", k8sNamespace);
                k8sConfig.setProperty("service-name", k8sServiceName);
                k8sConfig.setProperty("service-port", Integer.toString(k8sProperties.getServicePort()));
            }
        }
    }

    @AutoConfiguration
    @ConditionalOnClass(value={RedisConnectionFactory.class})
    public static class RedisConfiguration {
        @Bean
        @ConditionalOnBean(value={RedisConnectionFactory.class})
        @ConditionalOnMissingBean
        RedisConnector redisConnector(RedisConnectionFactory factory) {
            return new RedisConnector(factory);
        }
    }

    @AutoConfiguration
    @Conditional(value={OnSessionSerializationDebug.class})
    public static class VaadinReplicatedSessionDevModeConfiguration {
        @Bean
        @ConditionalOnMissingBean
        SerializationDebugRequestHandler.InitListener sessionSerializationDebugToolInstaller() {
            return new SerializationDebugRequestHandler.InitListener();
        }

        @Bean
        @Order(value=-2147483648)
        FilterRegistrationBean<SerializationDebugRequestHandler.Filter> sessionSerializationDebugToolFilter() {
            return new FilterRegistrationBean((Filter)new SerializationDebugRequestHandler.Filter(), new ServletRegistrationBean[0]);
        }

        private static class OnSessionSerializationDebug
        extends AllNestedConditions {
            public OnSessionSerializationDebug() {
                super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
            }

            @Conditional(value={SerializationTrackingCondition.class})
            private static class SerializationTrackingCondition
            implements Condition {
                private SerializationTrackingCondition() {
                }

                public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
                    return DebugMode.isTrackingAvailable(LoggerFactory.getLogger(VaadinReplicatedSessionDevModeConfiguration.class));
                }
            }

            @ConditionalOnProperty(prefix="vaadin", name={"devmode.sessionSerialization.enabled"})
            static class OnSessionSerialization {
                OnSessionSerialization() {
                }
            }

            @ConditionalOnProperty(prefix="vaadin", name={"productionMode"}, havingValue="false", matchIfMissing=true)
            static class OnDevelopmentMode {
                OnDevelopmentMode() {
                }
            }
        }
    }

    @AutoConfiguration
    @ConditionalOnBean(value={BackendConnector.class})
    public static class VaadinReplicatedSessionConfiguration {
        public static final String TRANSIENT_INJECTABLE_FILTER = "vaadinSerializationTransientInjectableFilter";
        private static final Predicate<Class<?>> TRANSIENT_INJECTABLE_VAADIN_EXCLUSIONS = type -> !type.getPackageName().startsWith("com.vaadin.flow.internal");

        SessionTrackerFilter sessionTrackerFilter(SessionSerializer sessionSerializer) {
            return new SessionTrackerFilter(sessionSerializer);
        }

        SessionListener sessionListener(BackendConnector backendConnector, SessionSerializer sessionSerializer) {
            return new SessionListener(backendConnector, sessionSerializer);
        }

        @Bean
        SpringTransientHandler springDeserializationHandler(ApplicationContext appCtx) {
            return new SpringTransientHandler(appCtx);
        }

        @Bean(value={"vaadinSerializationTransientInjectableFilter"})
        @ConditionalOnMissingBean
        Predicate<Class<?>> transientInjectableFilter(SerializationProperties props) {
            return props.getTransients().transientInjectableFilter();
        }

        @Bean
        SessionSerializer sessionSerializer(BackendConnector backendConnector, TransientHandler transientInjector, @Autowired(required=false) @Qualifier(value="vaadinSerializationTransientInjectableFilter") Predicate<Class<?>> injectablesFilter) {
            SessionSerializer sessionSerializer = new SessionSerializer(backendConnector, transientInjector);
            if (injectablesFilter != null) {
                sessionSerializer.setInjectableFilter(injectablesFilter);
            }
            return sessionSerializer;
        }

        public static Predicate<Class<?>> withVaadinDefaultFilter(Predicate<Class<?>> injectablesFilter) {
            Predicate<Class<?>> filter = TRANSIENT_INJECTABLE_VAADIN_EXCLUSIONS;
            if (injectablesFilter != null) {
                filter = filter.and(injectablesFilter);
            }
            return filter;
        }

        @Bean
        @Order(value=-2147483598)
        FilterRegistrationBean<SessionTrackerFilter> sessionTrackerFilterRegistration(final BackendConnector backendConnector, final SessionSerializer sessionSerializer) {
            return new FilterRegistrationBean<SessionTrackerFilter>(this.sessionTrackerFilter(sessionSerializer), new ServletRegistrationBean[0]){

                protected FilterRegistration.Dynamic addRegistration(String description, ServletContext servletContext) {
                    servletContext.addListener((EventListener)((Object)this.sessionListener(backendConnector, sessionSerializer)));
                    return super.addRegistration(description, servletContext);
                }
            };
        }

        @Bean
        PushSendListener pushSendListener(SessionSerializer sessionSerializer) {
            return new PushSessionTracker(sessionSerializer);
        }
    }
}

