/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker;

import com.vaadin.kubernetes.starter.sessiontracker.CurrentKey;
import com.vaadin.kubernetes.starter.sessiontracker.SessionSerializer;
import com.vaadin.kubernetes.starter.sessiontracker.SessionTrackerCookie;
import com.vaadin.kubernetes.starter.sessiontracker.backend.BackendConnector;
import com.vaadin.kubernetes.starter.sessiontracker.backend.SessionInfo;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionListener
implements HttpSessionListener {
    private final BackendConnector sessionBackendConnector;
    private final SessionSerializer sessionSerializer;

    public SessionListener(BackendConnector sessionBackendConnector, SessionSerializer sessionSerializer) {
        this.sessionBackendConnector = sessionBackendConnector;
        this.sessionSerializer = sessionSerializer;
    }

    public void sessionCreated(HttpSessionEvent se) {
        SessionInfo sessionInfo;
        HttpSession session = se.getSession();
        SessionListener.getLogger().debug("Session with id {} created", (Object)session.getId());
        String clusterKey = CurrentKey.get();
        if (clusterKey != null && (sessionInfo = this.sessionBackendConnector.getSession(clusterKey)) != null) {
            SessionListener.getLogger().debug("Found session {} on distributed storage", (Object)clusterKey);
            try {
                this.sessionSerializer.deserialize(sessionInfo, session);
                SessionListener.getLogger().debug("HTTP session {} populated with data from {} key of distributed storage", (Object)session.getId(), (Object)clusterKey);
            }
            catch (Exception e) {
                SessionListener.getLogger().error("Unable to deserialize data with key {} from distributed storage into session {}", new Object[]{clusterKey, session.getId(), e});
            }
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        String sessionId = session.getId();
        SessionListener.getLogger().debug("Session with id {} destroyed", (Object)sessionId);
        SessionTrackerCookie.getFromSession(session).ifPresent(clusterKey -> {
            SessionListener.getLogger().debug("Deleting data with key {} from distributed storage associated to session {}", clusterKey, (Object)sessionId);
            try {
                this.sessionBackendConnector.deleteSession((String)clusterKey);
                SessionListener.getLogger().debug("Deleted data with key {} from distributed storage associated to session {}", clusterKey, (Object)sessionId);
            }
            catch (Exception e) {
                SessionListener.getLogger().error("Unable to delete data with key {} from distributed storage associated to session {}", new Object[]{clusterKey, sessionId, e});
            }
        });
    }

    static Logger getLogger() {
        return LoggerFactory.getLogger(SessionListener.class);
    }
}

