/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public final class SessionTrackerCookie {
    private SessionTrackerCookie() {
    }

    public static void setIfNeeded(HttpSession session, HttpServletRequest request, HttpServletResponse response) {
        Optional<Cookie> clusterKeyCookie = SessionTrackerCookie.getCookie(request);
        if (!clusterKeyCookie.isPresent()) {
            String clusterKey = UUID.randomUUID().toString();
            session.setAttribute("clusterKey", (Object)clusterKey);
            response.addCookie(new Cookie("clusterKey", clusterKey));
        } else if (session.getAttribute("clusterKey") == null) {
            String clusterKey = clusterKeyCookie.get().getValue();
            session.setAttribute("clusterKey", (Object)clusterKey);
        }
    }

    public static Optional<String> getFromSession(HttpSession session) {
        return Optional.ofNullable((String)session.getAttribute("clusterKey"));
    }

    private static Optional<Cookie> getCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return Optional.empty();
        }
        return Stream.of(cookies).filter(c -> c.getName().equals("clusterKey")).findFirst();
    }

    public static Optional<String> getValue(HttpServletRequest request) {
        return SessionTrackerCookie.getCookie(request).map(Cookie::getValue);
    }
}

