/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker;

import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.kubernetes.starter.sessiontracker.CurrentKey;
import com.vaadin.kubernetes.starter.sessiontracker.SessionSerializer;
import com.vaadin.kubernetes.starter.sessiontracker.SessionTrackerCookie;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTrackerFilter
extends HttpFilter {
    private final transient SessionSerializer sessionSerializer;

    public SessionTrackerFilter(SessionSerializer sessionSerializer) {
        this.sessionSerializer = sessionSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        SessionTrackerCookie.getValue(request).ifPresent(key -> {
            CurrentKey.set(key);
            if (request.getSession(false) == null) {
                this.getLogger().info("Creating session for cluster key {}", key);
                request.getSession(true);
            }
        });
        try {
            HttpSession session = request.getSession(false);
            if (session != null) {
                SessionTrackerCookie.setIfNeeded(session, request, response);
            }
            super.doFilter(request, response, chain);
            if (session != null && request.isRequestedSessionIdValid() && HandlerHelper.RequestType.UIDL.getIdentifier().equals(request.getParameter("v-r"))) {
                this.sessionSerializer.serialize(session);
            }
        }
        finally {
            CurrentKey.clear();
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }
}

