/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.backend;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.vaadin.kubernetes.starter.ProductUtils;
import com.vaadin.kubernetes.starter.sessiontracker.backend.BackendConnector;
import com.vaadin.kubernetes.starter.sessiontracker.backend.SessionInfo;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastConnector
implements BackendConnector {
    private final IMap<String, byte[]> sessions;

    public HazelcastConnector(HazelcastInstance hazelcastInstance) {
        this.sessions = hazelcastInstance.getMap("vaadin:sessions");
    }

    @Override
    public void sendSession(SessionInfo sessionInfo) {
        HazelcastConnector.getLogger().debug("Sending session {} to Hazelcast", (Object)sessionInfo.getClusterKey());
        String mapKey = HazelcastConnector.getKey(sessionInfo.getClusterKey());
        this.sessions.put((Object)mapKey, (Object)sessionInfo.getData());
        HazelcastConnector.getLogger().debug("Session {} sent to Hazelcast", (Object)sessionInfo.getClusterKey());
    }

    @Override
    public SessionInfo getSession(String clusterKey) {
        HazelcastConnector.getLogger().debug("Requesting session for {}", (Object)clusterKey);
        this.waitForSerializationCompletion(clusterKey, "getting session");
        byte[] data = (byte[])this.sessions.get((Object)HazelcastConnector.getKey(clusterKey));
        if (data == null) {
            HazelcastConnector.getLogger().debug("Session not found {}", (Object)clusterKey);
            return null;
        }
        SessionInfo sessionInfo = new SessionInfo(clusterKey, data);
        HazelcastConnector.getLogger().debug("Received {}", (Object)sessionInfo);
        return sessionInfo;
    }

    @Override
    public void markSerializationStarted(String clusterKey) {
        HazelcastConnector.getLogger().debug("Marking serialization started for {}", (Object)clusterKey);
        this.sessions.lock((Object)HazelcastConnector.getPendingKey(clusterKey));
    }

    @Override
    public void markSerializationComplete(String clusterKey) {
        HazelcastConnector.getLogger().debug("Marking serialization complete for {}", (Object)clusterKey);
        this.sessions.forceUnlock((Object)HazelcastConnector.getPendingKey(clusterKey));
    }

    @Override
    public void deleteSession(String clusterKey) {
        HazelcastConnector.getLogger().debug("Deleting session {}", (Object)clusterKey);
        this.waitForSerializationCompletion(clusterKey, "deleting");
        this.sessions.delete((Object)HazelcastConnector.getKey(clusterKey));
        this.sessions.delete((Object)HazelcastConnector.getPendingKey(clusterKey));
        HazelcastConnector.getLogger().debug("Session {} deleted", (Object)clusterKey);
    }

    private void waitForSerializationCompletion(String clusterKey, String action) {
        String pendingKey = HazelcastConnector.getPendingKey(clusterKey);
        if (this.sessions.isLocked((Object)pendingKey)) {
            HazelcastConnector.getLogger().debug("Waiting for session to be serialized before {} {}", (Object)action, (Object)clusterKey);
            try {
                this.sessions.tryLock((Object)pendingKey, 5L, TimeUnit.SECONDS, 1L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                HazelcastConnector.getLogger().warn("Gave up waiting for the serialization result of {} before {}. The host probably crashed during serialization", (Object)clusterKey, (Object)action);
            }
        }
    }

    static String getKey(String clusterKey) {
        return "session-" + clusterKey;
    }

    static String getPendingKey(String clusterKey) {
        return "pending-" + clusterKey;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(HazelcastConnector.class);
    }

    static {
        ProductUtils.markAsUsed(HazelcastConnector.class.getSimpleName());
    }
}

