/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.push;

import com.vaadin.kubernetes.starter.sessiontracker.CurrentKey;
import com.vaadin.kubernetes.starter.sessiontracker.SessionSerializer;
import com.vaadin.kubernetes.starter.sessiontracker.SessionTrackerCookie;
import com.vaadin.kubernetes.starter.sessiontracker.push.PushSendListener;
import jakarta.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushSessionTracker
implements PushSendListener {
    private final SessionSerializer sessionSerializer;

    public PushSessionTracker(SessionSerializer sessionSerializer) {
        this.sessionSerializer = sessionSerializer;
    }

    @Override
    public void onMessageSent(AtmosphereResource resource) {
        HttpSession session = resource.session(false);
        if (session != null && resource.getRequest().wrappedRequest().isRequestedSessionIdValid()) {
            SessionTrackerCookie.getValue(resource.getRequest().wrappedRequest()).ifPresent(CurrentKey::set);
            this.getLogger().debug("Serializing session {} with key {}", (Object)session.getId(), (Object)CurrentKey.get());
            try {
                this.sessionSerializer.serialize(session);
            }
            finally {
                CurrentKey.clear();
            }
        } else {
            this.getLogger().debug("Skipping session serialization. Session is invalidated");
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

