/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization;

import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientDescriptor;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientHandler;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientInjectableObjectInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SpringTransientHandler
implements TransientHandler {
    private final ApplicationContext appCtx;

    public SpringTransientHandler(ApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    @Override
    public void inject(Object obj, List<TransientDescriptor> transients) {
        Map<Class, List<TransientDescriptor>> fieldsByClass = transients.stream().collect(Collectors.groupingBy(TransientDescriptor::getDeclaringClass));
        for (Class<?> type = obj.getClass(); type != Object.class && !fieldsByClass.isEmpty(); type = type.getSuperclass()) {
            List<TransientDescriptor> descriptors = fieldsByClass.remove(type);
            if (descriptors == null) continue;
            descriptors.forEach(descr -> this.injectField(obj, (TransientDescriptor)descr));
        }
    }

    private void injectField(Object obj, TransientDescriptor descriptor) {
        SpringTransientHandler.getLogger().debug("Injecting '{}' into transient field {} of type {}", new Object[]{descriptor.getInstanceReference(), descriptor.getName(), obj.getClass()});
        ReflectTools.setJavaFieldValue((Object)obj, (Field)descriptor.getField(), (Object)this.appCtx.getBean(descriptor.getInstanceReference()));
    }

    @Override
    public List<TransientDescriptor> inspect(Object target) {
        return this.findTransientFields(target.getClass(), f -> true).stream().map(field -> this.detectBean(target, (Field)field)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private TransientDescriptor detectBean(Object target, Field field) {
        Object value = this.getFieldValue(target, field);
        if (value != null) {
            Class<?> valueType = value.getClass();
            SpringTransientHandler.getLogger().trace("Inspecting field {} of class {} for injected beans", (Object)field.getName(), target.getClass());
            TransientDescriptor transientDescriptor = this.appCtx.getBeansOfType(valueType).entrySet().stream().filter(e -> e.getValue() == value || this.matchesPrototype((String)e.getKey(), e.getValue(), valueType)).map(Map.Entry::getKey).findFirst().map(beanName -> new TransientDescriptor(field, (String)beanName)).orElse(null);
            if (transientDescriptor != null) {
                SpringTransientHandler.getLogger().trace("Bean {} found for field {} of class {}", new Object[]{transientDescriptor.getInstanceReference(), field.getName(), target.getClass()});
            } else {
                SpringTransientHandler.getLogger().trace("No bean detected for field {} of class {}", (Object)field.getName(), target.getClass());
            }
            return transientDescriptor;
        }
        SpringTransientHandler.getLogger().trace("No bean detected for field {} of class {}, field value is null", (Object)field.getName(), target.getClass());
        return null;
    }

    private boolean matchesPrototype(String beanName, Object beanDefinition, Class<?> fieldValueType) {
        return this.appCtx.isPrototype(beanName) && beanDefinition.getClass() == fieldValueType;
    }

    private Object getFieldValue(Object target, Field field) {
        try {
            field.setAccessible(true);
            return field.get(target);
        }
        catch (IllegalAccessException | InaccessibleObjectException e) {
            SpringTransientHandler.getLogger().debug("Cannot access field {} of class {}", new Object[]{field.getName(), target.getClass(), e});
            return null;
        }
    }

    private List<Field> findTransientFields(Class<?> type, Predicate<Field> includeField) {
        ArrayList<Field> transientFields = new ArrayList<Field>();
        while (type != Object.class) {
            Stream.of(type.getDeclaredFields()).filter(f -> Modifier.isTransient(f.getModifiers())).filter(includeField).collect(Collectors.toCollection(() -> transientFields));
            type = type.getSuperclass();
        }
        return transientFields;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(TransientInjectableObjectInputStream.class);
    }
}

