/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Objects;

public final class TransientDescriptor
implements Serializable {
    private final Class<?> declaringClass;
    private final String name;
    private final Class<?> type;
    private final String instanceReference;

    public TransientDescriptor(Field field, String reference) {
        this.declaringClass = field.getDeclaringClass();
        this.name = field.getName();
        this.type = field.getType();
        this.instanceReference = reference;
    }

    TransientDescriptor(Class<?> declaringClass, String name, Class<?> type, String instanceReference) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.type = type;
        this.instanceReference = instanceReference;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getInstanceReference() {
        return this.instanceReference;
    }

    public Field getField() {
        try {
            return this.declaringClass.getDeclaredField(this.name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransientDescriptor that = (TransientDescriptor)o;
        return this.declaringClass.equals(that.declaringClass) && this.name.equals(that.name) && this.type.equals(that.type) && this.instanceReference.equals(that.instanceReference);
    }

    public int hashCode() {
        return Objects.hash(this.declaringClass, this.name, this.type, this.instanceReference);
    }

    public String toString() {
        return String.format("TransientDescriptor { field: %s.%s, type: %s, instance: %s }", this.declaringClass, this.name, this.type, this.instanceReference);
    }
}

