/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization;

import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientAwareHolder;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientDescriptor;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.TransientHandler;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.DebugMode;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Track;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientInjectableObjectInputStream
extends ObjectInputStream {
    private final VarHandle passHandleHandle;
    private final MethodHandle handlesLookupObjectHandle;
    private final MethodHandle handlesSizeObjectHandle;
    private final TransientHandler injector;
    private Map<Integer, Track> tracked;

    public TransientInjectableObjectInputStream(InputStream in, TransientHandler injector) throws IOException {
        super(in);
        this.injector = injector;
        if (injector instanceof DebugMode && DebugMode.isTrackingAvailable()) {
            this.passHandleHandle = TransientInjectableObjectInputStream.tryGetHandle("passHandle", Integer.TYPE);
            this.handlesLookupObjectHandle = this.tryGetHandlesLookupObject();
            this.handlesSizeObjectHandle = this.tryGetHandlesSize();
        } else {
            this.passHandleHandle = null;
            this.handlesLookupObjectHandle = null;
            this.handlesSizeObjectHandle = null;
        }
        this.enableResolveObject(true);
    }

    @Override
    protected void readStreamHeader() throws IOException {
        this.setObjectInputFilter(new TrackingFilter());
        super.readStreamHeader();
        try {
            boolean hasTrackingData = (Boolean)this.readObject();
            if (hasTrackingData) {
                List trackList = (List)this.readObject();
                this.tracked = trackList.stream().filter(t -> t.getHandle() != -1).collect(Collectors.toMap(Track::getHandle, Function.identity()));
                super.readStreamHeader();
                this.readObject();
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(desc.getName(), false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ex) {
            return super.resolveClass(desc);
        }
    }

    public <T> T readWithTransients() throws IOException, ClassNotFoundException {
        if (this.injector instanceof DebugMode) {
            ((DebugMode)((Object)this.injector)).onDeserializationStart();
        }
        Object out = this.readObject();
        List holders = (List)this.readObject();
        holders.forEach(this::injectTransients);
        return (T)out;
    }

    @Override
    protected Object resolveObject(Object obj) {
        if (this.injector instanceof DebugMode) {
            try {
                Track track = this.lookupCurrentTrackedObject();
                obj = ((DebugMode)((Object)this.injector)).onDeserialized(obj, track);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj;
    }

    private void injectTransients(TransientAwareHolder holder) {
        Object obj = holder.source();
        if (obj != null) {
            List<TransientDescriptor> descriptors = holder.transients();
            TransientInjectableObjectInputStream.getLogger().debug("Extract injectable instance of type {} from holder object with transient descriptors: {}", obj.getClass(), descriptors);
            TransientInjectableObjectInputStream.getLogger().debug("Try injection into {}", obj.getClass());
            try {
                this.injector.inject(obj, descriptors);
            }
            catch (Exception ex) {
                TransientInjectableObjectInputStream.getLogger().error("Failed to inject transient fields into type {}", obj.getClass());
            }
        } else {
            TransientInjectableObjectInputStream.getLogger().trace("Ignoring NULL TransientAwareHolder");
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(TransientInjectableObjectInputStream.class);
    }

    private Object lookupCurrentObject() {
        if (this.passHandleHandle != null) {
            return this.lookupObject(this.passHandleHandle.get(this));
        }
        return null;
    }

    private Object lookupObject(int handle) {
        if (this.handlesLookupObjectHandle != null) {
            try {
                return this.handlesLookupObjectHandle.invoke(handle);
            }
            catch (Throwable ex) {
                TransientInjectableObjectInputStream.getLogger().trace("Cannot lookup object", ex);
            }
        }
        return null;
    }

    private int estimateNextHandle() {
        if (this.handlesSizeObjectHandle != null) {
            try {
                return this.handlesSizeObjectHandle.invoke();
            }
            catch (Throwable ex) {
                TransientInjectableObjectInputStream.getLogger().trace("Cannot guess handle by reading current size", ex);
            }
        }
        return -1;
    }

    private Track lookupCurrentTrackedObject() {
        if (this.passHandleHandle != null) {
            return this.lookupTrackedObject(this.passHandleHandle.get(this));
        }
        return null;
    }

    private Track lookupTrackedObject(int handle) {
        return this.tracked.get(handle);
    }

    private static VarHandle tryGetHandle(String name, Class<?> type) {
        try {
            return MethodHandles.privateLookupIn(ObjectInputStream.class, MethodHandles.lookup()).findVarHandle(ObjectInputStream.class, name, type);
        }
        catch (Exception ex) {
            TransientInjectableObjectInputStream.getLogger().trace("Cannot access ObjectInputStream.{} field", (Object)name, (Object)ex);
            return null;
        }
    }

    private MethodHandle tryGetHandlesLookupObject() {
        try {
            VarHandle handles = TransientInjectableObjectInputStream.tryGetHandle("handles", Class.forName("java.io.ObjectInputStream$HandleTable"));
            if (handles != null) {
                return MethodHandles.privateLookupIn(ObjectInputStream.class, MethodHandles.lookup()).findVirtual(handles.varType(), "lookupObject", MethodType.methodType(Object.class, Integer.TYPE)).bindTo(handles.get(this));
            }
        }
        catch (Exception ex) {
            TransientInjectableObjectInputStream.getLogger().trace("Cannot access ObjectOutputStream.handles.lookupObject method", (Throwable)ex);
        }
        return null;
    }

    private MethodHandle tryGetHandlesSize() {
        try {
            VarHandle handles = TransientInjectableObjectInputStream.tryGetHandle("handles", Class.forName("java.io.ObjectInputStream$HandleTable"));
            if (handles != null) {
                return MethodHandles.privateLookupIn(ObjectInputStream.class, MethodHandles.lookup()).findVirtual(handles.varType(), "size", MethodType.methodType(Integer.TYPE)).bindTo(handles.get(this));
            }
        }
        catch (Exception ex) {
            TransientInjectableObjectInputStream.getLogger().trace("Cannot access ObjectOutputStream.handles.lookupObject method", (Throwable)ex);
        }
        return null;
    }

    public static Object onDebugMode(ObjectInputStream is, Function<DebugMode, Object> action) {
        if (is instanceof TransientInjectableObjectInputStream && ((TransientInjectableObjectInputStream)is).injector instanceof DebugMode) {
            DebugMode debugMode = (DebugMode)((Object)((TransientInjectableObjectInputStream)is).injector);
            return action.apply(debugMode);
        }
        TransientInjectableObjectInputStream.getLogger().trace("Cannot get a DebugMode for {}", is.getClass());
        return null;
    }

    private final class TrackingFilter
    implements ObjectInputFilter {
        private TrackingFilter() {
        }

        @Override
        public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
            if (TransientInjectableObjectInputStream.this.injector instanceof DebugMode) {
                Track track = TransientInjectableObjectInputStream.this.lookupCurrentTrackedObject();
                Object currentObject = TransientInjectableObjectInputStream.this.lookupCurrentObject();
                Class<?> serialClass = filterInfo.serialClass();
                if (serialClass != null || track != null) {
                    if (track != null && track.depth == -1) {
                        track = track.withEstimatedDepth((int)filterInfo.depth());
                    } else if (track == null) {
                        track = Track.unknown((int)filterInfo.depth(), serialClass);
                    }
                    if (serialClass != null && currentObject == null) {
                        currentObject = ObjectStreamClass.lookup(serialClass);
                        if (track.id == -1) {
                            track = track.withEstimatedHandle(TransientInjectableObjectInputStream.this.estimateNextHandle());
                        }
                    }
                    try {
                        ((DebugMode)((Object)TransientInjectableObjectInputStream.this.injector)).onDeserialize(serialClass, track, currentObject);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return ObjectInputFilter.Status.UNDECIDED;
        }
    }
}

