/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.kubernetes.starter.sessiontracker.serialization.debug;

import com.vaadin.kubernetes.starter.sessiontracker.backend.BackendConnector;
import com.vaadin.kubernetes.starter.sessiontracker.backend.SessionInfo;
import com.vaadin.kubernetes.starter.sessiontracker.serialization.debug.Job;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

class DebugBackendConnector
implements BackendConnector {
    private final Job job;
    private SessionInfo sessionInfo;
    private CountDownLatch latch;

    public DebugBackendConnector(Job job) {
        this.job = job;
    }

    @Override
    public void sendSession(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    @Override
    public SessionInfo getSession(String clusterKey) {
        return this.sessionInfo;
    }

    @Override
    public void markSerializationStarted(String clusterKey) {
        this.latch = new CountDownLatch(1);
        this.job.serializationStarted();
    }

    @Override
    public void markSerializationComplete(String clusterKey) {
        this.job.serialized(this.sessionInfo);
        this.latch.countDown();
    }

    @Override
    public void deleteSession(String clusterKey) {
    }

    SessionInfo waitForCompletion(Logger logger) {
        int timeout = 10000;
        try {
            if (!this.latch.await(timeout, TimeUnit.MILLISECONDS)) {
                logger.error("Session Serialization did not completed in {} ms.", (Object)timeout);
            }
        }
        catch (Exception e) {
            logger.error("Testing of Session Serialization failed", (Throwable)e);
        }
        return this.sessionInfo;
    }
}

